"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.whereClauseNewLine = void 0;
const META = {
    name: 'where-clause-new-line',
    type: 'select',
};
exports.whereClauseNewLine = {
    meta: META,
    create: (context) => {
        if (!context.node.where) {
            return;
        }
        function findInvalidClauses(expr, invalidClauses = []) {
            if (['AND', 'OR', 'and', 'or'].includes(expr.operator)) {
                if (expr.left.location.start.line === expr.right.location.start.line) {
                    invalidClauses.push(expr);
                }
            }
            if (expr.left.type === 'binary_expr') {
                return findInvalidClauses(expr.left, invalidClauses);
            }
            if (expr.right.type === 'binary_expr') {
                return findInvalidClauses(expr.right, invalidClauses);
            }
            return invalidClauses;
        }
        const invalidClauses = context.node.where.expression.type === 'binary_expr'
            ? findInvalidClauses(context.node.where.expression)
            : [];
        if (invalidClauses.length === 0) {
            return;
        }
        return invalidClauses.map((v) => ({
            message: 'Multiple where clause must go on a new line.',
            location: v.location,
            fix: (fixer) => {
                const afterSpaces = context.getSQL(v.location).match(/\s+$/);
                const afterSpaceNumber = afterSpaces ? afterSpaces[0].length : 0;
                const needSpaces = Math.max(v.location.start.column - afterSpaceNumber - 1, 0);
                return [
                    fixer.replaceText(v.right.location.start.offset - 1, v.right.location.start.offset, '\n'),
                    fixer.insertText(v.right.location.start.offset, ''.padStart(needSpaces, ' ')),
                ];
            },
        }));
    },
};
//# sourceMappingURL=whereClauseNewLine.js.map