# Contributing

We absolutely welcome any code contributions and we hope that this
guide will facilitate an understanding of the PyAEDT code
repository. It is important to note that while the PyAEDT software
package is maintained by ANSYS and any submissions will be reviewed
thoroughly before merging, we still seek to foster a community that can
support user questions and develop new features to make this software
a useful tool for all users. As such, we welcome and encourage any
questions or submissions to this repository.

For contributing to this project, please refer to the [PyAnsys Developer's Guide].

[PyAnsys Developer's Guide]: https://dev.docs.pyansys.com/index.html

## Directing Issues and Features Requests

For reporting bugs and proposing new features, please use the Issues tab instead of the Discussions tab. This will help us track and prioritize work in a more organized manner.

## Purpose of Discussions

The Discussions tab should primarily be used for general questions and discussions about the project. This could include discussions about potential improvements, the future direction of the project, brainstorming ideas, help with using the software, and other topics that don't exactly fit as an Issue.

Remember, maintaining distinct places for different types of interactions helps keep our project organized and moving forward in a coordinated manner.

## Modify the Code

Everyone can contribute to this project, irrespective of their level of expertise. Your diverse skills, perspectives, and experiences are valuable and we welcome them.

Here's a simple overview of how you can start making contributions:

**Fork the Repository:** "Forking" means creating a personal copy of this repository on your GitHub account.

**Clone the Repository:** After forking, you need to download the repository to your local machine. This can be done using the `git clone` command.

**Create a New Branch:** A branch is used to isolate your changes from the main project. You can create a new branch using the `git branch` command. Remember to switch to your new branch with the `git checkout` command.

**Commit Your Changes:** After making your changes, you need to "commit" them. A commit is a packaged set of alterations. Use `git add` to add your files to staging, and then `git commit -m "your message"` to commit them.

**Push Your Changes:** After committing your changes, "push" them to your forked repository on GitHub with `git push origin <branch-name>`.

**Create a Pull Request:** A Pull Request (PR) lets us know you have changes you think should be included in the main project. Go to your forked repository on GitHub and click on the 'Pull request' button. The title of your
'Pull request' must follow the `conventional commits standard <https://github.com/commitizen/conventional-commit-types/blob/master/index.json>`_ where the type field is expected to be defined with upper cases.

Following these steps ensures that your contributions will be easily reviewed and potentially included in the project much faster.

Please don't get discouraged if you find these steps complex, we are here to help you throughout the process.

We hope these rules will make the Discussions section a better place for every contributor.
