# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CellularCedgeProfileFeatureTemplateArgs', 'CellularCedgeProfileFeatureTemplate']

@pulumi.input_type
class CellularCedgeProfileFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 access_point_name: Optional[pulumi.Input[str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[str]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_overwrite: Optional[pulumi.Input[bool]] = None,
                 no_overwrite_variable: Optional[pulumi.Input[str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[str]] = None,
                 profile_id: Optional[pulumi.Input[int]] = None,
                 profile_id_variable: Optional[pulumi.Input[str]] = None,
                 profile_password: Optional[pulumi.Input[str]] = None,
                 profile_password_variable: Optional[pulumi.Input[str]] = None,
                 profile_username: Optional[pulumi.Input[str]] = None,
                 profile_username_variable: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CellularCedgeProfileFeatureTemplate resource.
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] access_point_name: Set access point name
        :param pulumi.Input[str] access_point_name_variable: Variable name
        :param pulumi.Input[str] authentication_type: Set authentication type - Choices: `none`, `pap`, `chap`, `pap_chap` - Default value: `none`
        :param pulumi.Input[str] authentication_type_variable: Variable name
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] no_overwrite: No Overwrite
        :param pulumi.Input[str] no_overwrite_variable: Variable name
        :param pulumi.Input[str] packet_data_network_type: Set packet data network type - Choices: `ipv4`, `ipv4v6`, `ipv6` - Default value: `ipv4`
        :param pulumi.Input[str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[int] profile_id: Set Profile ID - Range: `1`-`16`
        :param pulumi.Input[str] profile_id_variable: Variable name
        :param pulumi.Input[str] profile_password: Set the profile password
        :param pulumi.Input[str] profile_password_variable: Variable name
        :param pulumi.Input[str] profile_username: Set the profile username
        :param pulumi.Input[str] profile_username_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if access_point_name is not None:
            pulumi.set(__self__, "access_point_name", access_point_name)
        if access_point_name_variable is not None:
            pulumi.set(__self__, "access_point_name_variable", access_point_name_variable)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_overwrite is not None:
            pulumi.set(__self__, "no_overwrite", no_overwrite)
        if no_overwrite_variable is not None:
            pulumi.set(__self__, "no_overwrite_variable", no_overwrite_variable)
        if packet_data_network_type is not None:
            pulumi.set(__self__, "packet_data_network_type", packet_data_network_type)
        if packet_data_network_type_variable is not None:
            pulumi.set(__self__, "packet_data_network_type_variable", packet_data_network_type_variable)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if profile_id_variable is not None:
            pulumi.set(__self__, "profile_id_variable", profile_id_variable)
        if profile_password is not None:
            pulumi.set(__self__, "profile_password", profile_password)
        if profile_password_variable is not None:
            pulumi.set(__self__, "profile_password_variable", profile_password_variable)
        if profile_username is not None:
            pulumi.set(__self__, "profile_username", profile_username)
        if profile_username_variable is not None:
            pulumi.set(__self__, "profile_username_variable", profile_username_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> Optional[pulumi.Input[str]]:
        """
        Set access point name
        """
        return pulumi.get(self, "access_point_name")

    @access_point_name.setter
    def access_point_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_point_name", value)

    @property
    @pulumi.getter(name="accessPointNameVariable")
    def access_point_name_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "access_point_name_variable")

    @access_point_name_variable.setter
    def access_point_name_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_point_name_variable", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set authentication type - Choices: `none`, `pap`, `chap`, `pap_chap` - Default value: `none`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noOverwrite")
    def no_overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        No Overwrite
        """
        return pulumi.get(self, "no_overwrite")

    @no_overwrite.setter
    def no_overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_overwrite", value)

    @property
    @pulumi.getter(name="noOverwriteVariable")
    def no_overwrite_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "no_overwrite_variable")

    @no_overwrite_variable.setter
    def no_overwrite_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "no_overwrite_variable", value)

    @property
    @pulumi.getter(name="packetDataNetworkType")
    def packet_data_network_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set packet data network type - Choices: `ipv4`, `ipv4v6`, `ipv6` - Default value: `ipv4`
        """
        return pulumi.get(self, "packet_data_network_type")

    @packet_data_network_type.setter
    def packet_data_network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "packet_data_network_type", value)

    @property
    @pulumi.getter(name="packetDataNetworkTypeVariable")
    def packet_data_network_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "packet_data_network_type_variable")

    @packet_data_network_type_variable.setter
    def packet_data_network_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "packet_data_network_type_variable", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set Profile ID - Range: `1`-`16`
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter(name="profileIdVariable")
    def profile_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_id_variable")

    @profile_id_variable.setter
    def profile_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_id_variable", value)

    @property
    @pulumi.getter(name="profilePassword")
    def profile_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set the profile password
        """
        return pulumi.get(self, "profile_password")

    @profile_password.setter
    def profile_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_password", value)

    @property
    @pulumi.getter(name="profilePasswordVariable")
    def profile_password_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_password_variable")

    @profile_password_variable.setter
    def profile_password_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_password_variable", value)

    @property
    @pulumi.getter(name="profileUsername")
    def profile_username(self) -> Optional[pulumi.Input[str]]:
        """
        Set the profile username
        """
        return pulumi.get(self, "profile_username")

    @profile_username.setter
    def profile_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_username", value)

    @property
    @pulumi.getter(name="profileUsernameVariable")
    def profile_username_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_username_variable")

    @profile_username_variable.setter
    def profile_username_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_username_variable", value)


@pulumi.input_type
class _CellularCedgeProfileFeatureTemplateState:
    def __init__(__self__, *,
                 access_point_name: Optional[pulumi.Input[str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[str]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_overwrite: Optional[pulumi.Input[bool]] = None,
                 no_overwrite_variable: Optional[pulumi.Input[str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[str]] = None,
                 profile_id: Optional[pulumi.Input[int]] = None,
                 profile_id_variable: Optional[pulumi.Input[str]] = None,
                 profile_password: Optional[pulumi.Input[str]] = None,
                 profile_password_variable: Optional[pulumi.Input[str]] = None,
                 profile_username: Optional[pulumi.Input[str]] = None,
                 profile_username_variable: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CellularCedgeProfileFeatureTemplate resources.
        :param pulumi.Input[str] access_point_name: Set access point name
        :param pulumi.Input[str] access_point_name_variable: Variable name
        :param pulumi.Input[str] authentication_type: Set authentication type - Choices: `none`, `pap`, `chap`, `pap_chap` - Default value: `none`
        :param pulumi.Input[str] authentication_type_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] no_overwrite: No Overwrite
        :param pulumi.Input[str] no_overwrite_variable: Variable name
        :param pulumi.Input[str] packet_data_network_type: Set packet data network type - Choices: `ipv4`, `ipv4v6`, `ipv6` - Default value: `ipv4`
        :param pulumi.Input[str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[int] profile_id: Set Profile ID - Range: `1`-`16`
        :param pulumi.Input[str] profile_id_variable: Variable name
        :param pulumi.Input[str] profile_password: Set the profile password
        :param pulumi.Input[str] profile_password_variable: Variable name
        :param pulumi.Input[str] profile_username: Set the profile username
        :param pulumi.Input[str] profile_username_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        if access_point_name is not None:
            pulumi.set(__self__, "access_point_name", access_point_name)
        if access_point_name_variable is not None:
            pulumi.set(__self__, "access_point_name_variable", access_point_name_variable)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_overwrite is not None:
            pulumi.set(__self__, "no_overwrite", no_overwrite)
        if no_overwrite_variable is not None:
            pulumi.set(__self__, "no_overwrite_variable", no_overwrite_variable)
        if packet_data_network_type is not None:
            pulumi.set(__self__, "packet_data_network_type", packet_data_network_type)
        if packet_data_network_type_variable is not None:
            pulumi.set(__self__, "packet_data_network_type_variable", packet_data_network_type_variable)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if profile_id_variable is not None:
            pulumi.set(__self__, "profile_id_variable", profile_id_variable)
        if profile_password is not None:
            pulumi.set(__self__, "profile_password", profile_password)
        if profile_password_variable is not None:
            pulumi.set(__self__, "profile_password_variable", profile_password_variable)
        if profile_username is not None:
            pulumi.set(__self__, "profile_username", profile_username)
        if profile_username_variable is not None:
            pulumi.set(__self__, "profile_username_variable", profile_username_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> Optional[pulumi.Input[str]]:
        """
        Set access point name
        """
        return pulumi.get(self, "access_point_name")

    @access_point_name.setter
    def access_point_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_point_name", value)

    @property
    @pulumi.getter(name="accessPointNameVariable")
    def access_point_name_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "access_point_name_variable")

    @access_point_name_variable.setter
    def access_point_name_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_point_name_variable", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set authentication type - Choices: `none`, `pap`, `chap`, `pap_chap` - Default value: `none`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noOverwrite")
    def no_overwrite(self) -> Optional[pulumi.Input[bool]]:
        """
        No Overwrite
        """
        return pulumi.get(self, "no_overwrite")

    @no_overwrite.setter
    def no_overwrite(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_overwrite", value)

    @property
    @pulumi.getter(name="noOverwriteVariable")
    def no_overwrite_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "no_overwrite_variable")

    @no_overwrite_variable.setter
    def no_overwrite_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "no_overwrite_variable", value)

    @property
    @pulumi.getter(name="packetDataNetworkType")
    def packet_data_network_type(self) -> Optional[pulumi.Input[str]]:
        """
        Set packet data network type - Choices: `ipv4`, `ipv4v6`, `ipv6` - Default value: `ipv4`
        """
        return pulumi.get(self, "packet_data_network_type")

    @packet_data_network_type.setter
    def packet_data_network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "packet_data_network_type", value)

    @property
    @pulumi.getter(name="packetDataNetworkTypeVariable")
    def packet_data_network_type_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "packet_data_network_type_variable")

    @packet_data_network_type_variable.setter
    def packet_data_network_type_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "packet_data_network_type_variable", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[int]]:
        """
        Set Profile ID - Range: `1`-`16`
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter(name="profileIdVariable")
    def profile_id_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_id_variable")

    @profile_id_variable.setter
    def profile_id_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_id_variable", value)

    @property
    @pulumi.getter(name="profilePassword")
    def profile_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set the profile password
        """
        return pulumi.get(self, "profile_password")

    @profile_password.setter
    def profile_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_password", value)

    @property
    @pulumi.getter(name="profilePasswordVariable")
    def profile_password_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_password_variable")

    @profile_password_variable.setter
    def profile_password_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_password_variable", value)

    @property
    @pulumi.getter(name="profileUsername")
    def profile_username(self) -> Optional[pulumi.Input[str]]:
        """
        Set the profile username
        """
        return pulumi.get(self, "profile_username")

    @profile_username.setter
    def profile_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_username", value)

    @property
    @pulumi.getter(name="profileUsernameVariable")
    def profile_username_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_username_variable")

    @profile_username_variable.setter
    def profile_username_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_username_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CellularCedgeProfileFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_name: Optional[pulumi.Input[str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[str]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_overwrite: Optional[pulumi.Input[bool]] = None,
                 no_overwrite_variable: Optional[pulumi.Input[str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[str]] = None,
                 profile_id: Optional[pulumi.Input[int]] = None,
                 profile_id_variable: Optional[pulumi.Input[str]] = None,
                 profile_password: Optional[pulumi.Input[str]] = None,
                 profile_password_variable: Optional[pulumi.Input[str]] = None,
                 profile_username: Optional[pulumi.Input[str]] = None,
                 profile_username_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Cellular cEdge Profile feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CellularCedgeProfileFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            profile_id=1,
            access_point_name="APN1",
            authentication_type="chap",
            packet_data_network_type="ipv4",
            profile_username="MyUsername",
            profile_password="MyPassword",
            no_overwrite=False)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/cellularCedgeProfileFeatureTemplate:CellularCedgeProfileFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_point_name: Set access point name
        :param pulumi.Input[str] access_point_name_variable: Variable name
        :param pulumi.Input[str] authentication_type: Set authentication type - Choices: `none`, `pap`, `chap`, `pap_chap` - Default value: `none`
        :param pulumi.Input[str] authentication_type_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] no_overwrite: No Overwrite
        :param pulumi.Input[str] no_overwrite_variable: Variable name
        :param pulumi.Input[str] packet_data_network_type: Set packet data network type - Choices: `ipv4`, `ipv4v6`, `ipv6` - Default value: `ipv4`
        :param pulumi.Input[str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[int] profile_id: Set Profile ID - Range: `1`-`16`
        :param pulumi.Input[str] profile_id_variable: Variable name
        :param pulumi.Input[str] profile_password: Set the profile password
        :param pulumi.Input[str] profile_password_variable: Variable name
        :param pulumi.Input[str] profile_username: Set the profile username
        :param pulumi.Input[str] profile_username_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CellularCedgeProfileFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cellular cEdge Profile feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CellularCedgeProfileFeatureTemplate("example",
            name="Example",
            description="My Example",
            device_types=["vedge-C8000V"],
            profile_id=1,
            access_point_name="APN1",
            authentication_type="chap",
            packet_data_network_type="ipv4",
            profile_username="MyUsername",
            profile_password="MyPassword",
            no_overwrite=False)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/cellularCedgeProfileFeatureTemplate:CellularCedgeProfileFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CellularCedgeProfileFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CellularCedgeProfileFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_name: Optional[pulumi.Input[str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[str]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_overwrite: Optional[pulumi.Input[bool]] = None,
                 no_overwrite_variable: Optional[pulumi.Input[str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[str]] = None,
                 profile_id: Optional[pulumi.Input[int]] = None,
                 profile_id_variable: Optional[pulumi.Input[str]] = None,
                 profile_password: Optional[pulumi.Input[str]] = None,
                 profile_password_variable: Optional[pulumi.Input[str]] = None,
                 profile_username: Optional[pulumi.Input[str]] = None,
                 profile_username_variable: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CellularCedgeProfileFeatureTemplateArgs.__new__(CellularCedgeProfileFeatureTemplateArgs)

            __props__.__dict__["access_point_name"] = access_point_name
            __props__.__dict__["access_point_name_variable"] = access_point_name_variable
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["authentication_type_variable"] = authentication_type_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["name"] = name
            __props__.__dict__["no_overwrite"] = no_overwrite
            __props__.__dict__["no_overwrite_variable"] = no_overwrite_variable
            __props__.__dict__["packet_data_network_type"] = packet_data_network_type
            __props__.__dict__["packet_data_network_type_variable"] = packet_data_network_type_variable
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["profile_id_variable"] = profile_id_variable
            __props__.__dict__["profile_password"] = profile_password
            __props__.__dict__["profile_password_variable"] = profile_password_variable
            __props__.__dict__["profile_username"] = profile_username
            __props__.__dict__["profile_username_variable"] = profile_username_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CellularCedgeProfileFeatureTemplate, __self__).__init__(
            'sdwan:index/cellularCedgeProfileFeatureTemplate:CellularCedgeProfileFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_point_name: Optional[pulumi.Input[str]] = None,
            access_point_name_variable: Optional[pulumi.Input[str]] = None,
            authentication_type: Optional[pulumi.Input[str]] = None,
            authentication_type_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            no_overwrite: Optional[pulumi.Input[bool]] = None,
            no_overwrite_variable: Optional[pulumi.Input[str]] = None,
            packet_data_network_type: Optional[pulumi.Input[str]] = None,
            packet_data_network_type_variable: Optional[pulumi.Input[str]] = None,
            profile_id: Optional[pulumi.Input[int]] = None,
            profile_id_variable: Optional[pulumi.Input[str]] = None,
            profile_password: Optional[pulumi.Input[str]] = None,
            profile_password_variable: Optional[pulumi.Input[str]] = None,
            profile_username: Optional[pulumi.Input[str]] = None,
            profile_username_variable: Optional[pulumi.Input[str]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CellularCedgeProfileFeatureTemplate':
        """
        Get an existing CellularCedgeProfileFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_point_name: Set access point name
        :param pulumi.Input[str] access_point_name_variable: Variable name
        :param pulumi.Input[str] authentication_type: Set authentication type - Choices: `none`, `pap`, `chap`, `pap_chap` - Default value: `none`
        :param pulumi.Input[str] authentication_type_variable: Variable name
        :param pulumi.Input[str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[str] name: The name of the feature template
        :param pulumi.Input[bool] no_overwrite: No Overwrite
        :param pulumi.Input[str] no_overwrite_variable: Variable name
        :param pulumi.Input[str] packet_data_network_type: Set packet data network type - Choices: `ipv4`, `ipv4v6`, `ipv6` - Default value: `ipv4`
        :param pulumi.Input[str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[int] profile_id: Set Profile ID - Range: `1`-`16`
        :param pulumi.Input[str] profile_id_variable: Variable name
        :param pulumi.Input[str] profile_password: Set the profile password
        :param pulumi.Input[str] profile_password_variable: Variable name
        :param pulumi.Input[str] profile_username: Set the profile username
        :param pulumi.Input[str] profile_username_variable: Variable name
        :param pulumi.Input[str] template_type: The template type
        :param pulumi.Input[int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CellularCedgeProfileFeatureTemplateState.__new__(_CellularCedgeProfileFeatureTemplateState)

        __props__.__dict__["access_point_name"] = access_point_name
        __props__.__dict__["access_point_name_variable"] = access_point_name_variable
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["authentication_type_variable"] = authentication_type_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["name"] = name
        __props__.__dict__["no_overwrite"] = no_overwrite
        __props__.__dict__["no_overwrite_variable"] = no_overwrite_variable
        __props__.__dict__["packet_data_network_type"] = packet_data_network_type
        __props__.__dict__["packet_data_network_type_variable"] = packet_data_network_type_variable
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["profile_id_variable"] = profile_id_variable
        __props__.__dict__["profile_password"] = profile_password
        __props__.__dict__["profile_password_variable"] = profile_password_variable
        __props__.__dict__["profile_username"] = profile_username
        __props__.__dict__["profile_username_variable"] = profile_username_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CellularCedgeProfileFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> pulumi.Output[Optional[str]]:
        """
        Set access point name
        """
        return pulumi.get(self, "access_point_name")

    @property
    @pulumi.getter(name="accessPointNameVariable")
    def access_point_name_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "access_point_name_variable")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[str]]:
        """
        Set authentication type - Choices: `none`, `pap`, `chap`, `pap_chap` - Default value: `none`
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_type_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noOverwrite")
    def no_overwrite(self) -> pulumi.Output[Optional[bool]]:
        """
        No Overwrite
        """
        return pulumi.get(self, "no_overwrite")

    @property
    @pulumi.getter(name="noOverwriteVariable")
    def no_overwrite_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "no_overwrite_variable")

    @property
    @pulumi.getter(name="packetDataNetworkType")
    def packet_data_network_type(self) -> pulumi.Output[Optional[str]]:
        """
        Set packet data network type - Choices: `ipv4`, `ipv4v6`, `ipv6` - Default value: `ipv4`
        """
        return pulumi.get(self, "packet_data_network_type")

    @property
    @pulumi.getter(name="packetDataNetworkTypeVariable")
    def packet_data_network_type_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "packet_data_network_type_variable")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[Optional[int]]:
        """
        Set Profile ID - Range: `1`-`16`
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter(name="profileIdVariable")
    def profile_id_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_id_variable")

    @property
    @pulumi.getter(name="profilePassword")
    def profile_password(self) -> pulumi.Output[Optional[str]]:
        """
        Set the profile password
        """
        return pulumi.get(self, "profile_password")

    @property
    @pulumi.getter(name="profilePasswordVariable")
    def profile_password_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_password_variable")

    @property
    @pulumi.getter(name="profileUsername")
    def profile_username(self) -> pulumi.Output[Optional[str]]:
        """
        Set the profile username
        """
        return pulumi.get(self, "profile_username")

    @property
    @pulumi.getter(name="profileUsernameVariable")
    def profile_username_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_username_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

