# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CliConfigProfileParcelArgs', 'CliConfigProfileParcel']

@pulumi.input_type
class CliConfigProfileParcelArgs:
    def __init__(__self__, *,
                 cli_configuration: pulumi.Input[str],
                 description: pulumi.Input[str],
                 feature_profile_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CliConfigProfileParcel resource.
        :param pulumi.Input[str] cli_configuration: CLI configuration
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        """
        pulumi.set(__self__, "cli_configuration", cli_configuration)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cliConfiguration")
    def cli_configuration(self) -> pulumi.Input[str]:
        """
        CLI configuration
        """
        return pulumi.get(self, "cli_configuration")

    @cli_configuration.setter
    def cli_configuration(self, value: pulumi.Input[str]):
        pulumi.set(self, "cli_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CliConfigProfileParcelState:
    def __init__(__self__, *,
                 cli_configuration: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CliConfigProfileParcel resources.
        :param pulumi.Input[str] cli_configuration: CLI configuration
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[int] version: The version of the object
        """
        if cli_configuration is not None:
            pulumi.set(__self__, "cli_configuration", cli_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cliConfiguration")
    def cli_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        CLI configuration
        """
        return pulumi.get(self, "cli_configuration")

    @cli_configuration.setter
    def cli_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cli_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class CliConfigProfileParcel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cli_configuration: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a CLI Config Profile Parcel .
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CliConfigProfileParcel("example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            name="Example",
            description="My Example",
            cli_configuration=\"\"\"bfd default-dscp 48
        bfd app-route multiplier 6
        bfd app-route poll-interval 600000\"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/cliConfigProfileParcel:CliConfigProfileParcel example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cli_configuration: CLI configuration
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CliConfigProfileParcelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a CLI Config Profile Parcel .
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.CliConfigProfileParcel("example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            name="Example",
            description="My Example",
            cli_configuration=\"\"\"bfd default-dscp 48
        bfd app-route multiplier 6
        bfd app-route poll-interval 600000\"\"\")
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/cliConfigProfileParcel:CliConfigProfileParcel example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CliConfigProfileParcelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CliConfigProfileParcelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cli_configuration: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CliConfigProfileParcelArgs.__new__(CliConfigProfileParcelArgs)

            if cli_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'cli_configuration'")
            __props__.__dict__["cli_configuration"] = cli_configuration
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["version"] = None
        super(CliConfigProfileParcel, __self__).__init__(
            'sdwan:index/cliConfigProfileParcel:CliConfigProfileParcel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cli_configuration: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_profile_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'CliConfigProfileParcel':
        """
        Get an existing CliConfigProfileParcel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cli_configuration: CLI configuration
        :param pulumi.Input[str] description: The description of the profile parcel
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[str] name: The name of the profile parcel
        :param pulumi.Input[int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CliConfigProfileParcelState.__new__(_CliConfigProfileParcelState)

        __props__.__dict__["cli_configuration"] = cli_configuration
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["version"] = version
        return CliConfigProfileParcel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cliConfiguration")
    def cli_configuration(self) -> pulumi.Output[str]:
        """
        CLI configuration
        """
        return pulumi.get(self, "cli_configuration")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the profile parcel
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the profile parcel
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

