"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlProvider = exports.SamlMetadataDocument = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const core_1 = require("@aws-cdk/core");
const iam_generated_1 = require("./iam.generated");
/**
 * A SAML metadata document
 */
class SamlMetadataDocument {
    /**
     * Create a SAML metadata document from a XML string
     */
    static fromXml(xml) {
        return { xml };
    }
    /**
     * Create a SAML metadata document from a XML file
     */
    static fromFile(path) {
        return { xml: fs.readFileSync(path, 'utf-8') };
    }
}
exports.SamlMetadataDocument = SamlMetadataDocument;
_a = JSII_RTTI_SYMBOL_1;
SamlMetadataDocument[_a] = { fqn: "@aws-cdk/aws-iam.SamlMetadataDocument", version: "1.145.0" };
/**
 * A SAML provider
 */
class SamlProvider extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_iam_SamlProviderProps(props);
        if (props.name && !core_1.Token.isUnresolved(props.name) && !/^[\w+=,.@-]{1,128}$/.test(props.name)) {
            throw new Error('Invalid SAML provider name. The name must be a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Length must be between 1 and 128 characters.');
        }
        const samlProvider = new iam_generated_1.CfnSAMLProvider(this, 'Resource', {
            name: props.name,
            samlMetadataDocument: props.metadataDocument.xml,
        });
        this.samlProviderArn = samlProvider.ref;
    }
    /**
     * Import an existing provider
     */
    static fromSamlProviderArn(scope, id, samlProviderArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.samlProviderArn = samlProviderArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.SamlProvider = SamlProvider;
_b = JSII_RTTI_SYMBOL_1;
SamlProvider[_b] = { fqn: "@aws-cdk/aws-iam.SamlProvider", version: "1.145.0" };
//# sourceMappingURL=data:application/json;base64,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