import typing
import collections.abc
import bpy.types

GenericType1 = typing.TypeVar("GenericType1")
GenericType2 = typing.TypeVar("GenericType2")

def armature_apply(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    selected: bool | typing.Any | None = False,
):
    """Apply the current pose as the new rest pose

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param selected: Selected Only, Only apply the selected bones (with propagation to children)
    :type selected: bool | typing.Any | None
    """

    ...

def autoside_names(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    axis: str | None = "XAXIS",
):
    """Automatically renames the selected bones according to which side of the target axis they fall on

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param axis: Axis, Axis tag names with

    XAXIS
    X-Axis -- Left/Right.

    YAXIS
    Y-Axis -- Front/Back.

    ZAXIS
    Z-Axis -- Top/Bottom.
        :type axis: str | None
    """

    ...

def blend_to_neighbor(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    factor: typing.Any | None = 0.5,
    prev_frame: typing.Any | None = 0,
    next_frame: typing.Any | None = 0,
    channels: str | None = "ALL",
    axis_lock: str | None = "FREE",
):
    """Blend from current position to previous or next keyframe

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param factor: Factor, Weighting factor for which keyframe is favored more
        :type factor: typing.Any | None
        :param prev_frame: Previous Keyframe, Frame number of keyframe immediately before the current frame
        :type prev_frame: typing.Any | None
        :param next_frame: Next Keyframe, Frame number of keyframe immediately after the current frame
        :type next_frame: typing.Any | None
        :param channels: Channels, Set of properties that are affected

    ALL
    All Properties -- All properties, including transforms, bendy bone shape, and custom properties.

    LOC
    Location -- Location only.

    ROT
    Rotation -- Rotation only.

    SIZE
    Scale -- Scale only.

    BBONE
    Bendy Bone -- Bendy Bone shape properties.

    CUSTOM
    Custom Properties -- Custom properties.
        :type channels: str | None
        :param axis_lock: Axis Lock, Transform axis to restrict effects to

    FREE
    Free -- All axes are affected.

    X
    X -- Only X-axis transforms are affected.

    Y
    Y -- Only Y-axis transforms are affected.

    Z
    Z -- Only Z-axis transforms are affected.
        :type axis_lock: str | None
    """

    ...

def bone_layers(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    layers: list[bool] | typing.Any | None = (
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
        False,
    ),
):
    """Change the layers that the selected bones belong to

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param layers: Layer, Armature layers that bone belongs to
    :type layers: list[bool] | typing.Any | None
    """

    ...

def breakdown(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    factor: typing.Any | None = 0.5,
    prev_frame: typing.Any | None = 0,
    next_frame: typing.Any | None = 0,
    channels: str | None = "ALL",
    axis_lock: str | None = "FREE",
):
    """Create a suitable breakdown pose on the current frame

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param factor: Factor, Weighting factor for which keyframe is favored more
        :type factor: typing.Any | None
        :param prev_frame: Previous Keyframe, Frame number of keyframe immediately before the current frame
        :type prev_frame: typing.Any | None
        :param next_frame: Next Keyframe, Frame number of keyframe immediately after the current frame
        :type next_frame: typing.Any | None
        :param channels: Channels, Set of properties that are affected

    ALL
    All Properties -- All properties, including transforms, bendy bone shape, and custom properties.

    LOC
    Location -- Location only.

    ROT
    Rotation -- Rotation only.

    SIZE
    Scale -- Scale only.

    BBONE
    Bendy Bone -- Bendy Bone shape properties.

    CUSTOM
    Custom Properties -- Custom properties.
        :type channels: str | None
        :param axis_lock: Axis Lock, Transform axis to restrict effects to

    FREE
    Free -- All axes are affected.

    X
    X -- Only X-axis transforms are affected.

    Y
    Y -- Only Y-axis transforms are affected.

    Z
    Z -- Only Z-axis transforms are affected.
        :type axis_lock: str | None
    """

    ...

def constraint_add(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    type: str | None = "",
):
    """Add a constraint to the active bone

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param type: Type

    CAMERA_SOLVER
    Camera Solver.

    FOLLOW_TRACK
    Follow Track.

    OBJECT_SOLVER
    Object Solver.

    COPY_LOCATION
    Copy Location -- Copy the location of a target (with an optional offset), so that they move together.

    COPY_ROTATION
    Copy Rotation -- Copy the rotation of a target (with an optional offset), so that they rotate together.

    COPY_SCALE
    Copy Scale -- Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount.

    COPY_TRANSFORMS
    Copy Transforms -- Copy all the transformations of a target, so that they move together.

    LIMIT_DISTANCE
    Limit Distance -- Restrict movements to within a certain distance of a target (at the time of constraint evaluation only).

    LIMIT_LOCATION
    Limit Location -- Restrict movement along each axis within given ranges.

    LIMIT_ROTATION
    Limit Rotation -- Restrict rotation along each axis within given ranges.

    LIMIT_SCALE
    Limit Scale -- Restrict scaling along each axis with given ranges.

    MAINTAIN_VOLUME
    Maintain Volume -- Compensate for scaling one axis by applying suitable scaling to the other two axes.

    TRANSFORM
    Transformation -- Use one transform property from target to control another (or same) property on owner.

    TRANSFORM_CACHE
    Transform Cache -- Look up the transformation matrix from an external file.

    CLAMP_TO
    Clamp To -- Restrict movements to lie along a curve by remapping location along curve's longest axis.

    DAMPED_TRACK
    Damped Track -- Point towards a target by performing the smallest rotation necessary.

    IK
    Inverse Kinematics -- Control a chain of bones by specifying the endpoint target (Bones only).

    LOCKED_TRACK
    Locked Track -- Rotate around the specified ('locked') axis to point towards a target.

    SPLINE_IK
    Spline IK -- Align chain of bones along a curve (Bones only).

    STRETCH_TO
    Stretch To -- Stretch along Y-Axis to point towards a target.

    TRACK_TO
    Track To -- Legacy tracking constraint prone to twisting artifacts.

    ACTION
    Action -- Use transform property of target to look up pose for owner from an Action.

    ARMATURE
    Armature -- Apply weight-blended transformation from multiple bones like the Armature modifier.

    CHILD_OF
    Child Of -- Make target the 'detachable' parent of owner.

    FLOOR
    Floor -- Use position (and optionally rotation) of target to define a 'wall' or 'floor' that the owner can not cross.

    FOLLOW_PATH
    Follow Path -- Use to animate an object/bone following a path.

    PIVOT
    Pivot -- Change pivot point for transforms (buggy).

    SHRINKWRAP
    Shrinkwrap -- Restrict movements to surface of target mesh.
        :type type: str | None
    """

    ...

def constraint_add_with_targets(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    type: str | None = "",
):
    """Add a constraint to the active bone, with target (where applicable) set to the selected Objects/Bones

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param type: Type

    CAMERA_SOLVER
    Camera Solver.

    FOLLOW_TRACK
    Follow Track.

    OBJECT_SOLVER
    Object Solver.

    COPY_LOCATION
    Copy Location -- Copy the location of a target (with an optional offset), so that they move together.

    COPY_ROTATION
    Copy Rotation -- Copy the rotation of a target (with an optional offset), so that they rotate together.

    COPY_SCALE
    Copy Scale -- Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount.

    COPY_TRANSFORMS
    Copy Transforms -- Copy all the transformations of a target, so that they move together.

    LIMIT_DISTANCE
    Limit Distance -- Restrict movements to within a certain distance of a target (at the time of constraint evaluation only).

    LIMIT_LOCATION
    Limit Location -- Restrict movement along each axis within given ranges.

    LIMIT_ROTATION
    Limit Rotation -- Restrict rotation along each axis within given ranges.

    LIMIT_SCALE
    Limit Scale -- Restrict scaling along each axis with given ranges.

    MAINTAIN_VOLUME
    Maintain Volume -- Compensate for scaling one axis by applying suitable scaling to the other two axes.

    TRANSFORM
    Transformation -- Use one transform property from target to control another (or same) property on owner.

    TRANSFORM_CACHE
    Transform Cache -- Look up the transformation matrix from an external file.

    CLAMP_TO
    Clamp To -- Restrict movements to lie along a curve by remapping location along curve's longest axis.

    DAMPED_TRACK
    Damped Track -- Point towards a target by performing the smallest rotation necessary.

    IK
    Inverse Kinematics -- Control a chain of bones by specifying the endpoint target (Bones only).

    LOCKED_TRACK
    Locked Track -- Rotate around the specified ('locked') axis to point towards a target.

    SPLINE_IK
    Spline IK -- Align chain of bones along a curve (Bones only).

    STRETCH_TO
    Stretch To -- Stretch along Y-Axis to point towards a target.

    TRACK_TO
    Track To -- Legacy tracking constraint prone to twisting artifacts.

    ACTION
    Action -- Use transform property of target to look up pose for owner from an Action.

    ARMATURE
    Armature -- Apply weight-blended transformation from multiple bones like the Armature modifier.

    CHILD_OF
    Child Of -- Make target the 'detachable' parent of owner.

    FLOOR
    Floor -- Use position (and optionally rotation) of target to define a 'wall' or 'floor' that the owner can not cross.

    FOLLOW_PATH
    Follow Path -- Use to animate an object/bone following a path.

    PIVOT
    Pivot -- Change pivot point for transforms (buggy).

    SHRINKWRAP
    Shrinkwrap -- Restrict movements to surface of target mesh.
        :type type: str | None
    """

    ...

def constraints_clear(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Clear all the constraints for the selected bones

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def constraints_copy(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Copy constraints to other selected bones

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def copy(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Copies the current pose of the selected bones to copy/paste buffer

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def flip_names(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    do_strip_numbers: bool | typing.Any | None = False,
):
    """Flips (and corrects) the axis suffixes of the names of selected bones

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param do_strip_numbers: Strip Numbers, Try to remove right-most dot-number from flipped names.
    Warning: May result in incoherent naming in some cases
        :type do_strip_numbers: bool | typing.Any | None
    """

    ...

def group_add(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Add a new bone group

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def group_assign(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    type: typing.Any | None = 0,
):
    """Add selected bones to the chosen bone group

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param type: Bone Group Index
    :type type: typing.Any | None
    """

    ...

def group_deselect(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Deselect bones of active Bone Group

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def group_move(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    direction: str | None = "UP",
):
    """Change position of active Bone Group in list of Bone Groups

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param direction: Direction, Direction to move the active Bone Group towards
    :type direction: str | None
    """

    ...

def group_remove(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Remove the active bone group

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def group_select(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Select bones in active Bone Group

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def group_sort(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Sort Bone Groups by their names in ascending order

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def group_unassign(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Remove selected bones from all bone groups

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def hide(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    unselected: bool | typing.Any | None = False,
):
    """Tag selected bones to not be visible in Pose Mode

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param unselected: Unselected
    :type unselected: bool | typing.Any | None
    """

    ...

def ik_add(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    with_targets: bool | typing.Any | None = True,
):
    """Add IK Constraint to the active Bone

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param with_targets: With Targets, Assign IK Constraint with targets derived from the select bones/objects
    :type with_targets: bool | typing.Any | None
    """

    ...

def ik_clear(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Remove all IK Constraints from selected bones

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def loc_clear(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Reset locations of selected bones to their default values

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def paste(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    flipped: bool | typing.Any | None = False,
    selected_mask: bool | typing.Any | None = False,
):
    """Paste the stored pose on to the current pose

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param flipped: Flipped on X-Axis, Paste the stored pose flipped on to current pose
    :type flipped: bool | typing.Any | None
    :param selected_mask: On Selected Only, Only paste the stored pose on to selected bones in the current pose
    :type selected_mask: bool | typing.Any | None
    """

    ...

def paths_calculate(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    display_type: str | None = "RANGE",
    range: str | None = "SCENE",
    bake_location: str | None = "HEADS",
):
    """Calculate paths for the selected bones

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param display_type: Display type

    CURRENT_FRAME
    Around Frame -- Display Paths of poses within a fixed number of frames around the current frame.

    RANGE
    In Range -- Display Paths of poses within specified range.
        :type display_type: str | None
        :param range: Computation Range

    KEYS_ALL
    All Keys -- From the first keyframe to the last.

    KEYS_SELECTED
    Selected Keys -- From the first selected keyframe to the last.

    SCENE
    Scene Frame Range -- The entire Scene / Preview range.
        :type range: str | None
        :param bake_location: Bake Location, Which point on the bones is used when calculating paths

    HEADS
    Heads -- Calculate bone paths from heads.

    TAILS
    Tails -- Calculate bone paths from tails.
        :type bake_location: str | None
    """

    ...

def paths_clear(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    only_selected: bool | typing.Any | None = False,
):
    """Clear path caches for all bones, hold Shift key for selected bones only

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param only_selected: Only Selected, Only clear paths from selected bones
    :type only_selected: bool | typing.Any | None
    """

    ...

def paths_range_update(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Update frame range for motion paths from the Scene's current frame range

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def paths_update(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Recalculate paths for bones that already have them

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def propagate(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    mode: str | None = "WHILE_HELD",
    end_frame: typing.Any | None = 250.0,
):
    """Copy selected aspects of the current pose to subsequent poses already keyframed

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param mode: Terminate Mode, Method used to determine when to stop propagating pose to keyframes

    WHILE_HELD
    While Held -- Propagate pose to all keyframes after current frame that don't change (Default behavior).

    NEXT_KEY
    To Next Keyframe -- Propagate pose to first keyframe following the current frame only.

    LAST_KEY
    To Last Keyframe -- Propagate pose to the last keyframe only (i.e. making action cyclic).

    BEFORE_FRAME
    Before Frame -- Propagate pose to all keyframes between current frame and 'Frame' property.

    BEFORE_END
    Before Last Keyframe -- Propagate pose to all keyframes from current frame until no more are found.

    SELECTED_KEYS
    On Selected Keyframes -- Propagate pose to all selected keyframes.

    SELECTED_MARKERS
    On Selected Markers -- Propagate pose to all keyframes occurring on frames with Scene Markers after the current frame.
        :type mode: str | None
        :param end_frame: End Frame, Frame to stop propagating frames to (for 'Before Frame' mode)
        :type end_frame: typing.Any | None
    """

    ...

def push(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    factor: typing.Any | None = 0.5,
    prev_frame: typing.Any | None = 0,
    next_frame: typing.Any | None = 0,
    channels: str | None = "ALL",
    axis_lock: str | None = "FREE",
):
    """Exaggerate the current pose in regards to the breakdown pose

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param factor: Factor, Weighting factor for which keyframe is favored more
        :type factor: typing.Any | None
        :param prev_frame: Previous Keyframe, Frame number of keyframe immediately before the current frame
        :type prev_frame: typing.Any | None
        :param next_frame: Next Keyframe, Frame number of keyframe immediately after the current frame
        :type next_frame: typing.Any | None
        :param channels: Channels, Set of properties that are affected

    ALL
    All Properties -- All properties, including transforms, bendy bone shape, and custom properties.

    LOC
    Location -- Location only.

    ROT
    Rotation -- Rotation only.

    SIZE
    Scale -- Scale only.

    BBONE
    Bendy Bone -- Bendy Bone shape properties.

    CUSTOM
    Custom Properties -- Custom properties.
        :type channels: str | None
        :param axis_lock: Axis Lock, Transform axis to restrict effects to

    FREE
    Free -- All axes are affected.

    X
    X -- Only X-axis transforms are affected.

    Y
    Y -- Only Y-axis transforms are affected.

    Z
    Z -- Only Z-axis transforms are affected.
        :type axis_lock: str | None
    """

    ...

def push_rest(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    factor: typing.Any | None = 0.5,
    prev_frame: typing.Any | None = 0,
    next_frame: typing.Any | None = 0,
    channels: str | None = "ALL",
    axis_lock: str | None = "FREE",
):
    """Push the current pose further away from the rest pose

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param factor: Factor, Weighting factor for which keyframe is favored more
        :type factor: typing.Any | None
        :param prev_frame: Previous Keyframe, Frame number of keyframe immediately before the current frame
        :type prev_frame: typing.Any | None
        :param next_frame: Next Keyframe, Frame number of keyframe immediately after the current frame
        :type next_frame: typing.Any | None
        :param channels: Channels, Set of properties that are affected

    ALL
    All Properties -- All properties, including transforms, bendy bone shape, and custom properties.

    LOC
    Location -- Location only.

    ROT
    Rotation -- Rotation only.

    SIZE
    Scale -- Scale only.

    BBONE
    Bendy Bone -- Bendy Bone shape properties.

    CUSTOM
    Custom Properties -- Custom properties.
        :type channels: str | None
        :param axis_lock: Axis Lock, Transform axis to restrict effects to

    FREE
    Free -- All axes are affected.

    X
    X -- Only X-axis transforms are affected.

    Y
    Y -- Only Y-axis transforms are affected.

    Z
    Z -- Only Z-axis transforms are affected.
        :type axis_lock: str | None
    """

    ...

def quaternions_flip(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Flip quaternion values to achieve desired rotations, while maintaining the same orientations

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def relax(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    factor: typing.Any | None = 0.5,
    prev_frame: typing.Any | None = 0,
    next_frame: typing.Any | None = 0,
    channels: str | None = "ALL",
    axis_lock: str | None = "FREE",
):
    """Make the current pose more similar to its breakdown pose

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param factor: Factor, Weighting factor for which keyframe is favored more
        :type factor: typing.Any | None
        :param prev_frame: Previous Keyframe, Frame number of keyframe immediately before the current frame
        :type prev_frame: typing.Any | None
        :param next_frame: Next Keyframe, Frame number of keyframe immediately after the current frame
        :type next_frame: typing.Any | None
        :param channels: Channels, Set of properties that are affected

    ALL
    All Properties -- All properties, including transforms, bendy bone shape, and custom properties.

    LOC
    Location -- Location only.

    ROT
    Rotation -- Rotation only.

    SIZE
    Scale -- Scale only.

    BBONE
    Bendy Bone -- Bendy Bone shape properties.

    CUSTOM
    Custom Properties -- Custom properties.
        :type channels: str | None
        :param axis_lock: Axis Lock, Transform axis to restrict effects to

    FREE
    Free -- All axes are affected.

    X
    X -- Only X-axis transforms are affected.

    Y
    Y -- Only Y-axis transforms are affected.

    Z
    Z -- Only Z-axis transforms are affected.
        :type axis_lock: str | None
    """

    ...

def relax_rest(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    factor: typing.Any | None = 0.5,
    prev_frame: typing.Any | None = 0,
    next_frame: typing.Any | None = 0,
    channels: str | None = "ALL",
    axis_lock: str | None = "FREE",
):
    """Make the current pose more similar to the rest pose

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param factor: Factor, Weighting factor for which keyframe is favored more
        :type factor: typing.Any | None
        :param prev_frame: Previous Keyframe, Frame number of keyframe immediately before the current frame
        :type prev_frame: typing.Any | None
        :param next_frame: Next Keyframe, Frame number of keyframe immediately after the current frame
        :type next_frame: typing.Any | None
        :param channels: Channels, Set of properties that are affected

    ALL
    All Properties -- All properties, including transforms, bendy bone shape, and custom properties.

    LOC
    Location -- Location only.

    ROT
    Rotation -- Rotation only.

    SIZE
    Scale -- Scale only.

    BBONE
    Bendy Bone -- Bendy Bone shape properties.

    CUSTOM
    Custom Properties -- Custom properties.
        :type channels: str | None
        :param axis_lock: Axis Lock, Transform axis to restrict effects to

    FREE
    Free -- All axes are affected.

    X
    X -- Only X-axis transforms are affected.

    Y
    Y -- Only Y-axis transforms are affected.

    Z
    Z -- Only Z-axis transforms are affected.
        :type axis_lock: str | None
    """

    ...

def reveal(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    select: bool | typing.Any | None = True,
):
    """Reveal all bones hidden in Pose Mode

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param select: Select
    :type select: bool | typing.Any | None
    """

    ...

def rot_clear(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Reset rotations of selected bones to their default values

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def rotation_mode_set(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    type: str | None = "QUATERNION",
):
    """Set the rotation representation used by selected bones

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param type: Rotation Mode

    QUATERNION
    Quaternion (WXYZ) -- No Gimbal Lock.

    XYZ
    XYZ Euler -- XYZ Rotation Order - prone to Gimbal Lock (default).

    XZY
    XZY Euler -- XZY Rotation Order - prone to Gimbal Lock.

    YXZ
    YXZ Euler -- YXZ Rotation Order - prone to Gimbal Lock.

    YZX
    YZX Euler -- YZX Rotation Order - prone to Gimbal Lock.

    ZXY
    ZXY Euler -- ZXY Rotation Order - prone to Gimbal Lock.

    ZYX
    ZYX Euler -- ZYX Rotation Order - prone to Gimbal Lock.

    AXIS_ANGLE
    Axis Angle -- Axis Angle (W+XYZ), defines a rotation around some axis defined by 3D-Vector.
        :type type: str | None
    """

    ...

def scale_clear(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Reset scaling of selected bones to their default values

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def select_all(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    action: str | None = "TOGGLE",
):
    """Toggle selection status of all bones

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param action: Action, Selection action to execute

    TOGGLE
    Toggle -- Toggle selection for all elements.

    SELECT
    Select -- Select all elements.

    DESELECT
    Deselect -- Deselect all elements.

    INVERT
    Invert -- Invert selection of all elements.
        :type action: str | None
    """

    ...

def select_constraint_target(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Select bones used as targets for the currently selected bones

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def select_grouped(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    extend: bool | typing.Any | None = False,
    type: str | None = "LAYER",
):
    """Select all visible bones grouped by similar properties

        :type override_context: bpy.types.Context | dict[str, typing.Any] | None
        :type execution_context: int | str | None
        :type undo: bool | None
        :param extend: Extend, Extend selection instead of deselecting everything first
        :type extend: bool | typing.Any | None
        :param type: Type

    LAYER
    Layer -- Shared layers.

    GROUP
    Group -- Shared group.

    KEYINGSET
    Keying Set -- All bones affected by active Keying Set.
        :type type: str | None
    """

    ...

def select_hierarchy(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    direction: str | None = "PARENT",
    extend: bool | typing.Any | None = False,
):
    """Select immediate parent/children of selected bones

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param direction: Direction
    :type direction: str | None
    :param extend: Extend, Extend the selection
    :type extend: bool | typing.Any | None
    """

    ...

def select_linked(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Select all bones linked by parent/child connections to the current selection

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def select_linked_pick(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    extend: bool | typing.Any | None = False,
):
    """Select bones linked by parent/child connections under the mouse cursor

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param extend: Extend, Extend selection instead of deselecting everything first
    :type extend: bool | typing.Any | None
    """

    ...

def select_mirror(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    only_active: bool | typing.Any | None = False,
    extend: bool | typing.Any | None = False,
):
    """Mirror the bone selection

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param only_active: Active Only, Only operate on the active bone
    :type only_active: bool | typing.Any | None
    :param extend: Extend, Extend the selection
    :type extend: bool | typing.Any | None
    """

    ...

def select_parent(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Select bones that are parents of the currently selected bones

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def transforms_clear(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Reset location, rotation, and scaling of selected bones to their default values

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...

def user_transforms_clear(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
    *,
    only_selected: bool | typing.Any | None = True,
):
    """Reset pose bone transforms to keyframed state

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    :param only_selected: Only Selected, Only visible/selected bones
    :type only_selected: bool | typing.Any | None
    """

    ...

def visual_transform_apply(
    override_context: bpy.types.Context | dict[str, typing.Any] | None = None,
    execution_context: int | str | None = None,
    undo: bool | None = None,
):
    """Apply final constrained position of pose bones to their transform

    :type override_context: bpy.types.Context | dict[str, typing.Any] | None
    :type execution_context: int | str | None
    :type undo: bool | None
    """

    ...
