// Generated by CoffeeScript 1.6.3
define(['jquery', 'backbone', 'models/ChartModel'], function($, Backbone, ChartModel) {
  var ChartView;
  return ChartView = Backbone.View.extend({
    el: '#mainChart',
    data: [],
    chart: function() {
      return $('#mainChart').highcharts({
        chart: {
          type: 'column'
        },
        legend: {
          enabled: false
        },
        title: {
          text: 'Participant Status'
        },
        showInLegend: false,
        xAxis: {
          categories: this.categories
        },
        yAxis: {
          title: {
            text: '# of participants'
          }
        },
        plotOptions: {
          column: {
            cursor: 'pointer',
            dataLabels: {
              enabled: true,
              color: this.color,
              style: {
                fontWeight: 'bold'
              },
              formatter: function() {
                return "" + this.y;
              }
            }
          }
        },
        tooltip: {
          formatter: function() {
            var s;
            s = "" + this.x + " :<b> " + this.y + " </b><br/>";
            return s;
          }
        },
        series: [
          {
            data: this.data,
            color: 'white'
          }
        ],
        exporting: {
          enabled: false
        }
      }).highcharts();
    },
    initialize: function() {
      var proms,
        _this = this;
      this.model = new ChartModel;
      this.colors = Highcharts.getOptions().colors;
      this.categories = ['Allocated', 'Started', 'Completed', 'Debriefed', 'Credited', 'Quit Early'];
      proms = this.getData();
      return proms.done(function() {
        return _this.setChart();
      });
    },
    getData: function() {
      var promise,
        _this = this;
      promise = this.model.fetch();
      return promise.done(function() {
        return _this.data = [
          {
            y: _this.model.get("debriefed"),
            color: "#EF643E"
          }, {
            y: _this.model.get("started"),
            color: "#EF643E"
          }, {
            y: _this.model.get("completed"),
            color: "#ef643e"
          }, {
            y: _this.model.get("credited"),
            color: "#ef643e"
          }, {
            y: _this.model.get("allocated"),
            color: "#ef643e"
          }, {
            y: _this.model.get("quit_early"),
            color: "#ef643e"
          }
        ];
      });
    },
    setChart: function() {
      var chart;
      chart = this.chart();
      chart.xAxis[0].setCategories(this.categories, false);
      chart.series[0].remove(false);
      chart.addSeries({
        name: this.name,
        data: this.data,
        color: this.color || 'white'
      }, false);
      return chart.redraw();
    },
    refresh: function() {
      this.getData();
      return this.setChart();
    }
  });
});
