#------------------------------------------------------------------------------
# Copyright (C) 2009 Richard W. Lincoln
#
#  Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to
#  deal in the Software without restriction, including without limitation the
#  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
#  sell copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in
#  all copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
#  IN THE SOFTWARE.
#------------------------------------------------------------------------------

""" Property view plug-in.
"""

#------------------------------------------------------------------------------
#  Imports:
#------------------------------------------------------------------------------

from enthought.envisage.api import Plugin
from enthought.traits.api import List

#------------------------------------------------------------------------------
#  "PropertyViewPlugin" class:
#------------------------------------------------------------------------------

class PropertyViewPlugin(Plugin):
    """ Property view plug-in.
    """
    # Extension point IDs
    VIEWS = "enthought.envisage.ui.workbench.views"

    # Unique plugin identifier
    id = "puddle.property_view"

    # Human readable plugin name
    name = "Property View"

    #--------------------------------------------------------------------------
    #  Extensions (Contributions):
    #--------------------------------------------------------------------------

    # Views contributed to the workbench:
    contributed_views = List(contributes_to=VIEWS)

    #--------------------------------------------------------------------------
    #  "PropertyViewPlugin" interface:
    #--------------------------------------------------------------------------

    def _contributed_views_default(self):
        """ Trait initialiser.
        """
        from property_view import PropertyView

        return [PropertyView]

# EOF -------------------------------------------------------------------------
