from random import randint
from datetime import datetime

class Generators:

    @staticmethod
    def get_random_element_in(elements):
        rand_index = randint(0, len(elements) - 1)
        return elements[rand_index]

    @staticmethod
    def generate_random_int(lower_bound, upper_bound):
        return randint(lower_bound, upper_bound)

    @staticmethod
    def generate_weighted_list(elements_with_weight):
        weighed_list = []
        for element in elements_with_weight:
            weighed_list.extend([element[0]] * element[1])
        return weighed_list

    @staticmethod
    def generate_number_of_days_since_epoch(year, month, day):
        d = datetime(year, month, day, 0, 0, 0)
        return (d - datetime(1970, 1, 1)).days

    @staticmethod
    def generate_timestamp(year, month, day, hour, minute, second):
        d = datetime(year, month, day, hour, minute, second)
        return int(d.timestamp() * 1000)

    @staticmethod
    def generate_random_names(limit=1000):
        return [name.strip() for name in """
        Amanda
        Burns Sharon
        Fuentes Michael
        Watson Cynthia
        Martin Amber
        Hopkins Robert
        Edwards Judy
        Moore Kelly
        Carter Anthony
        Smith Margaret
        Martin Keith
        Wright Stephanie
        Anderson Ricky
        Alvarado John
        Galvan Michael
        Johnson Dana
        Burch Sonya
        Carroll David
        Kline Christopher
        Grant Brittany
        Anderson Travis
        Wagner Kelly
        Rojas Lance
        Payne Susan
        Morgan Timothy
        Harrison Taylor
        Bowen Daniel
        Powers Michael
        Garrison Jennifer
        Byrd Katherine
        Williams Debra
        Cook Brendan
        Lopez Miranda
        Moore Larry
        Griffith Louis
        Flowers James
        Williams Jacob
        Cordova James
        Perry James
        Gonzalez Catherine
        Roberts Lisa
        Andrews William
        Cunningham
        DVM Corey
        Vargas Jimmy
        Werner Natalie
        Franklin Sheila
        Romero Catherine
        Garcia Jodi
        Trevino Erin
        Hart Lisa
        Lowe Joseph
        Morrison Michael
        Quinn Danielle
        Mejia Brian
        Matthews Mr.Eric
        Freeman Karen
        Robertson Kelly
        Montoya Tina
        Murray Charles
        Nunez Larry
        Kramer Margaret
        Christian Daniel
        Wood John
        Edwards Steven
        Guerrero Martin
        Williams John
        Rogers Jimmy
        Hunter Sharon
        Smith Michele
        Deleon Kelly
        Blair Daniel
        Mckinney Nathaniel
        Lowery Kevin
        Hunt Mary
        Terry Sandra
        Cisneros Eric
        Ortega Connie
        James Jennifer
        Rodriguez Joann
        Reed Lisa
        Pope Thomas
        Montgomery
        MD Brad
        Conway Philip
        Reynolds Brian
        Howard Allen
        Turner Misty
        Miller Nancy
        Spencer Brandy
        Holloway Michael
        Berry Cynthia
        Alvarez Brandon
        Ward Keith
        Morrison Benjamin
        Martin Kevin
        Lloyd Christina
        Martinez Jesse
        Pruitt Carolyn
        Swanson Michael
        Stewart Heather
        Rivera Kelly
        Allen Jamie
        Boone Jesse
        Weber Heather
        Nelson Paul
        Salazar Walter
        Delacruz Jason
        Davis Jennifer
        Fisher Mark
        Freeman John
        Mckenzie Michael
        Kelly Kelsey
        Soto Justin
        Berg Mr.Daniel
        Romero Paul
        Myers David
        Martin Laura
        Thompson Johnny
        Boyd Claudia
        Brown
        DDS Larry
        Olson Virginia
        Black Ryan
        Long Victoria
        Brown Susan
        Hogan Natalie
        Anderson Barbara
        Baker Sabrina
        Beck James
        Hubbard Theresa
        Duncan Kimberly
        Lopez Daniel
        Williams George
        Martin Natasha
        Waters Thomas
        Wheeler Nathaniel
        Gonzalez Ian
        White Adam
        Miller Carol
        Cooper Luis
        Wright Christian
        Ruiz Patrick
        Vega Patty
        Patel Mary
        Taylor Leah
        Collins
        DDS Joseph
        Solis Nathaniel
        Solomon Brianna
        Henderson Courtney
        Ramirez Karen
        Miller Amanda
        Barr Richard
        Edwards Laura
        Hammond Shirley
        Blackwell Angelica
        Kidd Nicole
        Wilson Shelby
        Herring Melissa
        Barnes Michael
        Davis Rebecca
        Michael Theresa
        Thompson Kristen
        Andrews Jamie
        Brown Danielle
        Tanner
        DDS Andrea
        Macias
        MD Charles
        Griffith Julie
        Gilbert Tracie
        Hartman Shelby
        Davies David
        Turner Kent
        Davis Michael
        Lawson Tonya
        Rodriguez Dr.Scott
        Gordon Jennifer
        Lyons Andrew
        Clark Ryan
        Hall Laura
        Ewing Christopher
        Wright Gordon
        Arnold Kelly
        Cooper Tammy
        Carter Kelly
        Garcia Scott
        Velazquez Tammy
        Roman Chelsea
        Barnett Alicia
        Alexander Jeremy
        Freeman Peter
        Andrade Margaret
        Cuevas James
        Baker Richard
        Horton Rachel
        Armstrong Brendan
        Fischer Amber
        Klein Anthony
        Lester Miguel
        Brown Tyler
        Washington Maria
        Joyce Michael
        Watts
        DDS Kim
        Watts Michael
        Jacobs Timothy
        Lopez Jennifer
        Gould Jennifer
        Gonzalez William
        Gomez Frank
        King Rachel
        Butler Paul
        Estrada Courtney
        Campbell Christine
        Lowe Edward
        Leonard John
        Sanchez Daniel
        Powell Amber
        Ortiz Pamela
        Simpson Kristopher
        Brown Michelle
        Hall Mr.Gregory
        Smith
        II Christopher
        Walsh Edward
        Ross Henry
        Vargas Nathan
        Evans Terry
        Brown Brian
        Davis Michele
        Sanchez Joshua
        Martinez Brenda
        Hernandez Kristina
        Wall Courtney
        White Brian
        Watts Donald
        Henderson Richard
        Davidson Lisa
        Stark Rachel
        Potter Christina
        Dodson Michele
        Gibson Gabrielle
        Brennan William
        Rivera, Matthew
        Fleming, Tara
        Copeland, Anthony
        Garrett, Megan
        Andrews, Mason
        Green, Kenneth
        Smith, Elijah
        Hughes, Amy
        Brown, Michael
        Hart, Christina
        Rogers, Jeremy
        Moody, Matthew
        Burton, Dennis
        Hoffman, Gregory
        Williams, George
        Santiago, Ryan
        Cox, Michele
        Adams, Michael
        Meadows, Gabrielle
        Mcdonald, Dr.Nicholas
        Schneider, Kelly
        Cline, Madison
        Richards, Nathan
        Barber, Marcus
        Fernandez, Daisy
        Barnett, Cody
        Johnson, Rick
        Allen, Steven
        Garcia, Robert
        Swanson, Catherine
        Robertson, Danielle
        Zamora, Christine
        Reid, Sarah
        Garcia, Lindsey
        Smith, Sally
        Baldwin, Joel
        Summers, Russell
        Prince, Robert
        Smith, Benjamin
        Taylor, Patricia
        Parker, Kristi
        Benson, Dakota
        Dorsey, Rhonda
        Smith, Nancy
        Brooks, Deanna
        Nelson, Cody
        York, Tiffany
        Owens, Patricia
        Hawkins, Laurie
        Grant, Jerry
        West, Brian
        Heath, Brittney
        Smith, Benjamin
        Parker, Kayla
        Harris, Lisa
        Tate, Lori
        Nunez, John
        Graham, Paul
        Nelson, Jennifer
        Green
        DVM, Felicia
        Diaz, Colleen
        Hernandez, Emma
        Sanchez, Susan
        Adams, Andrew
        Castillo, Patricia
        Barnett, Miss
        Katherine
        Davis
        DDS, Alicia
        Ellis, Nicholas
        Rodriguez, Jennifer
        Hunt, Julie
        Smith, Kendra
        Jimenez, Linda
        Frazier, Shelby
        Smith, James
        Scott, Patrick
        Robinson, Jerry
        Bell, Jason
        Payne, Jessica
        Foster, Jeffrey
        Moore, Linda
        Brown, James
        Rodriguez, Andre
        Williams, Joan
        Moore, Billy
        Conley, Margaret
        Mercado, Aaron
        Perry, Kristen
        Williams, Mary
        Henderson, Larry
        Garner, Charles
        Baxter, Catherine
        Wheeler, Daniel
        Alvarado, Kelly
        Reynolds, Gina
        Lutz, Shawn
        Boone, Mr.Adam
        Harris
        III, Lisa
        Davis, Robert
        Taylor, Jonathan
        Murray, Ruben
        Perez, Daniel
        Sloan, Carmen
        Delgado, Robert
        Ramos, Daniel
        Mcintyre, Edward
        Newman, Gabrielle
        Fleming, Robert
        Simmons
        MD, Amanda
        Moore, Kelly
        Robinson, James
        Acosta, Jill
        Rodriguez, Diane
        Robinson, Maria
        Oconnell, Heather
        Parker, Patricia
        Chan, Taylor
        Johnson, Michael
        Aguilar, Catherine
        Ramirez, Jerry
        Brown, Sierra
        Gutierrez, Michael
        Hudson, Marie
        Ramirez, James
        Williams, Daniel
        Thompson, Denise
        Johnson, Angel
        Espinoza, Krystal
        Archer, Christine
        Mccarthy, Mark
        Harris, Laura
        Bradley, Michelle
        Freeman, Keith
        Russell, Jesse
        Martinez
        DDS, Traci
        Green, Mrs.Angel
        Hamilton
        DDS, Laura
        Miller, Patrick
        Peterson, Adam
        Kaiser, Adam
        Kelly, Steven
        Pennington, John
        Irwin, Chelsea
        Maynard, Brittany
        Henderson, Courtney
        Clark, Cynthia
        Wall, Brooke
        Jones, Joshua
        Ramirez, Paul
        Nunez, Kevin
        Hall, Tara
        Hughes, Ethan
        Miles, Lisa
        Martin, Kevin
        Walker, Tamara
        Matthews, Kristin
        Carey, Sharon
        Meyers, Carrie
        Carpenter, Steve
        Long, Katie
        Young, Diana
        Barnes, Brian
        Riddle, Kristen
        Baker, Donald
        Wong, Brian
        Tran, Isabel
        Vazquez, Alexis
        Wood, Roy
        Robinson, Lisa
        Vasquez, Karen
        Shelton, Brian
        Kirk, Christy
        Koch, Adam
        Martinez, Kristi
        Vargas, Christopher
        Perez, Jennifer
        Dominguez, Jennifer
        Smith, Melissa
        Taylor, Sarah
        Hall, Kenneth
        Pope, Christina
        Williams, Mr.Andrew
        Banks, Kayla
        Ho, Jared
        Johnson, Melissa
        Kane, Bruce
        Thomas, Amy
        Lee, Juan
        Small, Gary
        Choi, Cynthia
        Armstrong, Dylan
        King, Robert
        Williams, Anthony
        Johnson, Andre
        Ross, Sara
        Martin, Brenda
        Mclean, Ralph
        Carroll, Michael
        Jones, Gregory
        Crawford, Christopher
        Wallace, Linda
        Velasquez, Stephen
        Perez, Rebecca
        Graves, Stephen
        Watson, Bradley
        Alexander, Jason
        Garner, Jacqueline
        Sanders, John
        Golden, Angela
        Owen
        MD, Andrew
        Walsh
        Jr., Rebecca
        Sanchez, Cameron
        Russo, Danielle
        Jennings, Mrs.Sarah
        Smith, William
        Gonzales, Amy
        Lewis, Timothy
        Davis, Nancy
        Shepard
        DVM, Stephanie
        Casey, Susan
        Ashley, Tonya
        Johnson, Jasmine
        Rodriguez, Raymond
        Hernandez, Kelly
        Porter, Teresa
        Walker, Sheila
        Gonzalez, Wanda
        Smith, Nancy
        Woodward, Amanda
        Wilson, Lisa
        Williams, Derek
        Robertson, Dustin
        Nguyen, Luis
        Klein, Amy
        Torres, Shelley
        White, Cody
        Bowers, Lisa
        Arnold, Tamara
        Evans, Whitney
        Boyer, Timothy
        Jones, Frank
        Houston, Kimberly
        Mcclure, Justin
        Gibson, Gregory
        Davidson, Christopher
        Stone, Sherry
        Rodriguez, Lacey
        Guerra, Timothy
        Gilbert, Joan
        Munoz, Morgan
        Smith, Troy
        Wallace, Andrew
        Schmidt, Tammy
        Spencer, Melissa
        Holloway, Monica
        Jones, Dominique
        Collier, Francisco
        Rogers, Michelle
        Marsh, William
        Morris, Matthew
        Reed, Suzanne
        Martin, Valerie
        Flores, Kathleen
        Garcia, Anna
        Mills, Mckenzie
        Thomas, Teresa
        Jenkins, Carol
        Lyons, Victor
        Marshall, Kimberly
        Carpenter, Glenn
        Costa, Robin
        Larson, Jessica
        Ford, Briana
        Holden, Rachael
        Williams, Ms.Carol
        Schroeder, James
        Estes, Lauren
        Williams, Andrew
        Hopkins, Tyler
        Estrada, David
        Velez, Henry
        Ramos, Mark
        White, John
        Flowers, Robert
        Flores, Pamela
        Finley, Michelle
        Watkins, Logan
        Carter, Daniel
        Diaz, Charles
        Deleon, Shawn
        Parker, Anthony
        Fuller, Andrew
        Hayden, Jessica
        Velasquez, John
        Hutchinson, Robin
        Davis, Maria
        Spence, Angela
        Sullivan, Margaret
        Arias, Robert
        Bennett, David
        Scott, Jennifer
        Perez, David
        Harrington, Becky
        Thomas, Tanya
        Hall, Christopher
        Ray, Mark
        Mason, Lindsay
        Cain
        MD, Susan
        Patterson, Aaron
        Roberts, Michael
        Myers, Diane
        Garcia, Jeffrey
        Hammond, Christopher
        Williams, Yvonne
        Jordan, Carolyn
        Lewis, Elizabeth
        Gonzalez, Shannon
        Villarreal, Mr.Matthew
        Smith
        DVM, Shannon
        Phillips, Donald
        Mccoy, Mallory
        Ali, Shawn
        Allen, Traci
        Smith, Paige
        Patterson, Rachael
        Young, Michael
        Flynn, Bryan
        Sanders, Brittany
        Spencer, Andrew
        Miller, Ryan
        Fowler, Meagan
        Simon
        DDS, Michael
        Hoffman, Joshua
        Haas, Karen
        Anthony, Kenneth
        Davidson, Zachary
        Randolph, Brian
        Rivers, Jared
        King, Robert
        Jones, James
        Shepherd, Matthew
        Lopez, Tracey
        Bennett, Lori
        Weber, Devin
        Garza, Robert
        Liu, Carla
        Bartlett, Michael
        Carson, Mr.Andrew
        Phillips, Dr.Charles
        Torres
        DDS, Sara
        Bowen, Kristin
        Guerrero
        MD, Elizabeth
        Austin, Elizabeth
        Adams, Benjamin
        Jones, Victoria
        Miller, Jennifer
        Morgan
        MD, Gregory
        Jones, Timothy
        Schneider, Alex
        Prince, Charles
        Bell, Amy
        Garcia, Michael
        Middleton, Raymond
        Johnson, Dawn
        Bartlett, Theodore
        Oconnor, Sarah
        Garcia, Sean
        Vega, Victoria
        Baker, Jamie
        Wilson, Michelle
        Skinner, Alexa
        Nguyen, Dennis
        Franklin, Mr.Ian
        Patel, Danielle
        Cowan, Jason
        May, Andrea
        Hernandez, Latasha
        Dixon, Christine
        Soto, Paul
        Lloyd, David
        Bruce, Mark
        Ramsey, Gail
        Rodriguez, Lisa
        Galvan, Wanda
        Watson, Dr.Stephanie
        Nguyen, Elizabeth
        Watts, John
        Hensley, Rebecca
        Silva, Kelly
        Beltran, Elizabeth
        Anthony, Raymond
        Ortiz, Joseph
        Salinas, Regina
        Anderson, Leonard
        Tucker, Jose
        Hubbard, Katherine
        Nichols, Jerry
        Wong, Tyler
        Wright, Taylor
        Anderson, Joshua
        Young, Alexander
        Duncan, Robert
        Lopez, Theresa
        Morris, Daniel
        Miller, Michael
        Neal, Tracy
        Dougherty, Dr.Jennifer
        Morales, Kristopher
        Stout, Julie
        Fuller, Kristen
        Cowan, Jesse
        Knight, Alexander
        Ibarra, David
        Lowe, Rebecca
        Sharp, Mr.Thomas
        King, Steven
        Wiley, Elizabeth
        Davis, Brett
        Ferrell, Brandon
        Stanley, Christina
        Lee, James
        Weeks, Timothy
        Wade, David
        Smith, Andrew
        Preston, William
        Rodriguez, Valerie
        Jones, Cheryl
        Sanchez, Marco
        Scott, Stephen
        Gould, Diana
        Reynolds, Jillian
        Lamb, Scott
        Fisher, Nicholas
        Mcintyre, Jose
        Mayer, Monique
        Garza, Steven
        Greer, April
        Pearson, Maria
        Everett, Denise
        Fletcher, Kelly
        Mccarthy, Cameron
        Benson, David
        Riley, Maria
        Franklin, Erica
        Harris, Caitlin
        Grant
        DDS, Pamela
        Walker, Linda
        Hobbs, Katherine
        Haas, Angelica
        Johnson, Derek
        Harrington, Mary
        Garcia, Amanda
        Walter, Rachel
        Stewart, Angel
        White, Michael
        Jones, Vanessa
        Carpenter, Amanda
        Ford, Brittany
        Dawson, Morgan
        Fox, Robin
        Gonzales, Anthony
        Hansen, Jennifer
        Figueroa, Timothy
        Morales, Bernard
        Roberts, David
        Alexander, Sarah
        Weiss, Amy
        Garcia, Kathryn
        Harris, Andrea
        Bennett, Amy
        Henry, Juan
        Hart, Jennifer
        Hines, Jessica
        Cunningham, Justin
        Brown, Kenneth
        Wilson, Christopher
        Reed, Kirsten
        Harmon, William
        Jones, Mark
        Davis, Teresa
        Johnson, Anthony
        Key, Maureen
        Jones, Richard
        Noble, Eric
        Smith, Scott
        Haynes, David
        Bishop, Tina
        Aguilar, Dr.Elizabeth
        Lopez, Lisa
        Hill, Michael
        Flores, Christopher
        Green, Gregory
        Elliott, Carlos
        Berg
        DVM, Holly
        Gonzalez, Ryan
        Young, Nathaniel
        Peterson, Barbara
        Miller, Theresa
        Chase, Valerie
        Murphy, Richard
        Ramirez, Brett
        Yates, James
        Huff, Richard
        Maxwell, Kenneth
        Pace, Matthew
        York, Vanessa
        Davidson, Courtney
        Berg, Steven
        Ayala, Daniel
        Osborne, Justin
        Daniels, Meghan
        Jacobs, Michelle
        Mendez, Katherine
        Hardy, Jamie
        Knox, James
        Washington, Mariah
        Patel, Scott
        Brown, Shane
        Mills, Angie
        Jennings, Desiree
        Goodwin, Gregory
        Lewis, Lauren
        Carney, Jonathan
        Martin, Dr.Kathryn
        Watson
        MD, Jimmy
        Moore, Devon
        Cole, Mary
        Howard, Diane
        Henderson, Kirk
        Baker, Felicia
        Wallace, Paul
        Smith, Heather
        Hampton, David
        Castaneda, Shannon
        Jackson, Dr.Ashley
        Yang, Kelly
        Nelson, Samantha
        Cortez, Jennifer
        Santos, Stephen
        Green, Kim
        Kaufman, Douglas
        Smith, Paul
        Nixon, Abigail
        Price, John
        Murillo, Dr.Joseph
        Lee, Joseph
        Daniel, Christina
        Morales, Christopher
        Schmidt, Christopher
        Wang, Joseph
        Morris, Holly
        Meyers, Craig
        Kelley, Anthony
        Jefferson, Ellen
        Smith, Travis
        Garcia
        Jr., Shannon
        Weaver, Carla
        Clayton, Jessica
        Escobar, Michael
        Russell, Vanessa
        Pena, Jimmy
        Edwards, William
        Wilkerson, Peter
        Berger, Sarah
        Daniel, Zachary
        Burnett, Mr.Calvin
        Anderson, Courtney
        Wade, Frank
        Lambert, Kimberly
        Smith, Melanie
        Miller, Shawn
        Ramirez, Christina
        Solomon, Eric
        Moore, Joshua
        Velazquez, Tyler
        Graham, Cameron
        Wells, Brian
        Brown, Juan
        Barnett, Elizabeth
        Matthews, Brandon
        Brown, Emily
        Hunter, Erika
        Gregory, Craig
        Roberts, Jeffrey
        Smith, Angela
        Ward, Brandi
        Allen, Joseph
        Baxter, Michael
        Clark, Candice
        Singleton, Claudia
        Wang, Amber
        Perez, Michael
        Brown, Melissa
        Campbell, Vanessa
        Hernandez, Andrea
        Wilson, Nathaniel
        Petersen, Jesse
        Leon, Karen
        Martin, Dr.Kenneth
        Jones, Timothy
        Gonzalez, Mrs.Sharon
        Brown, Reginald
        Larson, James
        Jordan, Alexis
        Novak, Jessica
        Foster, Daniel
        Black, Elizabeth
        Martin, Gregory
        Nguyen
        DVM, Nicholas
        Robinson, Alejandra
        Mclaughlin, Mrs.Victoria
        Ortiz
        DDS, Bradley
        Greene, Mary
        White, Shannon
        Meyer, Joshua
        Campos, Samantha
        Henderson, Jackson
        Wall, Molly
        Weber, Rebecca
        Olson, Elizabeth
        Fitzpatrick, Latasha
        Wilson, Jennifer
        Rivera, Mrs.Haley
        Davis, Gregory
        Knight, Heather
        Nelson, Sherry
        Lawson, Debbie
        Woodward, Mark
        Farrell, Eric
        Gross
        DVM, Maria
        Liu, Darryl
        Mckay, James
        Lucas, Marcus
        Graves, Robert
        Castro, Nicole
        Goodwin, Sheri
        Koch, Keith
        Livingston, Nathan
        Henry, Jose
        Ruiz, Kurt
        Haas, Shane
        Anderson, Jason
        Gray, Kathy
        Owen, Brian
        Williams, Valerie
        Peters, Cameron
        Guzman, Frank
        Roberson, David
        Garrett, Ryan
        Wallace, Tiffany
        Brown, Stephen
        Lopez, Charles
        Scott, Erin
        Newman, Steven
        Wade, Scott
        Valenzuela, Dustin
        Williams, Vicki
        Harrison, Jessica
        Calderon, Alexis
        Gonzales, Randy
        Henderson, Catherine
        Navarro, Gabriella
        Alvarez, Kimberly
        Burton, Paul
        Bailey, Jaime
        Turner, Kimberly
        White, Christine
        Campbell, Thomas
        Spencer, Martha
        Baker, James
        Butler, George
        Reynolds, Victoria
        Patrick, Donna
        Sutton, Paul
        Nicholson, Mark
        Juarez, Sarah
        Carson, Jonathan
        Robinson, Judy
        Hobbs, Nancy
        Collins, Megan
        Jones, Amanda
        Reid, Victor
        Blackwell, Justin
        Ruiz, Ryan
        Stafford, Ryan
        Clark, Christina
        Carlson, Laura
        Ramirez, David
        Delacruz, Sara
        George, Jamie
        Gonzalez, Elizabeth
        Rios, Willie
        Aguilar, Austin
        Sanchez, Kyle
        Carey, Kelly
        Duran, Andrew
        Valentine, Paul
        Williamson, Martin
        Knight, Kelly
        Butler, Emily
        Middleton, Michael
        Young, Jimmy
        Sloan, Sherry
        Gibson, Jose
        Turner, James
        Jones, Elizabeth
        Scott, Nancy
        Morris, Brian
        Tran, Rebecca
        Casey, Susan
        Buchanan, Jeffrey
        Kane, Betty
        Flynn, Brooke
        Davis, Sarah
        Powell, James
        Hudson, John
        Santiago, Mckenzie
        Collier, Taylor
        Marquez, Trevor
        Jones, James
        Morris, Mr.Thomas
        Elliott, Elizabeth
        Bartlett, Sandra
        Buckley, Diane
        Castro, Mercedes
        Ross, Jessica
        Pacheco, Katie
        Waters, Gregory
        Medina, Michelle
        Gray, Shari
        Carter, Selena
        Ross, Jeremy
        Miller, Jordan
        York, Ashley
        Figueroa, Julie
        Arnold, Sarah
        Willis, Laura
        Dorsey, Sandra
        Flores, Linda
        Coleman, Jean
        Jones, Michael
        Valdez, Kristin
        Weaver, Jessica
        Rivera, Erik
        Peterson, Richard
        Smith, Gabriela
        Dean
        DDS, Tracy
        Bowen, Timothy
        Gray, Jillian
        Pearson, Barbara
        Jackson, Chase
        Barton, Joel
        Hood, Jose
        Cruz, Brian
        Whitaker, Patricia
        Anderson, Kimberly
        Boyd, Anthony
        Ortiz, Sherry
        Hunter, Catherine
        Cohen, Rhonda
        Perez, Patricia
        Morris, Robert
        Johnson, Autumn
        Gallagher, Eric
        Clements
        """.splitlines(True) if name.strip()][:limit]
