from typing import Any, Dict, Optional, Type
from abc import ABCMeta
from surfgram.types import TypesFactory


class InlineQueryResultDocumentMeta(ABCMeta):
    """Metaclass for InlineQueryResultDocument classes."""

    def __new__(cls, name: str, bases: tuple, attrs: Dict[str, Any]):
        new_class = super().__new__(cls, name, bases, attrs)
        if bases and new_class.__is_active__:
            InlineQueryResultDocumentsFactory.register_inline_query_result_document(
                new_class
            )
        return new_class


class InlineQueryResultDocumentsFactory(TypesFactory):
    """Factory for creating InlineQueryResultDocument instances."""

    INLINEQUERYRESULTDOCUMENTS_REGISTRY: Dict[str, Type] = {}
    __type_name__ = "inline_query_result_document"

    @classmethod
    def register_inline_query_result_document(
        cls, inline_query_result_document_cls: Type
    ) -> None:
        """Register a new inline_query_result_document handler."""
        instance = inline_query_result_document_cls()
        for name in instance.__names__:
            cls.INLINEQUERYRESULTDOCUMENTS_REGISTRY[name] = (
                inline_query_result_document_cls
            )

    @classmethod
    async def create(cls, update: Any) -> Optional[Any]:
        """Create handler instance from update."""
        obj = update.inline_query_result_document
        trigger_value = obj.title
        return cls.INLINEQUERYRESULTDOCUMENTS_REGISTRY.get(trigger_value)()
