from typing import Any, Dict, Optional, Type
from abc import ABCMeta
from surfgram.types import TypesFactory


class InlineQueryResultGifMeta(ABCMeta):
    """Metaclass for InlineQueryResultGif classes."""

    def __new__(cls, name: str, bases: tuple, attrs: Dict[str, Any]):
        new_class = super().__new__(cls, name, bases, attrs)
        if bases and new_class.__is_active__:
            InlineQueryResultGifsFactory.register_inline_query_result_gif(new_class)
        return new_class


class InlineQueryResultGifsFactory(TypesFactory):
    """Factory for creating InlineQueryResultGif instances."""

    INLINEQUERYRESULTGIFS_REGISTRY: Dict[str, Type] = {}
    __type_name__ = "inline_query_result_gif"

    @classmethod
    def register_inline_query_result_gif(
        cls, inline_query_result_gif_cls: Type
    ) -> None:
        """Register a new inline_query_result_gif handler."""
        instance = inline_query_result_gif_cls()
        for name in instance.__names__:
            cls.INLINEQUERYRESULTGIFS_REGISTRY[name] = inline_query_result_gif_cls

    @classmethod
    async def create(cls, update: Any) -> Optional[Any]:
        """Create handler instance from update."""
        obj = update.inline_query_result_gif
        trigger_value = obj.title
        return cls.INLINEQUERYRESULTGIFS_REGISTRY.get(trigger_value)()
