from typing import Any, Dict, Optional, Type
from abc import ABCMeta
from surfgram.types import TypesFactory


class UniqueGiftModelMeta(ABCMeta):
    """Metaclass for UniqueGiftModel classes."""

    def __new__(cls, name: str, bases: tuple, attrs: Dict[str, Any]):
        new_class = super().__new__(cls, name, bases, attrs)
        if bases and new_class.__is_active__:
            UniqueGiftModelsFactory.register_unique_gift_model(new_class)
        return new_class


class UniqueGiftModelsFactory(TypesFactory):
    """Factory for creating UniqueGiftModel instances."""

    UNIQUEGIFTMODELS_REGISTRY: Dict[str, Type] = {}
    __type_name__ = "unique_gift_model"

    @classmethod
    def register_unique_gift_model(cls, unique_gift_model_cls: Type) -> None:
        """Register a new unique_gift_model handler."""
        instance = unique_gift_model_cls()
        for name in instance.__names__:
            cls.UNIQUEGIFTMODELS_REGISTRY[name] = unique_gift_model_cls

    @classmethod
    async def create(cls, update: Any) -> Optional[Any]:
        """Create handler instance from update."""
        obj = update.unique_gift_model
        trigger_value = obj.sticker
        return cls.UNIQUEGIFTMODELS_REGISTRY.get(trigger_value)()
