# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VlanProfilesArgs', 'VlanProfiles']

@pulumi.input_type
class VlanProfilesArgs:
    def __init__(__self__, *,
                 iname: pulumi.Input[str],
                 network_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 vlan_groups: Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanGroupArgs']]]] = None,
                 vlan_names: Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanNameArgs']]]] = None):
        """
        The set of arguments for constructing a VlanProfiles resource.
        :param pulumi.Input[str] iname: IName of the VLAN profile
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] name: Name of the profile, string length must be from 1 to 255 characters
        :param pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanGroupArgs']]] vlan_groups: An array of named VLANs
        :param pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanNameArgs']]] vlan_names: An array of named VLANs
        """
        pulumi.set(__self__, "iname", iname)
        pulumi.set(__self__, "network_id", network_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vlan_groups is not None:
            pulumi.set(__self__, "vlan_groups", vlan_groups)
        if vlan_names is not None:
            pulumi.set(__self__, "vlan_names", vlan_names)

    @property
    @pulumi.getter
    def iname(self) -> pulumi.Input[str]:
        """
        IName of the VLAN profile
        """
        return pulumi.get(self, "iname")

    @iname.setter
    def iname(self, value: pulumi.Input[str]):
        pulumi.set(self, "iname", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the profile, string length must be from 1 to 255 characters
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="vlanGroups")
    def vlan_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanGroupArgs']]]]:
        """
        An array of named VLANs
        """
        return pulumi.get(self, "vlan_groups")

    @vlan_groups.setter
    def vlan_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanGroupArgs']]]]):
        pulumi.set(self, "vlan_groups", value)

    @property
    @pulumi.getter(name="vlanNames")
    def vlan_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanNameArgs']]]]:
        """
        An array of named VLANs
        """
        return pulumi.get(self, "vlan_names")

    @vlan_names.setter
    def vlan_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanNameArgs']]]]):
        pulumi.set(self, "vlan_names", value)


@pulumi.input_type
class _VlanProfilesState:
    def __init__(__self__, *,
                 iname: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 vlan_groups: Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanGroupArgs']]]] = None,
                 vlan_names: Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanNameArgs']]]] = None):
        """
        Input properties used for looking up and filtering VlanProfiles resources.
        :param pulumi.Input[str] iname: IName of the VLAN profile
        :param pulumi.Input[bool] is_default: Boolean indicating the default VLAN Profile for any device that does not have a profile explicitly assigned
        :param pulumi.Input[str] name: Name of the profile, string length must be from 1 to 255 characters
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanGroupArgs']]] vlan_groups: An array of named VLANs
        :param pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanNameArgs']]] vlan_names: An array of named VLANs
        """
        if iname is not None:
            pulumi.set(__self__, "iname", iname)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if vlan_groups is not None:
            pulumi.set(__self__, "vlan_groups", vlan_groups)
        if vlan_names is not None:
            pulumi.set(__self__, "vlan_names", vlan_names)

    @property
    @pulumi.getter
    def iname(self) -> Optional[pulumi.Input[str]]:
        """
        IName of the VLAN profile
        """
        return pulumi.get(self, "iname")

    @iname.setter
    def iname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iname", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating the default VLAN Profile for any device that does not have a profile explicitly assigned
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the profile, string length must be from 1 to 255 characters
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="vlanGroups")
    def vlan_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanGroupArgs']]]]:
        """
        An array of named VLANs
        """
        return pulumi.get(self, "vlan_groups")

    @vlan_groups.setter
    def vlan_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanGroupArgs']]]]):
        pulumi.set(self, "vlan_groups", value)

    @property
    @pulumi.getter(name="vlanNames")
    def vlan_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanNameArgs']]]]:
        """
        An array of named VLANs
        """
        return pulumi.get(self, "vlan_names")

    @vlan_names.setter
    def vlan_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VlanProfilesVlanNameArgs']]]]):
        pulumi.set(self, "vlan_names", value)


class VlanProfiles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 iname: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 vlan_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanGroupArgs', 'VlanProfilesVlanGroupArgsDict']]]]] = None,
                 vlan_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanNameArgs', 'VlanProfilesVlanNameArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/vlanProfiles:VlanProfiles example "iname,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] iname: IName of the VLAN profile
        :param pulumi.Input[str] name: Name of the profile, string length must be from 1 to 255 characters
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanGroupArgs', 'VlanProfilesVlanGroupArgsDict']]]] vlan_groups: An array of named VLANs
        :param pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanNameArgs', 'VlanProfilesVlanNameArgsDict']]]] vlan_names: An array of named VLANs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VlanProfilesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/vlanProfiles:VlanProfiles example "iname,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param VlanProfilesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VlanProfilesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 iname: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 vlan_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanGroupArgs', 'VlanProfilesVlanGroupArgsDict']]]]] = None,
                 vlan_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanNameArgs', 'VlanProfilesVlanNameArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VlanProfilesArgs.__new__(VlanProfilesArgs)

            if iname is None and not opts.urn:
                raise TypeError("Missing required property 'iname'")
            __props__.__dict__["iname"] = iname
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["vlan_groups"] = vlan_groups
            __props__.__dict__["vlan_names"] = vlan_names
            __props__.__dict__["is_default"] = None
        super(VlanProfiles, __self__).__init__(
            'meraki:networks/vlanProfiles:VlanProfiles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            iname: Optional[pulumi.Input[str]] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            vlan_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanGroupArgs', 'VlanProfilesVlanGroupArgsDict']]]]] = None,
            vlan_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanNameArgs', 'VlanProfilesVlanNameArgsDict']]]]] = None) -> 'VlanProfiles':
        """
        Get an existing VlanProfiles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] iname: IName of the VLAN profile
        :param pulumi.Input[bool] is_default: Boolean indicating the default VLAN Profile for any device that does not have a profile explicitly assigned
        :param pulumi.Input[str] name: Name of the profile, string length must be from 1 to 255 characters
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanGroupArgs', 'VlanProfilesVlanGroupArgsDict']]]] vlan_groups: An array of named VLANs
        :param pulumi.Input[Sequence[pulumi.Input[Union['VlanProfilesVlanNameArgs', 'VlanProfilesVlanNameArgsDict']]]] vlan_names: An array of named VLANs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VlanProfilesState.__new__(_VlanProfilesState)

        __props__.__dict__["iname"] = iname
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["vlan_groups"] = vlan_groups
        __props__.__dict__["vlan_names"] = vlan_names
        return VlanProfiles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def iname(self) -> pulumi.Output[str]:
        """
        IName of the VLAN profile
        """
        return pulumi.get(self, "iname")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[bool]:
        """
        Boolean indicating the default VLAN Profile for any device that does not have a profile explicitly assigned
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the profile, string length must be from 1 to 255 characters
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="vlanGroups")
    def vlan_groups(self) -> pulumi.Output[Sequence['outputs.VlanProfilesVlanGroup']]:
        """
        An array of named VLANs
        """
        return pulumi.get(self, "vlan_groups")

    @property
    @pulumi.getter(name="vlanNames")
    def vlan_names(self) -> pulumi.Output[Sequence['outputs.VlanProfilesVlanName']]:
        """
        An array of named VLANs
        """
        return pulumi.get(self, "vlan_names")

