# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertsProfilesArgs', 'AlertsProfiles']

@pulumi.input_type
class AlertsProfilesArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 alert_condition: Optional[pulumi.Input['AlertsProfilesAlertConditionArgs']] = None,
                 alert_config_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 recipients: Optional[pulumi.Input['AlertsProfilesRecipientsArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AlertsProfiles resource.
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input['AlertsProfilesAlertConditionArgs'] alert_condition: The conditions that determine if the alert triggers
        :param pulumi.Input[str] alert_config_id: alertConfigId path parameter. Alert config ID
        :param pulumi.Input[str] description: User supplied description of the alert
        :param pulumi.Input[bool] enabled: Is the alert config enabled
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_tags: Networks with these tags will be monitored for the alert
        :param pulumi.Input['AlertsProfilesRecipientsArgs'] recipients: List of recipients that will recieve the alert.
        :param pulumi.Input[str] type: The alert type
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if alert_condition is not None:
            pulumi.set(__self__, "alert_condition", alert_condition)
        if alert_config_id is not None:
            pulumi.set(__self__, "alert_config_id", alert_config_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if network_tags is not None:
            pulumi.set(__self__, "network_tags", network_tags)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="alertCondition")
    def alert_condition(self) -> Optional[pulumi.Input['AlertsProfilesAlertConditionArgs']]:
        """
        The conditions that determine if the alert triggers
        """
        return pulumi.get(self, "alert_condition")

    @alert_condition.setter
    def alert_condition(self, value: Optional[pulumi.Input['AlertsProfilesAlertConditionArgs']]):
        pulumi.set(self, "alert_condition", value)

    @property
    @pulumi.getter(name="alertConfigId")
    def alert_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        alertConfigId path parameter. Alert config ID
        """
        return pulumi.get(self, "alert_config_id")

    @alert_config_id.setter
    def alert_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_config_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User supplied description of the alert
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the alert config enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Networks with these tags will be monitored for the alert
        """
        return pulumi.get(self, "network_tags")

    @network_tags.setter
    def network_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_tags", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input['AlertsProfilesRecipientsArgs']]:
        """
        List of recipients that will recieve the alert.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input['AlertsProfilesRecipientsArgs']]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The alert type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _AlertsProfilesState:
    def __init__(__self__, *,
                 alert_condition: Optional[pulumi.Input['AlertsProfilesAlertConditionArgs']] = None,
                 alert_config_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input['AlertsProfilesRecipientsArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AlertsProfiles resources.
        :param pulumi.Input['AlertsProfilesAlertConditionArgs'] alert_condition: The conditions that determine if the alert triggers
        :param pulumi.Input[str] alert_config_id: alertConfigId path parameter. Alert config ID
        :param pulumi.Input[str] description: User supplied description of the alert
        :param pulumi.Input[bool] enabled: Is the alert config enabled
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_tags: Networks with these tags will be monitored for the alert
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input['AlertsProfilesRecipientsArgs'] recipients: List of recipients that will recieve the alert.
        :param pulumi.Input[str] type: The alert type
        """
        if alert_condition is not None:
            pulumi.set(__self__, "alert_condition", alert_condition)
        if alert_config_id is not None:
            pulumi.set(__self__, "alert_config_id", alert_config_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if network_tags is not None:
            pulumi.set(__self__, "network_tags", network_tags)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="alertCondition")
    def alert_condition(self) -> Optional[pulumi.Input['AlertsProfilesAlertConditionArgs']]:
        """
        The conditions that determine if the alert triggers
        """
        return pulumi.get(self, "alert_condition")

    @alert_condition.setter
    def alert_condition(self, value: Optional[pulumi.Input['AlertsProfilesAlertConditionArgs']]):
        pulumi.set(self, "alert_condition", value)

    @property
    @pulumi.getter(name="alertConfigId")
    def alert_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        alertConfigId path parameter. Alert config ID
        """
        return pulumi.get(self, "alert_config_id")

    @alert_config_id.setter
    def alert_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_config_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User supplied description of the alert
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the alert config enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Networks with these tags will be monitored for the alert
        """
        return pulumi.get(self, "network_tags")

    @network_tags.setter
    def network_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_tags", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input['AlertsProfilesRecipientsArgs']]:
        """
        List of recipients that will recieve the alert.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input['AlertsProfilesRecipientsArgs']]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The alert type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class AlertsProfiles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_condition: Optional[pulumi.Input[Union['AlertsProfilesAlertConditionArgs', 'AlertsProfilesAlertConditionArgsDict']]] = None,
                 alert_config_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Union['AlertsProfilesRecipientsArgs', 'AlertsProfilesRecipientsArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/alertsProfiles:AlertsProfiles example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlertsProfilesAlertConditionArgs', 'AlertsProfilesAlertConditionArgsDict']] alert_condition: The conditions that determine if the alert triggers
        :param pulumi.Input[str] alert_config_id: alertConfigId path parameter. Alert config ID
        :param pulumi.Input[str] description: User supplied description of the alert
        :param pulumi.Input[bool] enabled: Is the alert config enabled
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_tags: Networks with these tags will be monitored for the alert
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Union['AlertsProfilesRecipientsArgs', 'AlertsProfilesRecipientsArgsDict']] recipients: List of recipients that will recieve the alert.
        :param pulumi.Input[str] type: The alert type
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertsProfilesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/alertsProfiles:AlertsProfiles example "organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param AlertsProfilesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertsProfilesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_condition: Optional[pulumi.Input[Union['AlertsProfilesAlertConditionArgs', 'AlertsProfilesAlertConditionArgsDict']]] = None,
                 alert_config_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Union['AlertsProfilesRecipientsArgs', 'AlertsProfilesRecipientsArgsDict']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertsProfilesArgs.__new__(AlertsProfilesArgs)

            __props__.__dict__["alert_condition"] = alert_condition
            __props__.__dict__["alert_config_id"] = alert_config_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["network_tags"] = network_tags
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["recipients"] = recipients
            __props__.__dict__["type"] = type
        super(AlertsProfiles, __self__).__init__(
            'meraki:organizations/alertsProfiles:AlertsProfiles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_condition: Optional[pulumi.Input[Union['AlertsProfilesAlertConditionArgs', 'AlertsProfilesAlertConditionArgsDict']]] = None,
            alert_config_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            network_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            recipients: Optional[pulumi.Input[Union['AlertsProfilesRecipientsArgs', 'AlertsProfilesRecipientsArgsDict']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'AlertsProfiles':
        """
        Get an existing AlertsProfiles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlertsProfilesAlertConditionArgs', 'AlertsProfilesAlertConditionArgsDict']] alert_condition: The conditions that determine if the alert triggers
        :param pulumi.Input[str] alert_config_id: alertConfigId path parameter. Alert config ID
        :param pulumi.Input[str] description: User supplied description of the alert
        :param pulumi.Input[bool] enabled: Is the alert config enabled
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_tags: Networks with these tags will be monitored for the alert
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Union['AlertsProfilesRecipientsArgs', 'AlertsProfilesRecipientsArgsDict']] recipients: List of recipients that will recieve the alert.
        :param pulumi.Input[str] type: The alert type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertsProfilesState.__new__(_AlertsProfilesState)

        __props__.__dict__["alert_condition"] = alert_condition
        __props__.__dict__["alert_config_id"] = alert_config_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["network_tags"] = network_tags
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["recipients"] = recipients
        __props__.__dict__["type"] = type
        return AlertsProfiles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertCondition")
    def alert_condition(self) -> pulumi.Output['outputs.AlertsProfilesAlertCondition']:
        """
        The conditions that determine if the alert triggers
        """
        return pulumi.get(self, "alert_condition")

    @property
    @pulumi.getter(name="alertConfigId")
    def alert_config_id(self) -> pulumi.Output[str]:
        """
        alertConfigId path parameter. Alert config ID
        """
        return pulumi.get(self, "alert_config_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        User supplied description of the alert
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Is the alert config enabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Networks with these tags will be monitored for the alert
        """
        return pulumi.get(self, "network_tags")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def recipients(self) -> pulumi.Output['outputs.AlertsProfilesRecipients']:
        """
        List of recipients that will recieve the alert.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The alert type
        """
        return pulumi.get(self, "type")

