# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BrandingPoliciesArgs', 'BrandingPolicies']

@pulumi.input_type
class BrandingPoliciesArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 admin_settings: Optional[pulumi.Input['BrandingPoliciesAdminSettingsArgs']] = None,
                 branding_policy_id: Optional[pulumi.Input[str]] = None,
                 custom_logo: Optional[pulumi.Input['BrandingPoliciesCustomLogoArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 help_settings: Optional[pulumi.Input['BrandingPoliciesHelpSettingsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BrandingPolicies resource.
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input['BrandingPoliciesAdminSettingsArgs'] admin_settings: Settings for describing which kinds of admins this policy applies to.
        :param pulumi.Input[str] branding_policy_id: brandingPolicyId path parameter. Branding policy ID
        :param pulumi.Input['BrandingPoliciesCustomLogoArgs'] custom_logo: Properties describing the custom logo attached to the branding policy.
        :param pulumi.Input[bool] enabled: Boolean indicating whether this policy is enabled.
        :param pulumi.Input['BrandingPoliciesHelpSettingsArgs'] help_settings: Settings for describing the modifications to various Help page features. Each property in this object accepts one of
                 'default or inherit' (do not modify functionality), 'hide' (remove the section from Dashboard), or 'show' (always show
                 the section on Dashboard). Some properties in this object also accept custom HTML used to replace the section on
                 Dashboard; see the documentation for each property to see the allowed values.
        :param pulumi.Input[str] name: Name of the Dashboard branding policy.
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if admin_settings is not None:
            pulumi.set(__self__, "admin_settings", admin_settings)
        if branding_policy_id is not None:
            pulumi.set(__self__, "branding_policy_id", branding_policy_id)
        if custom_logo is not None:
            pulumi.set(__self__, "custom_logo", custom_logo)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if help_settings is not None:
            pulumi.set(__self__, "help_settings", help_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="adminSettings")
    def admin_settings(self) -> Optional[pulumi.Input['BrandingPoliciesAdminSettingsArgs']]:
        """
        Settings for describing which kinds of admins this policy applies to.
        """
        return pulumi.get(self, "admin_settings")

    @admin_settings.setter
    def admin_settings(self, value: Optional[pulumi.Input['BrandingPoliciesAdminSettingsArgs']]):
        pulumi.set(self, "admin_settings", value)

    @property
    @pulumi.getter(name="brandingPolicyId")
    def branding_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        brandingPolicyId path parameter. Branding policy ID
        """
        return pulumi.get(self, "branding_policy_id")

    @branding_policy_id.setter
    def branding_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branding_policy_id", value)

    @property
    @pulumi.getter(name="customLogo")
    def custom_logo(self) -> Optional[pulumi.Input['BrandingPoliciesCustomLogoArgs']]:
        """
        Properties describing the custom logo attached to the branding policy.
        """
        return pulumi.get(self, "custom_logo")

    @custom_logo.setter
    def custom_logo(self, value: Optional[pulumi.Input['BrandingPoliciesCustomLogoArgs']]):
        pulumi.set(self, "custom_logo", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether this policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="helpSettings")
    def help_settings(self) -> Optional[pulumi.Input['BrandingPoliciesHelpSettingsArgs']]:
        """
        Settings for describing the modifications to various Help page features. Each property in this object accepts one of
          'default or inherit' (do not modify functionality), 'hide' (remove the section from Dashboard), or 'show' (always show
          the section on Dashboard). Some properties in this object also accept custom HTML used to replace the section on
          Dashboard; see the documentation for each property to see the allowed values.
        """
        return pulumi.get(self, "help_settings")

    @help_settings.setter
    def help_settings(self, value: Optional[pulumi.Input['BrandingPoliciesHelpSettingsArgs']]):
        pulumi.set(self, "help_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Dashboard branding policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _BrandingPoliciesState:
    def __init__(__self__, *,
                 admin_settings: Optional[pulumi.Input['BrandingPoliciesAdminSettingsArgs']] = None,
                 branding_policy_id: Optional[pulumi.Input[str]] = None,
                 custom_logo: Optional[pulumi.Input['BrandingPoliciesCustomLogoArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 help_settings: Optional[pulumi.Input['BrandingPoliciesHelpSettingsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BrandingPolicies resources.
        :param pulumi.Input['BrandingPoliciesAdminSettingsArgs'] admin_settings: Settings for describing which kinds of admins this policy applies to.
        :param pulumi.Input[str] branding_policy_id: brandingPolicyId path parameter. Branding policy ID
        :param pulumi.Input['BrandingPoliciesCustomLogoArgs'] custom_logo: Properties describing the custom logo attached to the branding policy.
        :param pulumi.Input[bool] enabled: Boolean indicating whether this policy is enabled.
        :param pulumi.Input['BrandingPoliciesHelpSettingsArgs'] help_settings: Settings for describing the modifications to various Help page features. Each property in this object accepts one of
                 'default or inherit' (do not modify functionality), 'hide' (remove the section from Dashboard), or 'show' (always show
                 the section on Dashboard). Some properties in this object also accept custom HTML used to replace the section on
                 Dashboard; see the documentation for each property to see the allowed values.
        :param pulumi.Input[str] name: Name of the Dashboard branding policy.
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        """
        if admin_settings is not None:
            pulumi.set(__self__, "admin_settings", admin_settings)
        if branding_policy_id is not None:
            pulumi.set(__self__, "branding_policy_id", branding_policy_id)
        if custom_logo is not None:
            pulumi.set(__self__, "custom_logo", custom_logo)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if help_settings is not None:
            pulumi.set(__self__, "help_settings", help_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter(name="adminSettings")
    def admin_settings(self) -> Optional[pulumi.Input['BrandingPoliciesAdminSettingsArgs']]:
        """
        Settings for describing which kinds of admins this policy applies to.
        """
        return pulumi.get(self, "admin_settings")

    @admin_settings.setter
    def admin_settings(self, value: Optional[pulumi.Input['BrandingPoliciesAdminSettingsArgs']]):
        pulumi.set(self, "admin_settings", value)

    @property
    @pulumi.getter(name="brandingPolicyId")
    def branding_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        brandingPolicyId path parameter. Branding policy ID
        """
        return pulumi.get(self, "branding_policy_id")

    @branding_policy_id.setter
    def branding_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branding_policy_id", value)

    @property
    @pulumi.getter(name="customLogo")
    def custom_logo(self) -> Optional[pulumi.Input['BrandingPoliciesCustomLogoArgs']]:
        """
        Properties describing the custom logo attached to the branding policy.
        """
        return pulumi.get(self, "custom_logo")

    @custom_logo.setter
    def custom_logo(self, value: Optional[pulumi.Input['BrandingPoliciesCustomLogoArgs']]):
        pulumi.set(self, "custom_logo", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether this policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="helpSettings")
    def help_settings(self) -> Optional[pulumi.Input['BrandingPoliciesHelpSettingsArgs']]:
        """
        Settings for describing the modifications to various Help page features. Each property in this object accepts one of
          'default or inherit' (do not modify functionality), 'hide' (remove the section from Dashboard), or 'show' (always show
          the section on Dashboard). Some properties in this object also accept custom HTML used to replace the section on
          Dashboard; see the documentation for each property to see the allowed values.
        """
        return pulumi.get(self, "help_settings")

    @help_settings.setter
    def help_settings(self, value: Optional[pulumi.Input['BrandingPoliciesHelpSettingsArgs']]):
        pulumi.set(self, "help_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Dashboard branding policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)


class BrandingPolicies(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_settings: Optional[pulumi.Input[Union['BrandingPoliciesAdminSettingsArgs', 'BrandingPoliciesAdminSettingsArgsDict']]] = None,
                 branding_policy_id: Optional[pulumi.Input[str]] = None,
                 custom_logo: Optional[pulumi.Input[Union['BrandingPoliciesCustomLogoArgs', 'BrandingPoliciesCustomLogoArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 help_settings: Optional[pulumi.Input[Union['BrandingPoliciesHelpSettingsArgs', 'BrandingPoliciesHelpSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/brandingPolicies:BrandingPolicies example "branding_policy_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BrandingPoliciesAdminSettingsArgs', 'BrandingPoliciesAdminSettingsArgsDict']] admin_settings: Settings for describing which kinds of admins this policy applies to.
        :param pulumi.Input[str] branding_policy_id: brandingPolicyId path parameter. Branding policy ID
        :param pulumi.Input[Union['BrandingPoliciesCustomLogoArgs', 'BrandingPoliciesCustomLogoArgsDict']] custom_logo: Properties describing the custom logo attached to the branding policy.
        :param pulumi.Input[bool] enabled: Boolean indicating whether this policy is enabled.
        :param pulumi.Input[Union['BrandingPoliciesHelpSettingsArgs', 'BrandingPoliciesHelpSettingsArgsDict']] help_settings: Settings for describing the modifications to various Help page features. Each property in this object accepts one of
                 'default or inherit' (do not modify functionality), 'hide' (remove the section from Dashboard), or 'show' (always show
                 the section on Dashboard). Some properties in this object also accept custom HTML used to replace the section on
                 Dashboard; see the documentation for each property to see the allowed values.
        :param pulumi.Input[str] name: Name of the Dashboard branding policy.
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BrandingPoliciesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:organizations/brandingPolicies:BrandingPolicies example "branding_policy_id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param BrandingPoliciesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BrandingPoliciesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_settings: Optional[pulumi.Input[Union['BrandingPoliciesAdminSettingsArgs', 'BrandingPoliciesAdminSettingsArgsDict']]] = None,
                 branding_policy_id: Optional[pulumi.Input[str]] = None,
                 custom_logo: Optional[pulumi.Input[Union['BrandingPoliciesCustomLogoArgs', 'BrandingPoliciesCustomLogoArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 help_settings: Optional[pulumi.Input[Union['BrandingPoliciesHelpSettingsArgs', 'BrandingPoliciesHelpSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BrandingPoliciesArgs.__new__(BrandingPoliciesArgs)

            __props__.__dict__["admin_settings"] = admin_settings
            __props__.__dict__["branding_policy_id"] = branding_policy_id
            __props__.__dict__["custom_logo"] = custom_logo
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["help_settings"] = help_settings
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
        super(BrandingPolicies, __self__).__init__(
            'meraki:organizations/brandingPolicies:BrandingPolicies',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_settings: Optional[pulumi.Input[Union['BrandingPoliciesAdminSettingsArgs', 'BrandingPoliciesAdminSettingsArgsDict']]] = None,
            branding_policy_id: Optional[pulumi.Input[str]] = None,
            custom_logo: Optional[pulumi.Input[Union['BrandingPoliciesCustomLogoArgs', 'BrandingPoliciesCustomLogoArgsDict']]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            help_settings: Optional[pulumi.Input[Union['BrandingPoliciesHelpSettingsArgs', 'BrandingPoliciesHelpSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None) -> 'BrandingPolicies':
        """
        Get an existing BrandingPolicies resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BrandingPoliciesAdminSettingsArgs', 'BrandingPoliciesAdminSettingsArgsDict']] admin_settings: Settings for describing which kinds of admins this policy applies to.
        :param pulumi.Input[str] branding_policy_id: brandingPolicyId path parameter. Branding policy ID
        :param pulumi.Input[Union['BrandingPoliciesCustomLogoArgs', 'BrandingPoliciesCustomLogoArgsDict']] custom_logo: Properties describing the custom logo attached to the branding policy.
        :param pulumi.Input[bool] enabled: Boolean indicating whether this policy is enabled.
        :param pulumi.Input[Union['BrandingPoliciesHelpSettingsArgs', 'BrandingPoliciesHelpSettingsArgsDict']] help_settings: Settings for describing the modifications to various Help page features. Each property in this object accepts one of
                 'default or inherit' (do not modify functionality), 'hide' (remove the section from Dashboard), or 'show' (always show
                 the section on Dashboard). Some properties in this object also accept custom HTML used to replace the section on
                 Dashboard; see the documentation for each property to see the allowed values.
        :param pulumi.Input[str] name: Name of the Dashboard branding policy.
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BrandingPoliciesState.__new__(_BrandingPoliciesState)

        __props__.__dict__["admin_settings"] = admin_settings
        __props__.__dict__["branding_policy_id"] = branding_policy_id
        __props__.__dict__["custom_logo"] = custom_logo
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["help_settings"] = help_settings
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        return BrandingPolicies(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminSettings")
    def admin_settings(self) -> pulumi.Output['outputs.BrandingPoliciesAdminSettings']:
        """
        Settings for describing which kinds of admins this policy applies to.
        """
        return pulumi.get(self, "admin_settings")

    @property
    @pulumi.getter(name="brandingPolicyId")
    def branding_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        brandingPolicyId path parameter. Branding policy ID
        """
        return pulumi.get(self, "branding_policy_id")

    @property
    @pulumi.getter(name="customLogo")
    def custom_logo(self) -> pulumi.Output['outputs.BrandingPoliciesCustomLogo']:
        """
        Properties describing the custom logo attached to the branding policy.
        """
        return pulumi.get(self, "custom_logo")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Boolean indicating whether this policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="helpSettings")
    def help_settings(self) -> pulumi.Output['outputs.BrandingPoliciesHelpSettings']:
        """
        Settings for describing the modifications to various Help page features. Each property in this object accepts one of
          'default or inherit' (do not modify functionality), 'hide' (remove the section from Dashboard), or 'show' (always show
          the section on Dashboard). Some properties in this object also accept custom HTML used to replace the section on
          Dashboard; see the documentation for each property to see the allowed values.
        """
        return pulumi.get(self, "help_settings")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Dashboard branding policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

