export declare enum DependenciesFile {
    PIP = "requirements.txt",
    POETRY = "poetry.lock",
    PIPENV = "Pipfile.lock",
    NONE = ""
}
export interface PackagingProps {
    /**
     * Dependency file for the type of packaging.
     */
    readonly dependenciesFile: DependenciesFile;
    /**
     * Command to export the dependencies into a pip-compatible `requirements.txt` format.
     *
     * @default - No dependencies are exported.
     */
    readonly exportCommand?: string;
}
export interface PoetryPackagingProps {
    /**
     * Whether to export Poetry dependencies with hashes. Note that this can cause builds to fail if not all dependencies
     * export with a hash.
     *
     * @see https://github.com/aws/aws-cdk/issues/19232
     * @default Hashes are NOT included in the exported `requirements.txt` file.
     */
    readonly poetryIncludeHashes?: boolean;
    /**
     * Whether to export Poetry dependencies with source repository urls.
     *
     * @default URLs are included in the exported `requirements.txt` file.
     */
    readonly poetryWithoutUrls?: boolean;
}
export declare class Packaging {
    /**
     * Standard packaging with `pip`.
     */
    static withPip(): Packaging;
    /**
     * Packaging with `pipenv`.
     */
    static withPipenv(): Packaging;
    /**
     * Packaging with `poetry`.
     */
    static withPoetry(props?: PoetryPackagingProps): Packaging;
    /**
     * No dependencies or packaging.
     */
    static withNoPackaging(): Packaging;
    static fromEntry(entry: string, poetryIncludeHashes?: boolean, poetryWithoutUrls?: boolean): Packaging;
    readonly dependenciesFile: string;
    readonly exportCommand?: string;
    constructor(props: PackagingProps);
}
