/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.trustyuri.ModuleDirectory;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriModule;
import net.trustyuri.TrustyUriResource;

public class CheckFile {
    private TrustyUriResource r;

    public static void main(String[] args) throws IOException, TrustyUriException {
        for (String arg : args) {
            CheckFile.check(arg);
        }
    }

    public static void check(String fileOrUrl) throws IOException, TrustyUriException {
        CheckFile c;
        try {
            URL url = new URL(fileOrUrl);
            c = new CheckFile(url);
        }
        catch (MalformedURLException ex) {
            c = new CheckFile(new File(fileOrUrl));
        }
        boolean valid = c.check();
        if (valid) {
            System.out.println("Correct hash: " + c.r.getArtifactCode());
        } else {
            System.out.println("*** INCORRECT HASH ***");
        }
    }

    public CheckFile(URL url) throws IOException {
        this.r = new TrustyUriResource(url);
    }

    public CheckFile(File file) throws IOException {
        this.r = new TrustyUriResource(file);
    }

    public boolean check() throws IOException, TrustyUriException {
        TrustyUriModule module = ModuleDirectory.getModule(this.r.getModuleId());
        if (module == null) {
            throw new TrustyUriException("ERROR: Not a trusty URI or unknown module");
        }
        return module.hasCorrectHash(this.r);
    }
}

