/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.trustyuri.Run;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.RDF4JException;

public class RunBatch {
    private RunBatch() {
    }

    public static void main(String[] args) throws IOException, RDF4JException, TrustyUriException {
        String line;
        String batchFile = args[0];
        BufferedReader reader = new BufferedReader(new FileReader(batchFile));
        int startFrom = 0;
        File runningFile = new File(batchFile + ".running");
        if (runningFile.exists()) {
            startFrom = new Integer(RunBatch.readFile(runningFile)) + 1;
            System.out.println("===");
            System.out.println("RESUMING at line " + startFrom);
            System.out.println("===");
        } else {
            RunBatch.writeFile(runningFile, startFrom + "");
        }
        int lineNumber = -1;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#' || startFrom > ++lineNumber) continue;
            RunBatch.writeFile(runningFile, lineNumber + "");
            System.out.println("COMMAND: " + line);
            String[] cmd = line.split("\\s+");
            long ns = System.nanoTime();
            try {
                Run.run(cmd);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (OutOfMemoryError err) {
                err.printStackTrace();
                System.exit(99);
            }
            long t = System.nanoTime() - ns;
            System.out.println("Time in seconds: " + (double)t / 1.0E9);
            System.out.println("---");
        }
        reader.close();
        runningFile.delete();
    }

    static String readFile(File file) throws IOException {
        byte[] encoded = Files.readAllBytes(file.toPath());
        return Charset.forName("UTF-8").decode(ByteBuffer.wrap(encoded)).toString();
    }

    static void writeFile(File file, String content) throws IOException {
        Files.write(file.toPath(), content.getBytes(), new OpenOption[0]);
    }
}

