/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri.rdf;

import com.google.code.externalsorting.ExternalSort;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.List;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriResource;
import net.trustyuri.rdf.RdfHasher;
import net.trustyuri.rdf.RdfPreprocessor;
import net.trustyuri.rdf.RdfUtils;
import net.trustyuri.rdf.SerStatementComparator;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class CheckLargeRdf {
    private File file;
    private MessageDigest md;
    private String ac;

    public static void main(String[] args) throws IOException, TrustyUriException {
        File file = new File(args[0]);
        CheckLargeRdf t = new CheckLargeRdf(file);
        boolean valid = t.check();
        if (valid) {
            System.out.println("Correct hash: " + t.ac);
        } else {
            System.out.println("*** INCORRECT HASH ***");
        }
    }

    public CheckLargeRdf(File file) {
        this.file = file;
    }

    public boolean check() throws IOException, TrustyUriException {
        String line;
        TrustyUriResource r = new TrustyUriResource(this.file);
        File dir = this.file.getParentFile();
        String fileName = this.file.getName();
        this.md = RdfHasher.getDigest();
        RDFFormat format = r.getFormat(RDFFormat.TURTLE);
        RDFParser p = RdfUtils.getParser(format);
        File sortInFile = new File(dir, fileName + ".temp.sort-in");
        final FileOutputStream preOut = new FileOutputStream(sortInFile);
        p.setRDFHandler(new RdfPreprocessor((RDFHandler)new AbstractRDFHandler(){

            @Override
            public void handleStatement(Statement st) throws RDFHandlerException {
                String s = SerStatementComparator.toString(st) + "\n";
                try {
                    preOut.write(s.getBytes(Charset.forName("UTF-8")));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }, r.getArtifactCode()));
        BufferedReader reader = new BufferedReader(r.getInputStreamReader(), 65536);
        try {
            p.parse(reader, "");
        }
        catch (RDF4JException ex) {
            throw new TrustyUriException(ex);
        }
        finally {
            reader.close();
            preOut.close();
        }
        File sortOutFile = new File(dir, fileName + ".temp.sort-out");
        File sortTempDir = new File(dir, fileName + ".temp");
        sortTempDir.mkdir();
        SerStatementComparator cmp = new SerStatementComparator();
        Charset cs = Charset.defaultCharset();
        System.gc();
        List<File> tempFiles = ExternalSort.sortInBatch(sortInFile, cmp, 1024, cs, sortTempDir, false);
        ExternalSort.mergeSortedFiles(tempFiles, sortOutFile, (Comparator<String>)cmp, cs);
        sortInFile.delete();
        sortTempDir.delete();
        BufferedReader br = new BufferedReader(new FileReader(sortOutFile));
        Statement previous = null;
        while ((line = br.readLine()) != null) {
            Statement st = SerStatementComparator.fromString(line);
            if (!st.equals(previous)) {
                RdfHasher.digest(st, this.md);
            }
            previous = st;
        }
        br.close();
        sortOutFile.delete();
        this.ac = RdfHasher.getArtifactCode(this.md);
        return this.ac.equals(r.getArtifactCode());
    }
}

