/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri.rdf;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriResource;
import net.trustyuri.TrustyUriUtils;
import net.trustyuri.rdf.RdfFileContent;
import net.trustyuri.rdf.RdfHasher;
import net.trustyuri.rdf.RdfPreprocessor;
import net.trustyuri.rdf.RdfUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class CheckRdfGraph {
    private TrustyUriResource r;
    private RdfFileContent content;

    public static void main(String[] args) throws IOException, TrustyUriException {
        CheckRdfGraph c;
        if (args.length < 2) {
            throw new RuntimeException("Not enough arguments: <file> <graph-uri1> (<graph-uri2> ...)");
        }
        String fileName = args[0];
        try {
            URL url = new URL(fileName);
            c = new CheckRdfGraph(url);
        }
        catch (MalformedURLException ex) {
            c = new CheckRdfGraph(new File(fileName));
        }
        for (int i = 1; i < args.length; ++i) {
            IRI graphUri = SimpleValueFactory.getInstance().createIRI(args[i]);
            boolean valid = c.check(graphUri);
            if (valid) {
                System.out.println("Correct hash: " + CheckRdfGraph.getArtifactCode(graphUri));
                continue;
            }
            System.out.println("*** INCORRECT HASH ***");
        }
    }

    public CheckRdfGraph(URL url) throws IOException, TrustyUriException {
        this.r = new TrustyUriResource(url);
        this.init();
    }

    public CheckRdfGraph(File file) throws IOException, TrustyUriException {
        this.r = new TrustyUriResource(file);
        this.init();
    }

    private void init() throws IOException, TrustyUriException {
        this.content = RdfUtils.load(this.r);
    }

    public boolean check(IRI graphUri) throws TrustyUriException {
        String artifactCode = CheckRdfGraph.getArtifactCode(graphUri);
        if (artifactCode == null) {
            throw new TrustyUriException("Not a trusty URI: " + graphUri);
        }
        if (!TrustyUriUtils.getModuleId(artifactCode).equals("RB")) {
            throw new TrustyUriException("Not a trusty URI of type RB: " + graphUri);
        }
        List<Statement> graph = new ArrayList<Statement>();
        for (Statement st : this.content.getStatements()) {
            if (!graphUri.equals(st.getContext())) continue;
            graph.add(st);
        }
        graph = RdfPreprocessor.run(graph, artifactCode);
        String ac = RdfHasher.makeGraphArtifactCode(graph);
        return artifactCode.equals(ac);
    }

    private static String getArtifactCode(IRI graphUri) {
        return TrustyUriUtils.getArtifactCode(graphUri.stringValue());
    }
}

