/*
 * Decompiled with CFR 0.152.
 */
package net.trustyuri.rdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class RdfFileContent
implements RDFHandler {
    private Map<Value, Value> rdfEntityMap = new HashMap<Value, Value>();
    private RDFFormat originalFormat = null;
    private List<Pair<String, String>> namespaces;
    private List<Statement> statements;

    public RdfFileContent(RDFFormat originalFormat) {
        this.originalFormat = originalFormat;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.namespaces = new ArrayList<Pair<String, String>>();
        this.statements = new ArrayList<Statement>();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaces.add(Pair.of(prefix, uri));
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        Value obj;
        IRI pred;
        Resource subj = (Resource)this.rdfEntityMap.get(st.getSubject());
        if (subj == null) {
            subj = st.getSubject();
            this.rdfEntityMap.put(subj, subj);
        }
        if ((pred = (IRI)this.rdfEntityMap.get(st.getPredicate())) == null) {
            pred = st.getPredicate();
            this.rdfEntityMap.put(pred, pred);
        }
        if ((obj = this.rdfEntityMap.get(st.getObject())) == null) {
            obj = st.getObject();
            this.rdfEntityMap.put(obj, obj);
        }
        Resource context = null;
        if (st.getContext() == null) {
            st = SimpleValueFactory.getInstance().createStatement(subj, pred, obj);
        } else {
            context = (Resource)this.rdfEntityMap.get(st.getContext());
            if (context == null) {
                context = st.getContext();
                this.rdfEntityMap.put(context, context);
            }
            st = SimpleValueFactory.getInstance().createStatement(subj, pred, obj, context);
        }
        this.statements.add(st);
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public List<Pair<String, String>> getNamespaces() {
        return this.namespaces;
    }

    public void propagate(RDFHandler handler) throws RDFHandlerException {
        this.propagate(handler, true);
    }

    public void propagate(RDFHandler handler, boolean doStartAndEnd) throws RDFHandlerException {
        if (doStartAndEnd) {
            handler.startRDF();
        }
        for (Pair<String, String> ns : this.namespaces) {
            handler.handleNamespace(ns.getLeft(), ns.getRight());
        }
        Statement prev = null;
        for (Statement st : this.statements) {
            if (prev != null && prev.equals(st)) continue;
            prev = st;
            handler.handleStatement(st);
        }
        if (doStartAndEnd) {
            handler.endRDF();
        }
    }

    public RDFFormat getOriginalFormat() {
        return this.originalFormat;
    }
}

