/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import net.trustyuri.TrustyUriUtils;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.extra.security.LegacySignatureUtils;
import org.nanopub.extra.security.MalformedCryptoElementException;
import org.nanopub.extra.security.NanopubSignatureElement;
import org.nanopub.extra.security.SignatureUtils;
import org.nanopub.trusty.TrustyNanopubUtils;

public class CheckNanopub {
    @Parameter(description="input-nanopubs", required=true)
    private List<String> inputNanopubs = new ArrayList<String>();
    @Parameter(names={"-v"}, description="Verbose")
    private boolean verbose = false;
    @Parameter(names={"-s"}, description="Load nanopubs from given SPARQL endpoint")
    private String sparqlEndpointUrl;
    private Report report;
    private int count;
    private SPARQLRepository sparqlRepo;
    private PrintStream logOut;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        CheckNanopub obj = new CheckNanopub(new String[0]);
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.setLogPrintStream(System.out);
            Report report = obj.check();
            System.out.println("Summary: " + report.getSummary());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public CheckNanopub(List<String> inputNanopubFiles) {
        this.inputNanopubs = inputNanopubFiles;
    }

    public CheckNanopub(String ... inputNanopubFiles) {
        for (String i : inputNanopubFiles) {
            this.inputNanopubs.add(i);
        }
    }

    public CheckNanopub(String sparqlEndpointUrl, List<String> inputNanopubIds) {
        this.inputNanopubs = inputNanopubIds;
        this.sparqlEndpointUrl = sparqlEndpointUrl;
    }

    public Report check() throws IOException {
        this.report = new Report();
        for (String s : this.inputNanopubs) {
            this.count = 0;
            try {
                if (this.sparqlEndpointUrl != null) {
                    if (this.sparqlRepo == null) {
                        this.sparqlRepo = new SPARQLRepository(this.sparqlEndpointUrl);
                        this.sparqlRepo.initialize();
                    }
                    NanopubImpl np = new NanopubImpl(this.sparqlRepo, SimpleValueFactory.getInstance().createIRI(s));
                    this.check(np);
                    continue;
                }
                if (this.verbose) {
                    this.log("Reading file: " + s + "\n");
                }
                MultiNanopubRdfHandler.process(new File(s), new MultiNanopubRdfHandler.NanopubHandler(){

                    @Override
                    public void handleNanopub(Nanopub np) {
                        CheckNanopub.this.count++;
                        if (CheckNanopub.this.count % 100 == 0) {
                            CheckNanopub.this.log(CheckNanopub.this.count + " nanopubs...\r");
                        }
                        CheckNanopub.this.check(np);
                    }
                });
                if (this.count != 0) continue;
                this.log("NO NANOPUB FOUND: " + s + "\n");
                this.report.countError();
            }
            catch (RDF4JException ex) {
                this.log("RDF ERROR: " + s + "\n");
                if (this.logOut != null) {
                    ex.printStackTrace(this.logOut);
                }
                this.report.countError();
            }
            catch (MalformedNanopubException ex) {
                this.log("INVALID NANOPUB: " + s + "\n");
                if (this.logOut != null) {
                    ex.printStackTrace(this.logOut);
                }
                this.report.countInvalid();
            }
        }
        if (this.sparqlRepo != null) {
            try {
                this.sparqlRepo.shutDown();
            }
            catch (RepositoryException ex) {
                ex.printStackTrace();
            }
        }
        return this.report;
    }

    private void check(Nanopub np) {
        if (TrustyNanopubUtils.isValidTrustyNanopub(np)) {
            NanopubSignatureElement se = null;
            NanopubSignatureElement legacySe = null;
            try {
                se = SignatureUtils.getSignatureElement(np);
                if (se == null) {
                    legacySe = LegacySignatureUtils.getSignatureElement(np);
                }
            }
            catch (MalformedCryptoElementException ex) {
                System.out.println("SIGNATURE IS NOT WELL-FORMED (" + ex.getMessage() + "): " + np.getUri());
                this.report.countInvalidSignature();
                return;
            }
            if (se == null && legacySe == null) {
                if (this.verbose) {
                    System.out.println("Trusty (without signature): " + np.getUri());
                }
                this.report.countTrusty();
            } else if (se != null) {
                boolean valid = false;
                try {
                    valid = SignatureUtils.hasValidSignature(se);
                }
                catch (GeneralSecurityException ex) {
                    System.out.println("FAILED TO CHECK SIGNATURE: " + np.getUri() + " (" + ex.getMessage() + ")");
                    this.report.countError();
                    return;
                }
                if (valid) {
                    if (this.verbose) {
                        System.out.println("Signed and trusty: " + np.getUri());
                    }
                    this.report.countSigned();
                } else {
                    System.out.println("INVALID SIGNATURE: " + np.getUri());
                    this.report.countInvalidSignature();
                }
            } else {
                boolean valid = false;
                try {
                    valid = LegacySignatureUtils.hasValidSignature(legacySe);
                }
                catch (GeneralSecurityException ex) {
                    System.out.println("FAILED TO CHECK LEGACY SIGNATURE: " + np.getUri() + " (" + ex.getMessage() + ")");
                    this.report.countError();
                    return;
                }
                if (valid) {
                    if (this.verbose) {
                        System.out.println("Trusty with legacy signature: " + np.getUri());
                    }
                    this.report.countLegacySigned();
                } else {
                    System.out.println("INVALID LEGACY SIGNATURE: " + np.getUri());
                    this.report.countInvalidSignature();
                }
            }
        } else if (TrustyUriUtils.isPotentialTrustyUri(np.getUri())) {
            System.out.println("Looks like a trusty nanopub BUT VERIFICATION FAILED: " + np.getUri());
            this.report.countNotTrusty();
        } else {
            if (this.verbose) {
                System.out.println("Valid (but not trusty): " + np.getUri());
            }
            this.report.countNotTrusty();
        }
    }

    public void setLogPrintStream(PrintStream logOut) {
        this.logOut = logOut;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void log(String message) {
        if (this.logOut != null) {
            this.logOut.print(message);
        }
    }

    public class Report {
        private int signed;
        private int legacySigned;
        private int trusty;
        private int notTrusty;
        private int invalidSignature;
        private int invalid;
        private int error;

        private Report() {
        }

        private void countSigned() {
            ++this.signed;
        }

        public int getSignedCount() {
            return this.signed;
        }

        private void countLegacySigned() {
            ++this.legacySigned;
        }

        public int getLegacySignedCount() {
            return this.legacySigned;
        }

        private void countTrusty() {
            ++this.trusty;
        }

        public int getTrustyCount() {
            return this.trusty;
        }

        private void countNotTrusty() {
            ++this.notTrusty;
        }

        public int getNotTrustyCount() {
            return this.notTrusty;
        }

        private void countInvalidSignature() {
            ++this.invalidSignature;
        }

        public int getInvalidSignatureCount() {
            return this.invalidSignature;
        }

        private void countInvalid() {
            ++this.invalid;
        }

        public int getInvalidCount() {
            return this.invalid;
        }

        private void countError() {
            ++this.error;
        }

        public int getErrorCount() {
            return this.error;
        }

        public int getAllValidCount() {
            return this.signed + this.trusty + this.notTrusty;
        }

        public int getAllInvalidCount() {
            return this.invalidSignature + this.invalid + this.error;
        }

        public boolean areAllValid() {
            return this.getAllInvalidCount() == 0;
        }

        public String getSummary() {
            String s = "";
            if (this.signed > 0) {
                s = s + " " + this.signed + " trusty with signature;";
            }
            if (this.legacySigned > 0) {
                s = s + " " + this.legacySigned + " trusty with legacy signature;";
            }
            if (this.trusty > 0) {
                s = s + " " + this.trusty + " trusty (without signature);";
            }
            if (this.notTrusty > 0) {
                s = s + " " + this.notTrusty + " valid (not trusty);";
            }
            if (this.invalidSignature > 0) {
                s = s + " " + this.invalidSignature + " invalid signature;";
            }
            if (this.invalid > 0) {
                s = s + " " + this.invalid + " invalid nanopubs;";
            }
            if (this.error > 0) {
                s = s + " " + this.error + " errors;";
            }
            s = s.replaceFirst("^ ", "");
            return s;
        }
    }
}

