/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;

public class MultiNanopubRdfHandler
extends AbstractRDFHandler {
    private NanopubHandler npHandler;
    private Map<IRI, Boolean> graphs = new HashMap<IRI, Boolean>();
    private Map<IRI, Map<IRI, Boolean>> members = new HashMap<IRI, Map<IRI, Boolean>>();
    private Set<Statement> statements = new LinkedHashSet<Statement>();
    private List<String> nsPrefixes = new ArrayList<String>();
    private Map<String, String> ns = new HashMap<String, String>();
    private List<String> newNsPrefixes = new ArrayList<String>();
    private List<String> newNs = new ArrayList<String>();

    public static void process(RDFFormat format, InputStream in, NanopubHandler npHandler) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        MultiNanopubRdfHandler.process(format, in, null, npHandler);
    }

    public static void process(RDFFormat format, File file, NanopubHandler npHandler) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        FilterInputStream in = file.getName().matches(".*\\.(gz|gzip)") ? new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))) : new BufferedInputStream(new FileInputStream(file));
        MultiNanopubRdfHandler.process(format, in, file, npHandler);
    }

    public static void process(File file, NanopubHandler npHandler) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        RDFFormat format = Rio.getParserFormatForFileName(file.getName()).orElse(RDFFormat.TRIG);
        MultiNanopubRdfHandler.process(format, file, npHandler);
    }

    private static void process(RDFFormat format, InputStream in, File file, NanopubHandler npHandler) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        RDFParser p = NanopubUtils.getParser(format);
        p.setRDFHandler(new MultiNanopubRdfHandler(npHandler));
        try {
            p.parse(new InputStreamReader(in, Charset.forName("UTF-8")), "");
        }
        catch (RuntimeException ex) {
            if ("wrapped MalformedNanopubException".equals(ex.getMessage()) && ex.getCause() instanceof MalformedNanopubException) {
                throw (MalformedNanopubException)ex.getCause();
            }
            throw ex;
        }
        finally {
            in.close();
        }
    }

    public MultiNanopubRdfHandler(NanopubHandler npHandler) {
        this.npHandler = npHandler;
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.graphs.containsKey(st.getContext())) {
            if (this.graphs.size() == 4) {
                this.finishAndReset();
                this.handleStatement(st);
                return;
            }
            this.graphs.put((IRI)st.getContext(), true);
        }
        this.addNamespaces();
        this.statements.add(st);
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.newNs.add(uri);
        this.newNsPrefixes.add(prefix);
    }

    public void addNamespaces() throws RDFHandlerException {
        for (int i = 0; i < this.newNs.size(); ++i) {
            String prefix = this.newNsPrefixes.get(i);
            String nsUri = this.newNs.get(i);
            this.nsPrefixes.remove(prefix);
            this.nsPrefixes.add(prefix);
            this.ns.put(prefix, nsUri);
        }
        this.newNs.clear();
        this.newNsPrefixes.clear();
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.finishAndReset();
    }

    private void finishAndReset() {
        try {
            this.npHandler.handleNanopub(new NanopubImpl(this.statements, this.nsPrefixes, this.ns));
        }
        catch (MalformedNanopubException ex) {
            this.throwMalformed(ex);
        }
        this.clearAll();
    }

    private void clearAll() {
        this.graphs.clear();
        this.members.clear();
        this.statements.clear();
    }

    private void throwMalformed(MalformedNanopubException ex) {
        throw new RuntimeException("wrapped MalformedNanopubException", ex);
    }

    public static interface NanopubHandler {
        public void handleNanopub(Nanopub var1);
    }
}

