/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.index;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;
import org.nanopub.extra.index.IndexUtils;
import org.nanopub.extra.index.NanopubIndex;
import org.nanopub.extra.index.SimpleIndexCreator;

public class MakeIndex {
    @Parameter(description="input-nanopub-files")
    private List<File> inputFiles = new ArrayList<File>();
    @Parameter(names={"-fs"}, description="Add index nanopubs from input files as sub-indexes (instead of elements); has no effect if input file is plain-text list of URIs")
    private boolean useSubindexes = false;
    @Parameter(names={"-e"}, description="Add given URIs as elements (in addition to the ones from the input files)")
    private List<String> elements = new ArrayList<String>();
    @Parameter(names={"-s"}, description="Add given URIs as sub-indexes (in addition to the ones from the input files, if given)")
    private List<String> subindexes = new ArrayList<String>();
    @Parameter(names={"-x"}, description="Set given URI as superseded index")
    private String supersededIndex;
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile = new File("index.trig");
    @Parameter(names={"-u"}, description="Base URI for index nanopubs")
    private String baseUri = "http://purl.org/nanopub/temp/index/";
    @Parameter(names={"-t"}, description="Title of index")
    private String iTitle;
    @Parameter(names={"-d"}, description="Description of index")
    private String iDesc;
    @Parameter(names={"-c"}, description="Creator of index")
    private List<String> iCreators = new ArrayList<String>();
    @Parameter(names={"-l"}, description="License URI")
    private String licenseUri;
    @Parameter(names={"-a"}, description="'See also' resources")
    private List<String> seeAlso = new ArrayList<String>();
    @Parameter(names={"-p"}, description="Make plain (non-trusty) index nanopublications")
    private boolean plainNanopub;
    private SimpleIndexCreator indexCreator;
    private OutputStreamWriter writer;
    private RDFFormat outFormat;
    private int count;

    public static void main(String[] args) throws IOException {
        NanopubImpl.ensureLoaded();
        MakeIndex obj = new MakeIndex();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        if (obj.inputFiles.isEmpty() && obj.elements.isEmpty() && obj.subindexes.isEmpty() && obj.supersededIndex == null) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private MakeIndex() {
    }

    private void init() throws IOException {
        this.count = 0;
        this.outFormat = Rio.getParserFormatForFileName(this.outputFile.getName()).orElse(RDFFormat.TRIG);
        this.writer = this.outputFile.getName().endsWith(".gz") ? new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(this.outputFile)), Charset.forName("UTF-8")) : new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), Charset.forName("UTF-8"));
        this.indexCreator = new SimpleIndexCreator(!this.plainNanopub){

            @Override
            public void handleIncompleteIndex(NanopubIndex npi) {
                try {
                    MakeIndex.this.writer.write(NanopubUtils.writeToString(npi, MakeIndex.this.outFormat) + "\n\n");
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void handleCompleteIndex(NanopubIndex npi) {
                System.out.println("Index URI: " + npi.getUri());
                try {
                    MakeIndex.this.writer.write(NanopubUtils.writeToString(npi, MakeIndex.this.outFormat) + "\n\n");
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        this.indexCreator.setBaseUri(this.baseUri);
        if (this.iTitle != null) {
            this.indexCreator.setTitle(this.iTitle);
        }
        if (this.iDesc != null) {
            this.indexCreator.setDescription(this.iDesc);
        }
        for (String creator : this.iCreators) {
            this.indexCreator.addCreator(creator);
        }
        if (this.licenseUri != null) {
            this.indexCreator.setLicense(SimpleValueFactory.getInstance().createIRI(this.licenseUri));
        }
        for (String sa : this.seeAlso) {
            this.indexCreator.addSeeAlsoUri(SimpleValueFactory.getInstance().createIRI(sa));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws Exception {
        this.init();
        for (File f : this.inputFiles) {
            if (f.getName().endsWith(".txt")) {
                BufferedReader br = null;
                try {
                    String line;
                    br = new BufferedReader(new FileReader(f));
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        if (line.contains(" ")) {
                            line = line.substring(0, line.indexOf(" "));
                        }
                        this.indexCreator.addElement(SimpleValueFactory.getInstance().createIRI(line));
                    }
                    continue;
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                    continue;
                }
            }
            RDFFormat format = Rio.getParserFormatForFileName(f.getName()).orElse(RDFFormat.TRIG);
            MultiNanopubRdfHandler.process(format, f, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    if (MakeIndex.this.useSubindexes && IndexUtils.isIndex(np)) {
                        try {
                            MakeIndex.this.indexCreator.addSubIndex(IndexUtils.castToIndex(np));
                        }
                        catch (MalformedNanopubException ex) {
                            throw new RuntimeException(ex);
                        }
                    } else {
                        MakeIndex.this.indexCreator.addElement(np);
                    }
                    MakeIndex.this.count++;
                    if (MakeIndex.this.count % 100 == 0) {
                        System.err.print(MakeIndex.this.count + " nanopubs...\r");
                    }
                }
            });
        }
        for (String e : this.elements) {
            this.indexCreator.addElement(SimpleValueFactory.getInstance().createIRI(e));
        }
        for (String s : this.subindexes) {
            this.indexCreator.addSubIndex(SimpleValueFactory.getInstance().createIRI(s));
        }
        if (this.supersededIndex != null) {
            this.indexCreator.setSupersededIndex(SimpleValueFactory.getInstance().createIRI(this.supersededIndex));
        }
        this.indexCreator.finalizeNanopub();
        this.writer.close();
    }
}

