/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.index;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;
import org.nanopub.Nanopub;
import org.nanopub.NanopubCreator;
import org.nanopub.extra.index.IndexUtils;
import org.nanopub.extra.index.NanopubIndex;

public abstract class NanopubIndexCreator {
    private IRI completeIndexUri = null;
    private boolean finalized = false;
    private NanopubCreator npCreator;
    private int itemCount;
    private Map<String, Integer> elementNs;
    private int elementNsCount;
    private IRI previousIndexUri;
    private IRI supersededIndexUri;
    private boolean makeTrusty;
    private Random random = new Random();

    public NanopubIndexCreator(boolean makeTrusty) {
        this(null, makeTrusty);
    }

    public NanopubIndexCreator(IRI previousIndexUri, boolean makeTrusty) {
        this.previousIndexUri = previousIndexUri;
        this.makeTrusty = makeTrusty;
    }

    public void addElement(Nanopub np) {
        this.addElement(np.getUri());
    }

    public void addElement(IRI npUri) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        if (this.npCreator == null || this.itemCount >= 1000) {
            this.newNpCreator();
        }
        ++this.itemCount;
        this.npCreator.addAssertionStatement(this.npCreator.getNanopubUri(), NanopubIndex.INCLUDES_ELEMENT_URI, npUri);
        int nsSplit = TurtleUtil.findURISplitIndex(npUri.toString());
        if (nsSplit > 0) {
            String ns = npUri.toString().substring(0, nsSplit);
            if (!this.elementNs.containsKey(ns)) {
                this.elementNs.put(ns, 1);
            } else if (this.elementNs.get(ns) == 1) {
                ++this.elementNsCount;
                this.npCreator.addNamespace("ns" + this.elementNsCount, ns);
                this.elementNs.put(ns, 2);
            }
        }
    }

    public void addSubIndex(NanopubIndex npc) {
        this.addSubIndex(npc.getUri());
    }

    public void addSubIndex(IRI npcUri) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        if (this.npCreator == null || this.itemCount >= 1000) {
            this.newNpCreator();
        }
        ++this.itemCount;
        this.npCreator.addAssertionStatement(this.npCreator.getNanopubUri(), NanopubIndex.INCLUDES_SUBINDEX_URI, npcUri);
    }

    public void setSupersededIndex(NanopubIndex npc) {
        this.setSupersededIndex(npc.getUri());
    }

    public void setSupersededIndex(IRI npcUri) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        this.supersededIndexUri = npcUri;
    }

    public void finalizeNanopub() {
        if (this.finalized) {
            throw new RuntimeException("Already finalized");
        }
        if (this.supersededIndexUri != null) {
            this.npCreator.addPubinfoStatement(this.npCreator.getNanopubUri(), Nanopub.SUPERSEDES, this.supersededIndexUri);
        }
        this.enrichCompleteIndex(this.npCreator);
        try {
            if (this.npCreator == null) {
                this.newNpCreator();
            }
            Nanopub np = this.makeTrusty ? this.npCreator.finalizeTrustyNanopub(true) : this.npCreator.finalizeNanopub(true);
            this.completeIndexUri = np.getUri();
            this.handleCompleteIndex(IndexUtils.castToIndex(np));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.finalized = true;
    }

    public IRI getCompleteIndexUri() {
        return this.completeIndexUri;
    }

    public abstract String getBaseUri();

    public abstract void enrichIncompleteIndex(NanopubCreator var1);

    public abstract void enrichCompleteIndex(NanopubCreator var1);

    public abstract void handleIncompleteIndex(NanopubIndex var1);

    public abstract void handleCompleteIndex(NanopubIndex var1);

    private void newNpCreator() {
        if (this.npCreator != null) {
            this.npCreator.addPubinfoStatement(RDF.TYPE, NanopubIndex.INCOMPLETE_INDEX_URI);
            this.enrichIncompleteIndex(this.npCreator);
            try {
                Nanopub np = this.makeTrusty ? this.npCreator.finalizeTrustyNanopub(true) : this.npCreator.finalizeNanopub(true);
                this.previousIndexUri = np.getUri();
                this.handleIncompleteIndex(IndexUtils.castToIndex(np));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.elementNs = new HashMap<String, Integer>();
        this.elementNsCount = 0;
        this.itemCount = 0;
        String baseUri = this.getBaseUri() + Math.abs(this.random.nextLong()) + "/";
        this.npCreator = new NanopubCreator(baseUri);
        this.npCreator.addNamespace("", baseUri);
        this.npCreator.addNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.npCreator.addNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.npCreator.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
        this.npCreator.addNamespace("owl", "http://www.w3.org/2002/07/owl#");
        this.npCreator.addNamespace("dct", "http://purl.org/dc/terms/");
        this.npCreator.addNamespace("dce", "http://purl.org/dc/elements/1.1/");
        this.npCreator.addNamespace("pav", "http://purl.org/pav/");
        this.npCreator.addNamespace("np", "http://www.nanopub.org/nschema#");
        this.npCreator.addNamespace("npx", "http://purl.org/nanopub/x/");
        this.npCreator.addProvenanceStatement(RDF.TYPE, NanopubIndex.INDEX_ASSERTION_URI);
        this.npCreator.addPubinfoStatement(RDF.TYPE, NanopubIndex.NANOPUB_INDEX_URI);
        if (this.previousIndexUri != null) {
            this.npCreator.addAssertionStatement(this.npCreator.getNanopubUri(), NanopubIndex.APPENDS_INDEX_URI, this.previousIndexUri);
        }
    }
}

