/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.security;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriResource;
import net.trustyuri.TrustyUriUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;
import org.nanopub.NanopubWithNs;
import org.nanopub.extra.security.LegacySignatureUtils;
import org.nanopub.extra.security.SignatureUtils;

public class LegacySignNanopub {
    @Parameter(description="input-nanopubs", required=true)
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-k"}, description="Path and file name of key files")
    private String keyFilename = "~/.nanopub/id_dsa";
    @Parameter(names={"-v"}, description="Verbose")
    private boolean verbose = false;
    private KeyPair key;

    public static void main(String[] args) throws IOException {
        NanopubImpl.ensureLoaded();
        LegacySignNanopub obj = new LegacySignNanopub();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private LegacySignNanopub() {
    }

    private void run() throws Exception {
        this.key = LegacySignNanopub.loadKey(this.keyFilename);
        for (File inputFile : this.inputNanopubs) {
            File outFile = new File(inputFile.getParent(), "signed." + inputFile.getName());
            final OutputStream out = inputFile.getName().matches(".*\\.(gz|gzip)") ? new GZIPOutputStream(new FileOutputStream(outFile)) : new FileOutputStream(outFile);
            final RDFFormat format = new TrustyUriResource(inputFile).getFormat(RDFFormat.TRIG);
            MultiNanopubRdfHandler.process(format, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        np = LegacySignNanopub.writeAsSignedTrustyNanopub(np, format, LegacySignNanopub.this.key, out);
                        if (LegacySignNanopub.this.verbose) {
                            System.out.println("Nanopub URI: " + np.getUri());
                        }
                    }
                    catch (RDFHandlerException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                    catch (TrustyUriException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                    catch (InvalidKeyException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                    catch (SignatureException ex) {
                        ex.printStackTrace();
                        throw new RuntimeException(ex);
                    }
                }
            });
            out.close();
        }
    }

    public static Nanopub signAndTransform(Nanopub nanopub, KeyPair key) throws TrustyUriException, InvalidKeyException, SignatureException {
        return LegacySignNanopub.signAndTransform(nanopub, key, null);
    }

    public static Nanopub signAndTransform(Nanopub nanopub, KeyPair key, IRI signer) throws TrustyUriException, InvalidKeyException, SignatureException {
        if (TrustyUriUtils.getArtifactCode(nanopub.getUri().toString()) != null) {
            throw new SignatureException("Seems to have trusty URI before signing: " + nanopub.getUri());
        }
        if (SignatureUtils.seemsToHaveSignature(nanopub)) {
            throw new SignatureException("Seems to have signature before signing: " + nanopub.getUri());
        }
        if (nanopub instanceof NanopubWithNs) {
            ((NanopubWithNs)nanopub).removeUnusedPrefixes();
        }
        try {
            return LegacySignatureUtils.createSignedNanopub(nanopub, key, signer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static void signAndTransformMultiNanopub(RDFFormat format, File file, KeyPair key, OutputStream out) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        FileInputStream in = new FileInputStream(file);
        LegacySignNanopub.signAndTransformMultiNanopub(format, in, key, out);
    }

    public static void signAndTransformMultiNanopub(final RDFFormat format, InputStream in, final KeyPair key, final OutputStream out) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        MultiNanopubRdfHandler.process(format, in, new MultiNanopubRdfHandler.NanopubHandler(){

            @Override
            public void handleNanopub(Nanopub np) {
                try {
                    LegacySignNanopub.writeAsSignedTrustyNanopub(np, format, key, out);
                }
                catch (RDFHandlerException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
                catch (TrustyUriException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
                catch (InvalidKeyException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
                catch (SignatureException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
        });
        out.close();
    }

    public static Nanopub writeAsSignedTrustyNanopub(Nanopub np, RDFFormat format, KeyPair key, OutputStream out) throws RDFHandlerException, TrustyUriException, InvalidKeyException, SignatureException {
        np = LegacySignNanopub.signAndTransform(np, key);
        RDFWriter w = Rio.createWriter(format, new OutputStreamWriter(out, Charset.forName("UTF-8")));
        NanopubUtils.propagateToHandler(np, w);
        return np;
    }

    public static KeyPair loadKey(String keyFilename) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        keyFilename = keyFilename.replaceFirst("^~", System.getProperty("user.home"));
        KeyFactory kf = KeyFactory.getInstance("DSA");
        byte[] privateKeyBytes = DatatypeConverter.parseBase64Binary(IOUtils.toString((InputStream)new FileInputStream(keyFilename), "UTF-8"));
        PKCS8EncodedKeySpec privateSpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        PrivateKey privateKey = kf.generatePrivate(privateSpec);
        byte[] publicKeyBytes = DatatypeConverter.parseBase64Binary(IOUtils.toString((InputStream)new FileInputStream(keyFilename + ".pub"), "UTF-8"));
        X509EncodedKeySpec publicSpec = new X509EncodedKeySpec(publicKeyBytes);
        PublicKey publicKey = kf.generatePublic(publicSpec);
        return new KeyPair(publicKey, privateKey);
    }
}

