/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.security;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriUtils;
import net.trustyuri.rdf.RdfFileContent;
import net.trustyuri.rdf.RdfHasher;
import net.trustyuri.rdf.RdfPreprocessor;
import net.trustyuri.rdf.TransformRdf;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubRdfHandler;
import org.nanopub.NanopubUtils;
import org.nanopub.NanopubWithNs;
import org.nanopub.extra.security.CryptoElement;
import org.nanopub.extra.security.MalformedCryptoElementException;
import org.nanopub.extra.security.NanopubSignatureElement;
import org.nanopub.extra.security.SignatureAlgorithm;
import org.nanopub.trusty.TempUriReplacer;

public class SignatureUtils {
    private SignatureUtils() {
    }

    public static NanopubSignatureElement getSignatureElement(Nanopub nanopub) throws MalformedCryptoElementException {
        IRI signatureUri = SignatureUtils.getSignatureElementUri(nanopub);
        if (signatureUri == null) {
            return null;
        }
        NanopubSignatureElement se = new NanopubSignatureElement(nanopub.getUri(), signatureUri);
        for (Statement st : nanopub.getHead()) {
            se.addTargetStatement(st);
        }
        for (Statement st : nanopub.getAssertion()) {
            se.addTargetStatement(st);
        }
        for (Statement st : nanopub.getProvenance()) {
            se.addTargetStatement(st);
        }
        for (Statement st : nanopub.getPubinfo()) {
            if (!st.getSubject().equals(signatureUri)) {
                se.addTargetStatement(st);
                continue;
            }
            if (st.getPredicate().equals(NanopubSignatureElement.HAS_SIGNATURE)) {
                if (!(st.getObject() instanceof Literal)) {
                    throw new MalformedCryptoElementException("Literal expected as signature: " + st.getObject());
                }
                se.setSignatureLiteral((Literal)st.getObject());
                continue;
            }
            se.addTargetStatement(st);
            if (st.getPredicate().equals(CryptoElement.HAS_PUBLIC_KEY)) {
                if (!(st.getObject() instanceof Literal)) {
                    throw new MalformedCryptoElementException("Literal expected as public key: " + st.getObject());
                }
                se.setPublicKeyLiteral((Literal)st.getObject());
                continue;
            }
            if (st.getPredicate().equals(CryptoElement.HAS_ALGORITHM)) {
                if (!(st.getObject() instanceof Literal)) {
                    throw new MalformedCryptoElementException("Literal expected as algorithm: " + st.getObject());
                }
                se.setAlgorithm((Literal)st.getObject());
                continue;
            }
            if (!st.getPredicate().equals(NanopubSignatureElement.SIGNED_BY)) continue;
            if (!(st.getObject() instanceof IRI)) {
                throw new MalformedCryptoElementException("URI expected as signer: " + st.getObject());
            }
            se.addSigner((IRI)st.getObject());
        }
        if (se.getSignature() == null) {
            throw new MalformedCryptoElementException("Signature element without signature");
        }
        if (se.getAlgorithm() == null) {
            throw new MalformedCryptoElementException("Signature element without algorithm");
        }
        if (se.getPublicKeyString() == null) {
            throw new MalformedCryptoElementException("Signature element without public key");
        }
        return se;
    }

    public static boolean hasValidSignature(NanopubSignatureElement se) throws GeneralSecurityException {
        String artifactCode = TrustyUriUtils.getArtifactCode(se.getTargetNanopubUri().toString());
        List<Statement> statements = RdfPreprocessor.run(se.getTargetStatements(), artifactCode);
        Signature signature = Signature.getInstance("SHA256with" + se.getAlgorithm().name());
        X509EncodedKeySpec publicSpec = new X509EncodedKeySpec(DatatypeConverter.parseBase64Binary(se.getPublicKeyString()));
        PublicKey publicKey = KeyFactory.getInstance(se.getAlgorithm().name()).generatePublic(publicSpec);
        signature.initVerify(publicKey);
        signature.update(RdfHasher.getDigestString(statements).getBytes());
        return signature.verify(se.getSignature());
    }

    public static Nanopub createSignedNanopub(Nanopub preNanopub, SignatureAlgorithm algorithm, KeyPair key, IRI signer) throws GeneralSecurityException, RDFHandlerException, TrustyUriException, MalformedNanopubException {
        RdfFileContent r = new RdfFileContent(RDFFormat.TRIG);
        if (TempUriReplacer.hasTempUri(preNanopub)) {
            NanopubUtils.propagateToHandler(preNanopub, new TempUriReplacer(preNanopub, r, null));
            preNanopub = new NanopubImpl(r.getStatements(), r.getNamespaces());
        }
        Signature signature = Signature.getInstance("SHA256with" + algorithm.name());
        signature.initSign(key.getPrivate());
        List<Statement> preStatements = NanopubUtils.getStatements(preNanopub);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI signatureElUri = vf.createIRI(preNanopub.getUri() + "sig");
        IRI npUri = preNanopub.getUri();
        IRI piUri = preNanopub.getPubinfoUri();
        String publicKeyString = DatatypeConverter.printBase64Binary(key.getPublic().getEncoded()).replaceAll("\\s", "");
        Literal publicKeyLiteral = vf.createLiteral(publicKeyString);
        preStatements.add(vf.createStatement((Resource)signatureElUri, NanopubSignatureElement.HAS_SIGNATURE_TARGET, (Value)npUri, (Resource)piUri));
        preStatements.add(vf.createStatement((Resource)signatureElUri, CryptoElement.HAS_PUBLIC_KEY, (Value)publicKeyLiteral, (Resource)piUri));
        Literal algorithmLiteral = vf.createLiteral(algorithm.name());
        preStatements.add(vf.createStatement((Resource)signatureElUri, CryptoElement.HAS_ALGORITHM, (Value)algorithmLiteral, (Resource)piUri));
        if (signer != null) {
            preStatements.add(vf.createStatement((Resource)signatureElUri, NanopubSignatureElement.SIGNED_BY, (Value)signer, (Resource)piUri));
        }
        List<Statement> preprocessedStatements = RdfPreprocessor.run(preStatements, preNanopub.getUri());
        signature.update(RdfHasher.getDigestString(preprocessedStatements).getBytes());
        byte[] signatureBytes = signature.sign();
        Literal signatureLiteral = vf.createLiteral(DatatypeConverter.printBase64Binary(signatureBytes));
        ArrayList<Statement> sigStatementList = new ArrayList<Statement>();
        sigStatementList.add(vf.createStatement((Resource)signatureElUri, NanopubSignatureElement.HAS_SIGNATURE, (Value)signatureLiteral, (Resource)piUri));
        Statement preprocessedSigStatement = RdfPreprocessor.run(sigStatementList, preNanopub.getUri()).get(0);
        RdfFileContent signedContent = new RdfFileContent(RDFFormat.TRIG);
        signedContent.startRDF();
        if (preNanopub instanceof NanopubWithNs) {
            NanopubWithNs preNanopubNs = (NanopubWithNs)preNanopub;
            for (String prefix : preNanopubNs.getNsPrefixes()) {
                signedContent.handleNamespace(prefix, preNanopubNs.getNamespace(prefix));
            }
        }
        signedContent.handleNamespace("npx", "http://purl.org/nanopub/x/");
        for (Statement st : preprocessedStatements) {
            signedContent.handleStatement(st);
        }
        signedContent.handleStatement(preprocessedSigStatement);
        signedContent.endRDF();
        NanopubRdfHandler nanopubHandler = new NanopubRdfHandler();
        TransformRdf.transformPreprocessed(signedContent, preNanopub.getUri(), nanopubHandler);
        return nanopubHandler.getNanopub();
    }

    private static IRI getSignatureElementUri(Nanopub nanopub) throws MalformedCryptoElementException {
        IRI signatureElementUri = null;
        for (Statement st : nanopub.getPubinfo()) {
            if (!st.getPredicate().equals(NanopubSignatureElement.HAS_SIGNATURE_TARGET) || !st.getObject().equals(nanopub.getUri())) continue;
            if (!(st.getSubject() instanceof IRI)) {
                throw new MalformedCryptoElementException("Signature element must be identified by URI");
            }
            if (signatureElementUri != null) {
                throw new MalformedCryptoElementException("Multiple signature elements found");
            }
            signatureElementUri = (IRI)st.getSubject();
        }
        return signatureElementUri;
    }

    public static boolean seemsToHaveSignature(Nanopub nanopub) {
        for (Statement st : nanopub.getPubinfo()) {
            if (st.getPredicate().equals(NanopubSignatureElement.HAS_SIGNATURE_ELEMENT)) {
                return true;
            }
            if (st.getPredicate().equals(NanopubSignatureElement.HAS_SIGNATURE_TARGET)) {
                return true;
            }
            if (st.getPredicate().equals(NanopubSignatureElement.HAS_SIGNATURE)) {
                return true;
            }
            if (!st.getPredicate().equals(CryptoElement.HAS_PUBLIC_KEY)) continue;
            return true;
        }
        return false;
    }
}

