/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import net.trustyuri.TrustyUriUtils;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.nanopub.MalformedNanopubException;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.extra.index.IndexUtils;
import org.nanopub.extra.index.NanopubIndex;
import org.nanopub.extra.server.GetNanopub;
import org.nanopub.extra.server.ServerInfo;
import org.nanopub.extra.server.ServerIterator;

public class NanopubStatus {
    @Parameter(description="nanopub-uri-or-artifact-code", required=true)
    private List<String> nanopubIds;
    @Parameter(names={"-v"}, description="Verbose")
    private boolean verbose = false;
    @Parameter(names={"-r"}, description="Recursive (check entire content of index)")
    private boolean recursive = false;
    @Parameter(names={"-a"}, description="Check all servers (do not stop after the first successful one)")
    private boolean checkAllServers = false;
    private int contentNpCount;
    private int indexNpCount;
    private int minCount = -1;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        NanopubStatus obj = new NanopubStatus();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        if (obj.nanopubIds.size() != 1) {
            System.err.println("ERROR: Exactly one main argument needed");
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static String getArtifactCode(String uriOrArtifactCode) {
        if (uriOrArtifactCode.indexOf(":") > 0) {
            IRI uri = SimpleValueFactory.getInstance().createIRI(uriOrArtifactCode);
            if (!TrustyUriUtils.isPotentialTrustyUri(uri)) {
                throw new IllegalArgumentException("Not a well-formed trusty URI");
            }
            return TrustyUriUtils.getArtifactCode(uri.toString());
        }
        if (!TrustyUriUtils.isPotentialArtifactCode(uriOrArtifactCode)) {
            throw new IllegalArgumentException("Not a well-formed artifact code");
        }
        return uriOrArtifactCode;
    }

    private void run() throws IOException, RDFHandlerException {
        this.checkNanopub(this.nanopubIds.get(0), this.recursive);
        if (this.recursive) {
            System.out.print(this.indexNpCount + " index nanopub" + (this.indexNpCount != 1 ? "s" : "") + "; ");
            System.out.println(this.contentNpCount + " content nanopub" + (this.contentNpCount != 1 ? "s" : ""));
            if (this.checkAllServers) {
                System.out.println("Each found on at least " + this.minCount + " nanopub server" + (this.minCount != 1 ? "s" : "") + ".");
            }
        }
    }

    private void checkNanopub(String nanopubId, boolean checkIndexContent) {
        String ac = NanopubStatus.getArtifactCode(nanopubId);
        if (!ac.startsWith("RA")) {
            System.err.println("ERROR. Not a trusty URI of type RA: " + nanopubId);
            System.exit(1);
        }
        int count = 0;
        ServerIterator serverIterator = new ServerIterator();
        Nanopub nanopub = null;
        while (serverIterator.hasNext()) {
            ServerInfo serverInfo = serverIterator.next();
            String serverUrl = serverInfo.getPublicUrl();
            try {
                Nanopub np = GetNanopub.get(ac, serverUrl);
                if (np == null) continue;
                if (checkIndexContent && !IndexUtils.isIndex(np)) {
                    System.err.println("ERROR. Not an index: " + nanopubId);
                    System.exit(1);
                }
                if (nanopub == null) {
                    nanopub = np;
                }
                if (!this.recursive || this.verbose) {
                    System.out.println("URL: " + serverUrl + ac);
                }
                if (!this.checkAllServers) break;
                ++count;
            }
            catch (FileNotFoundException ex) {
                if (!this.verbose || this.recursive) continue;
                System.out.println("NOT FOUND ON: " + serverUrl);
            }
            catch (IOException ex) {
                if (!this.verbose || this.recursive) continue;
                System.out.println("CONNECTION ERROR: " + serverUrl);
            }
            catch (RDF4JException ex) {
                if (!this.verbose || this.recursive) continue;
                System.out.println("VALIDATION ERROR: " + serverUrl);
            }
            catch (MalformedNanopubException ex) {
                if (!this.verbose || this.recursive) continue;
                System.out.println("VALIDATION ERROR: " + serverUrl);
            }
        }
        if (this.checkAllServers) {
            String text = "Found on " + count + " nanopub server" + (count != 1 ? "s" : "");
            if (!this.recursive) {
                System.out.println(text + ".");
            } else if (this.verbose) {
                System.out.println(text + ": " + ac);
            }
            if (this.minCount < 0 || this.minCount > count) {
                this.minCount = count;
            }
        }
        if (nanopub != null) {
            if (checkIndexContent) {
                ++this.indexNpCount;
                NanopubIndex npi = null;
                try {
                    npi = IndexUtils.castToIndex(nanopub);
                }
                catch (MalformedNanopubException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                for (IRI elementUri : npi.getElements()) {
                    this.checkNanopub(elementUri.toString(), false);
                }
                for (IRI subIndexUri : npi.getSubIndexes()) {
                    this.checkNanopub(subIndexUri.toString(), true);
                }
                if (npi.getAppendedIndex() != null) {
                    this.checkNanopub(npi.getAppendedIndex().toString(), true);
                }
            } else {
                ++this.contentNpCount;
            }
        }
        if ((this.indexNpCount + this.contentNpCount) % 100 == 0) {
            System.err.print(this.indexNpCount + this.contentNpCount + " nanopubs...\r");
        }
    }
}

