/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.extra.server;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.nanopub.extra.server.NanopubServerUtils;
import org.nanopub.extra.server.NanopubSurfacePattern;

public class ServerInfo
implements Serializable {
    private static final long serialVersionUID = 5893051633759794791L;
    protected String publicUrl;
    protected String admin;
    protected String protocolVersion = "0.0";
    protected String description;
    protected boolean postNanopubsEnabled;
    protected boolean postPeersEnabled;
    protected int pageSize = -1;
    protected long nextNanopubNo = -1L;
    protected long journalId = -1L;
    protected Integer maxNanopubTriples;
    protected Long maxNanopubBytes;
    protected Long maxNanopubs;
    protected String uriPattern;
    protected String hashPattern;
    private transient NanopubSurfacePattern pattern;

    public static ServerInfo load(String serverUrl) throws ServerInfoException {
        return ServerInfo.load(serverUrl, ServerInfo.class);
    }

    protected static ServerInfo load(String serverUrl, Class<? extends ServerInfo> serverInfoClass) throws ServerInfoException {
        HttpGet get = new HttpGet(serverUrl);
        get.setHeader("Accept", "application/json");
        ServerInfo si = null;
        InputStream in = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(100).setSocketTimeout(1000).build();
            CloseableHttpClient c = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            in = c.execute(get).getEntity().getContent();
            si = new Gson().fromJson((Reader)new InputStreamReader(in, Charset.forName("UTF-8")), serverInfoClass);
        }
        catch (Exception ex) {
            throw new ServerInfoException(serverUrl);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    throw new ServerInfoException("Could not close stream: " + ex.getMessage());
                }
            }
        }
        if (si == null || si.getPublicUrl() == null) {
            throw new ServerInfoException("Error accessing server");
        }
        if (!si.getPublicUrl().equals(serverUrl)) {
            throw new ServerInfoException("Server URL does not match its declared public URL");
        }
        if (si.getProtocolVersionValue() < NanopubServerUtils.requiredProtocolVersionValue) {
            throw new ServerInfoException("Protocol version of server is too old: " + si.getProtocolVersion());
        }
        return si;
    }

    public boolean isPostNanopubsEnabled() {
        return this.postNanopubsEnabled;
    }

    public boolean isPostPeersEnabled() {
        return this.postPeersEnabled;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public String getAdmin() {
        return this.admin;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getNextNanopubNo() {
        return this.nextNanopubNo;
    }

    public long getJournalId() {
        return this.journalId;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getProtocolVersionValue() {
        return NanopubServerUtils.getVersionValue(this.protocolVersion);
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getMaxNanopubTriples() {
        return this.maxNanopubTriples;
    }

    public Long getMaxNanopubBytes() {
        return this.maxNanopubBytes;
    }

    public Long getMaxNanopubs() {
        return this.maxNanopubs;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public String getHashPattern() {
        return this.hashPattern;
    }

    public NanopubSurfacePattern getNanopubSurfacePattern() {
        if (this.pattern == null) {
            this.pattern = new NanopubSurfacePattern(this);
        }
        return this.pattern;
    }

    public String asJson() {
        return new Gson().toJson(this);
    }

    public static class ServerInfoException
    extends Exception {
        private static final long serialVersionUID = 3903673740899289181L;

        public ServerInfoException(String serverUrl) {
            super(serverUrl);
        }
    }
}

