/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;

public class Count {
    @Parameter(description="input-nanopubs")
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-r"}, description="Append line to this table file")
    private File tableFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    private RDFFormat rdfInFormat;
    private int npCount;
    private int headCount;
    private int assertionCount;
    private int provCount;
    private int pubinfoCount;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Count obj = new Count();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static Count getInstance(String args) throws ParameterException {
        NanopubImpl.ensureLoaded();
        if (args == null) {
            args = "";
        }
        Count obj = new Count();
        JCommander jc = new JCommander(obj);
        jc.parse(args.trim().split(" "));
        return obj;
    }

    public void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        if (this.inputNanopubs == null || this.inputNanopubs.isEmpty()) {
            throw new ParameterException("No input files given");
        }
        for (File inputFile : this.inputNanopubs) {
            this.npCount = 0;
            this.headCount = 0;
            this.assertionCount = 0;
            this.pubinfoCount = 0;
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    Count.this.countTriples(np);
                }
            });
            if (this.tableFile == null) {
                System.out.println("Nanopublications: " + this.npCount);
                System.out.println("Head triples: " + this.headCount + " (average: " + (float)this.headCount / (float)this.npCount + ")");
                System.out.println("Assertion triples: " + this.assertionCount + " (average: " + (float)this.assertionCount / (float)this.npCount + ")");
                System.out.println("Provenance triples: " + this.provCount + " (average: " + (float)this.provCount / (float)this.npCount + ")");
                System.out.println("Pubinfo triples: " + this.pubinfoCount + " (average: " + (float)this.pubinfoCount / (float)this.npCount + ")");
                int t = this.headCount + this.assertionCount + this.provCount + this.pubinfoCount;
                System.out.println("Total triples: " + t + " (average: " + (float)t / (float)this.npCount + ")");
                continue;
            }
            PrintStream st = new PrintStream(new FileOutputStream(this.tableFile, true));
            st.println(inputFile.getName() + "," + this.npCount + "," + this.headCount + "," + this.assertionCount + "," + this.provCount + "," + this.pubinfoCount);
            st.close();
        }
    }

    public void countTriples(Nanopub np) {
        ++this.npCount;
        this.headCount += np.getHead().size();
        this.assertionCount += np.getAssertion().size();
        this.provCount += np.getProvenance().size();
        this.pubinfoCount += np.getPubinfo().size();
    }
}

