/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;
import org.nanopub.op.fingerprint.FingerprintHandler;

public class Decontextualize {
    public static final IRI graphPlaceholer = SimpleValueFactory.getInstance().createIRI("http://purl.org/nanopub/placeholders/graph");
    @Parameter(description="input-nanopubs", required=true)
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    private RDFFormat rdfInFormat;
    private OutputStream outputStream = System.out;
    private RDFWriter writer;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Decontextualize obj = new Decontextualize();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            if (this.outputFile != null) {
                this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
            }
            this.writer = Rio.createWriter(RDFFormat.NQUADS, new OutputStreamWriter(this.outputStream, Charset.forName("UTF-8")));
            this.writer.startRDF();
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Decontextualize.this.process(np);
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            this.writer.endRDF();
            this.outputStream.flush();
            if (this.outputStream == System.out) continue;
            this.outputStream.close();
        }
    }

    private void process(Nanopub np) throws RDFHandlerException {
        for (Statement st : this.getNormalizedStatements(np)) {
            this.writer.handleStatement(st);
        }
    }

    private List<Statement> getNormalizedStatements(Nanopub np) {
        List<Statement> statements = NanopubUtils.getStatements(np);
        ArrayList<Statement> n = new ArrayList<Statement>();
        for (Statement st : statements) {
            boolean isInHead = st.getContext().equals(np.getHeadUri());
            if (isInHead) continue;
            boolean isInProvenance = st.getContext().equals(np.getProvenanceUri());
            boolean isInPubinfo = st.getContext().equals(np.getPubinfoUri());
            IRI toBeReplacedUri = null;
            IRI replacementUri = null;
            if (isInProvenance) {
                toBeReplacedUri = np.getAssertionUri();
                replacementUri = FingerprintHandler.assertionUriPlaceholder;
            } else if (isInPubinfo) {
                toBeReplacedUri = np.getUri();
                replacementUri = FingerprintHandler.nanopubUriPlaceholder;
            }
            Resource subj = st.getSubject();
            IRI pred = st.getPredicate();
            Value obj = st.getObject();
            n.add(SimpleValueFactory.getInstance().createStatement((Resource)this.transform(subj, toBeReplacedUri, replacementUri), (IRI)this.transform(pred, toBeReplacedUri, replacementUri), this.transform(obj, toBeReplacedUri, replacementUri), (Resource)graphPlaceholer));
        }
        return n;
    }

    private Value transform(Value v, IRI toBeReplacedUri, IRI replacementUri) {
        if (toBeReplacedUri == null) {
            return v;
        }
        if (v.equals(toBeReplacedUri)) {
            return replacementUri;
        }
        return v;
    }
}

