/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;
import org.nanopub.extra.index.IndexUtils;
import org.nanopub.extra.index.NanopubIndex;
import org.nanopub.extra.index.NanopubIndexCreator;
import org.nanopub.extra.index.SimpleIndexCreator;

public class IndexReuse {
    @Parameter(description="input-nanopub-cache", required=true)
    private List<File> inputNanopubCache = new ArrayList<File>();
    @Parameter(names={"-x"}, description="Index nanopubs to be reused (need to be sorted; no subindex supported)")
    private File reuseIndexFile;
    @Parameter(names={"-o"}, description="Output file of new index nanopublications")
    private File outputFile;
    @Parameter(names={"-a"}, description="Output file of all index nanopublications")
    private File allOutputFile;
    @Parameter(names={"-r"}, description="Append line to this table file")
    private File tableFile;
    @Parameter(names={"--reuse-format"}, description="Format of the nanopubs to be reused: trig, nq, trix, trig.gz, ...")
    private String reuseFormat;
    @Parameter(names={"--out-format"}, description="Format of the output nanopubs: trig, nq, trix, trig.gz, ...")
    private String outFormat;
    @Parameter(names={"-s"}, description="Add npx:supersedes backlinks for changed nanopublications")
    private boolean addSupersedesBacklinks = false;
    @Parameter(names={"-U"}, description="Base URI for index nanopubs")
    private String baseUri = "http://purl.org/np/";
    @Parameter(names={"-T"}, description="Title of index")
    private String iTitle;
    @Parameter(names={"-D"}, description="Description of index")
    private String iDesc;
    @Parameter(names={"-C"}, description="Creator of index")
    private List<String> iCreators = new ArrayList<String>();
    @Parameter(names={"-A"}, description="'See also' resources")
    private List<String> seeAlso = new ArrayList<String>();
    private IRI previousIndexUri = null;
    private NanopubIndex lastIndexNp;
    private RDFFormat rdfReuseFormat;
    private RDFFormat rdfOutFormat;
    private PrintStream outputStream = System.out;
    private PrintStream allOutputStream;
    private List<String> contentNanopubList = new ArrayList<String>();
    private Map<String, Boolean> contentNanopubMap = new HashMap<String, Boolean>();
    private int reuseCount;
    private boolean reuseStopped = false;
    private NanopubIndexCreator indexCreator = null;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        IndexReuse obj = new IndexReuse();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        this.reuseCount = 0;
        for (File inputFile : this.inputNanopubCache) {
            Object line;
            if (this.outputFile == null) {
                if (this.outFormat == null) {
                    this.outFormat = "trig";
                }
                this.rdfOutFormat = Rio.getParserFormatForFileName("file." + this.outFormat).orElse(null);
            } else {
                this.rdfOutFormat = Rio.getParserFormatForFileName(this.outputFile.getName()).orElse(null);
                this.outputStream = this.outputFile.getName().endsWith(".gz") ? new PrintStream(new GZIPOutputStream(new FileOutputStream(this.outputFile))) : new PrintStream(new FileOutputStream(this.outputFile));
            }
            if (this.allOutputFile != null) {
                this.allOutputStream = this.allOutputFile.getName().endsWith(".gz") ? new PrintStream(new GZIPOutputStream(new FileOutputStream(this.allOutputFile))) : new PrintStream(new FileOutputStream(this.allOutputFile));
            }
            try (BufferedReader br = null;){
                br = inputFile.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(inputFile)))) : new BufferedReader(new FileReader(inputFile));
                while ((line = br.readLine()) != null) {
                    if (((String)(line = ((String)line).trim())).isEmpty()) continue;
                    String[] columns = ((String)line).split(" ");
                    String uri = columns[0];
                    this.contentNanopubList.add(uri);
                    this.contentNanopubMap.put(uri, true);
                }
            }
            if (this.reuseIndexFile != null) {
                this.rdfReuseFormat = this.reuseFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.reuseFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(this.reuseIndexFile.toString()).orElse(null);
                MultiNanopubRdfHandler.process(this.rdfReuseFormat, this.reuseIndexFile, new MultiNanopubRdfHandler.NanopubHandler(){

                    @Override
                    public void handleNanopub(Nanopub np) {
                        try {
                            IndexReuse.this.processIndexNanopub(np);
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        catch (RDFHandlerException ex) {
                            throw new RuntimeException(ex);
                        }
                        catch (MalformedNanopubException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                });
            }
            if (this.lastIndexNp != null && this.lastIndexNp.isIncomplete()) {
                throw new RuntimeException("Last index nanopub in file is not a complete index");
            }
            this.indexCreator = new IndexCreator(this.previousIndexUri);
            if (this.lastIndexNp != null && this.addSupersedesBacklinks) {
                this.indexCreator.setSupersededIndex(this.lastIndexNp);
            }
            line = this.contentNanopubList.iterator();
            while (line.hasNext()) {
                String npUri = (String)line.next();
                if (!this.contentNanopubMap.containsKey(npUri)) continue;
                this.indexCreator.addElement(SimpleValueFactory.getInstance().createIRI(npUri));
            }
            this.indexCreator.finalizeNanopub();
            this.outputStream.flush();
            if (this.outputStream != System.out) {
                this.outputStream.close();
            }
            if (this.allOutputStream != null) {
                this.allOutputStream.flush();
                this.allOutputStream.close();
            }
            System.err.println("Index reuse count: " + this.reuseCount);
            if (this.tableFile == null) continue;
            PrintStream st = new PrintStream(new FileOutputStream(this.tableFile, true));
            st.println(inputFile.getName() + "," + this.reuseCount);
            st.close();
        }
    }

    private void processIndexNanopub(Nanopub np) throws IOException, RDFHandlerException, MalformedNanopubException {
        NanopubIndex npi;
        this.lastIndexNp = npi = IndexUtils.castToIndex(np);
        if (this.reuseStopped) {
            return;
        }
        if (!npi.getSubIndexes().isEmpty()) {
            throw new RuntimeException("Subindexes are not supported");
        }
        if (this.previousIndexUri == null && npi.getAppendedIndex() != null) {
            throw new RuntimeException("Starting index nanopub expected first in file");
        }
        if (this.previousIndexUri != null && npi.getAppendedIndex() == null) {
            throw new RuntimeException("Non-appending index nanopub found after first position");
        }
        boolean canBeReused = true;
        for (IRI c : npi.getElements()) {
            if (this.contentNanopubMap.containsKey(c.stringValue())) continue;
            canBeReused = false;
            break;
        }
        if (canBeReused && !npi.getElements().isEmpty()) {
            ++this.reuseCount;
            this.outputOld(npi);
            for (IRI c : npi.getElements()) {
                this.contentNanopubMap.remove(c.stringValue());
            }
            this.previousIndexUri = npi.getUri();
        } else {
            this.reuseStopped = true;
        }
    }

    private void output(NanopubIndex npi) {
        try {
            this.outputStream.print(NanopubUtils.writeToString(npi, this.rdfOutFormat) + "\n\n");
            if (this.allOutputStream != null) {
                this.allOutputStream.print(NanopubUtils.writeToString(npi, this.rdfOutFormat) + "\n\n");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void outputOld(NanopubIndex npi) {
        try {
            if (this.allOutputStream != null) {
                this.allOutputStream.print(NanopubUtils.writeToString(npi, this.rdfOutFormat) + "\n\n");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private class IndexCreator
    extends SimpleIndexCreator {
        public IndexCreator(IRI previousIndexUri) {
            super(previousIndexUri, true);
            this.setBaseUri(IndexReuse.this.baseUri);
            if (IndexReuse.this.iTitle != null) {
                this.setTitle(IndexReuse.this.iTitle);
            }
            if (IndexReuse.this.iDesc != null) {
                this.setDescription(IndexReuse.this.iDesc);
            }
            for (String creator : IndexReuse.this.iCreators) {
                this.addCreator(creator);
            }
            for (String sa : IndexReuse.this.seeAlso) {
                this.addSeeAlsoUri(SimpleValueFactory.getInstance().createIRI(sa));
            }
        }

        @Override
        public void handleIncompleteIndex(NanopubIndex npi) {
            IndexReuse.this.output(npi);
        }

        @Override
        public void handleCompleteIndex(NanopubIndex npi) {
            System.out.println("Index URI: " + npi.getUri());
            IndexReuse.this.output(npi);
        }
    }
}

