/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.turtle.TurtleParserFactory;
import org.eclipse.rdf4j.rio.turtle.TurtleWriterFactory;
import org.nanopub.NanopubImpl;
import org.nanopub.op.Aggregate;
import org.nanopub.op.Build;
import org.nanopub.op.Count;
import org.nanopub.op.Create;
import org.nanopub.op.Decontextualize;
import org.nanopub.op.ExportJson;
import org.nanopub.op.Extract;
import org.nanopub.op.Filter;
import org.nanopub.op.Fingerprint;
import org.nanopub.op.Gml;
import org.nanopub.op.Import;
import org.nanopub.op.IndexReuse;
import org.nanopub.op.Namespaces;
import org.nanopub.op.Reuse;
import org.nanopub.op.Topic;
import org.nanopub.op.Union;

public class Run {
    private static List<Class<?>> runnableClasses = new ArrayList();
    private static Map<String, Class<?>> runnableClassesByName = new HashMap();
    private static Map<String, Class<?>> runnableClassesByShortcut = new HashMap();
    private static Map<Class<?>, String> runnableClassNames = new HashMap();
    private static Map<Class<?>, String> runnableClassShortcuts = new HashMap();

    private Run() {
    }

    public static void main(String[] args) throws IOException, RDF4JException {
        NanopubImpl.ensureLoaded();
        RDFParserRegistry.getInstance().add(new TurtleParserFactory());
        RDFWriterRegistry.getInstance().add(new TurtleWriterFactory());
        Run.run(args);
    }

    private static void addRunnableClass(Class<?> c, String shortcut) {
        runnableClasses.add(c);
        runnableClassesByName.put(c.getSimpleName(), c);
        runnableClassNames.put(c, c.getSimpleName());
        if (shortcut != null) {
            runnableClassesByShortcut.put(shortcut, c);
            runnableClassShortcuts.put(c, shortcut);
        }
    }

    public static void run(String[] command) throws IOException, RDF4JException {
        if (command.length == 0) {
            System.err.println("ERROR: missing command");
            System.err.println("Run with 'help' argument to show all available commands.");
            System.exit(1);
        }
        String cmd = command[0];
        String[] cmdArgs = Arrays.copyOfRange(command, 1, command.length);
        Class<?> runClass = runnableClassesByName.get(cmd);
        if (runClass == null) {
            runClass = runnableClassesByShortcut.get(cmd);
        }
        if (runClass != null) {
            try {
                runClass.getMethod("main", String[].class).invoke(runClass, new Object[]{cmdArgs});
            }
            catch (Exception ex) {
                System.err.println("Internal error: " + ex.getMessage());
                ex.printStackTrace(System.err);
                System.exit(1);
            }
        } else if (cmd.equals("help")) {
            System.err.println("Available commands:");
            for (Class<?> c : runnableClasses) {
                String s = runnableClassShortcuts.get(c);
                String n = runnableClassNames.get(c);
                if (s == null) {
                    System.err.println("- " + n);
                    continue;
                }
                System.err.println("- " + s + " / " + n);
            }
            System.exit(0);
        } else {
            System.err.println("ERROR. Unrecognized command: " + cmd);
            System.err.println("Run 'npop help' to show all available commands.");
            System.exit(1);
        }
    }

    static {
        Run.addRunnableClass(Filter.class, "filter");
        Run.addRunnableClass(Extract.class, "extract");
        Run.addRunnableClass(Gml.class, "gml");
        Run.addRunnableClass(Fingerprint.class, "fingerprint");
        Run.addRunnableClass(Topic.class, "topic");
        Run.addRunnableClass(Reuse.class, "reuse");
        Run.addRunnableClass(Count.class, "count");
        Run.addRunnableClass(Decontextualize.class, "decontext");
        Run.addRunnableClass(Union.class, "union");
        Run.addRunnableClass(IndexReuse.class, "ireuse");
        Run.addRunnableClass(ExportJson.class, "exportjson");
        Run.addRunnableClass(Namespaces.class, "namespaces");
        Run.addRunnableClass(Aggregate.class, "aggregate");
        Run.addRunnableClass(Import.class, "import");
        Run.addRunnableClass(Create.class, "create");
        Run.addRunnableClass(Build.class, "build");
    }
}

