/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubUtils;

public class Union {
    @Parameter(description="input-nanopubs", required=true)
    private List<File> inputNanopubs = new ArrayList<File>();
    @Parameter(names={"-o"}, description="Output file")
    private File outputFile;
    @Parameter(names={"--in-format"}, description="Format of the input nanopubs: trig, nq, trix, trig.gz, ...")
    private String inFormat;
    @Parameter(names={"--out-format"}, description="Format of the output nanopubs: trig, nq, trix, trig.gz, ...")
    private String outFormat;
    private RDFFormat rdfInFormat;
    private RDFFormat rdfOutFormat;
    private OutputStream outputStream = System.out;
    private Map<String, Boolean> seen = new HashMap<String, Boolean>();
    private int duplicates = 0;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        Union obj = new Union();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        if (this.outputFile == null) {
            if (this.outFormat == null) {
                this.outFormat = "trig";
            }
            this.rdfOutFormat = Rio.getParserFormatForFileName("file." + this.outFormat).orElse(null);
        } else {
            this.rdfOutFormat = Rio.getParserFormatForFileName(this.outputFile.getName()).orElse(null);
            this.outputStream = this.outputFile.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.outputFile)) : new FileOutputStream(this.outputFile);
        }
        for (File inputFile : this.inputNanopubs) {
            this.rdfInFormat = this.inFormat != null ? (RDFFormat)Rio.getParserFormatForFileName("file." + this.inFormat).orElse(null) : (RDFFormat)Rio.getParserFormatForFileName(inputFile.toString()).orElse(null);
            MultiNanopubRdfHandler.process(this.rdfInFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        Union.this.process(np);
                    }
                    catch (RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
        System.err.println(this.duplicates + " duplicates eliminated");
        this.outputStream.flush();
        if (this.outputStream != System.out) {
            this.outputStream.close();
        }
    }

    private void process(Nanopub np) throws RDFHandlerException {
        String u = np.getUri().stringValue();
        if (this.seen.containsKey(u)) {
            ++this.duplicates;
        } else {
            NanopubUtils.writeToStream(np, this.outputStream, this.rdfOutFormat);
            this.seen.put(u, true);
        }
    }
}

