/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op.fingerprint;

import java.util.ArrayList;
import java.util.List;
import net.trustyuri.TrustyUriUtils;
import net.trustyuri.rdf.RdfHasher;
import net.trustyuri.rdf.RdfPreprocessor;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.nanopub.Nanopub;
import org.nanopub.NanopubUtils;
import org.nanopub.op.fingerprint.FingerprintHandler;

public class DisgenetFingerprints
implements FingerprintHandler {
    private static ValueFactory vf = SimpleValueFactory.getInstance();
    public static final IRI disgenetGdaPlaceholder = vf.createIRI("http://purl.org/nanopub/placeholders/disgenet-gda");
    private static final IRI pav1importedOn = vf.createIRI("http://purl.org/pav/importedOn");
    private static final IRI pav2importedOn = vf.createIRI("http://purl.org/pav/2.0/importedOn");

    @Override
    public String getFingerprint(Nanopub np) {
        String artifactCode = TrustyUriUtils.getArtifactCode(np.getUri().toString());
        if (artifactCode == null) {
            throw new RuntimeException("Not a trusty URI: " + np.getUri());
        }
        List<Statement> statements = this.getNormalizedStatements(np);
        statements = RdfPreprocessor.run(statements, artifactCode);
        String fingerprint = RdfHasher.makeArtifactCode(statements);
        return fingerprint.substring(2);
    }

    private List<Statement> getNormalizedStatements(Nanopub np) {
        List<Statement> statements = NanopubUtils.getStatements(np);
        ArrayList<Statement> n = new ArrayList<Statement>();
        for (Statement st : statements) {
            boolean isInAssertion = st.getContext().equals(np.getAssertionUri());
            boolean isInProvenance = st.getContext().equals(np.getProvenanceUri());
            if (!isInProvenance && !isInAssertion) continue;
            IRI graphURI = isInAssertion ? assertionUriPlaceholder : provUriPlaceholder;
            Resource subj = st.getSubject();
            IRI pred = st.getPredicate();
            Value obj = st.getObject();
            if (isInAssertion) {
                String subjS = subj.stringValue();
                if (subjS.startsWith("http://rdf.disgenet.org/resource/gda/DGN") || subjS.startsWith("http://rdf.disgenet.org/gene-disease-association.ttl#DGN")) {
                    subj = disgenetGdaPlaceholder;
                }
            } else if (isInProvenance) {
                if (pred.equals(pav1importedOn) || pred.equals(pav2importedOn)) {
                    pred = pav2importedOn;
                    obj = timestampPlaceholder;
                }
                if (subj.equals(np.getAssertionUri())) {
                    subj = assertionUriPlaceholder;
                }
            }
            n.add(vf.createStatement((Resource)this.transform(subj), (IRI)this.transform(pred), this.transform(obj), (Resource)graphURI));
        }
        return n;
    }

    private Value transform(Value v) {
        if (v instanceof IRI) {
            String s = ((IRI)v).stringValue();
            if (s.matches("http://rdf.disgenet.org/v.*/void.*")) {
                if (s.matches("http://rdf.disgenet.org/v.*/void.*-20[0-9]*")) {
                    String r = s.replaceFirst("^http://rdf.disgenet.org/v.*/void.*(/|#)(.*)-20[0-9]*$", "http://rdf.disgenet.org/vx.x.x/void/$2");
                    return vf.createIRI(r);
                }
                String r = s.replaceFirst("^http://rdf.disgenet.org/v.*/void.*(/|#)", "http://rdf.disgenet.org/vx.x.x/void/");
                return vf.createIRI(r);
            }
            if (s.startsWith("http://purl.obolibrary.org/obo/eco.owl#")) {
                return vf.createIRI(s.replace("http://purl.obolibrary.org/obo/eco.owl#", "http://purl.obolibrary.org/obo/"));
            }
        }
        return v;
    }
}

