/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op.fingerprint;

import java.util.ArrayList;
import java.util.List;
import net.trustyuri.TrustyUriUtils;
import net.trustyuri.rdf.RdfHasher;
import net.trustyuri.rdf.RdfPreprocessor;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.nanopub.Nanopub;
import org.nanopub.NanopubUtils;
import org.nanopub.SimpleTimestampPattern;
import org.nanopub.op.fingerprint.FingerprintHandler;

public class WikipathwaysFingerprints
implements FingerprintHandler {
    @Override
    public String getFingerprint(Nanopub np) {
        String artifactCode = TrustyUriUtils.getArtifactCode(np.getUri().toString());
        if (artifactCode == null) {
            throw new RuntimeException("Not a trusty URI: " + np.getUri());
        }
        List<Statement> statements = this.getNormalizedStatements(np);
        statements = RdfPreprocessor.run(statements, artifactCode);
        String fingerprint = RdfHasher.makeArtifactCode(statements);
        return fingerprint.substring(2);
    }

    private List<Statement> getNormalizedStatements(Nanopub np) {
        List<Statement> statements = NanopubUtils.getStatements(np);
        ArrayList<Statement> n = new ArrayList<Statement>();
        for (Statement st : statements) {
            boolean isInAssertion = st.getContext().equals(np.getAssertionUri());
            boolean isInProvenance = st.getContext().equals(np.getProvenanceUri());
            boolean isInPubinfo = st.getContext().equals(np.getPubinfoUri());
            if (!isInProvenance && !isInAssertion && !isInPubinfo) continue;
            IRI graphURI = isInAssertion ? assertionUriPlaceholder : (isInProvenance ? provUriPlaceholder : pubinfoUriPlaceholder);
            Resource subj = st.getSubject();
            IRI pred = st.getPredicate();
            Value obj = st.getObject();
            if (isInPubinfo && subj.equals(np.getUri()) && SimpleTimestampPattern.isCreationTimeProperty(pred) || isInPubinfo && subj.equals(np.getUri()) && pred.equals(Nanopub.SUPERSEDES)) continue;
            n.add(SimpleValueFactory.getInstance().createStatement(subj, pred, obj, (Resource)graphURI));
        }
        return n;
    }
}

