/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.op.topic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.nanopub.Nanopub;
import org.nanopub.op.Topic;

public class WikipathwaysTopics
implements Topic.TopicHandler {
    @Override
    public String getTopic(Nanopub np) {
        HashMap<Object, Integer> resourceCount = new HashMap<Object, Integer>();
        ArrayList<String> organismNames = new ArrayList<String>();
        ArrayList<String> pathwayIds = new ArrayList<String>();
        for (Statement st : np.getAssertion()) {
            String ps;
            Resource subj = st.getSubject();
            if (subj.equals(np.getUri()) || (ps = st.getPredicate().stringValue()).equals(RDF.TYPE.stringValue()) || ps.equals("http://vocabularies.wikipathways.org/wp#pathwayOntologyTag")) continue;
            if (ps.equals("http://purl.org/dc/terms/isPartOf")) {
                pathwayIds.add(st.getObject().stringValue().replace("http://identifiers.org/wikipathways/", ""));
            }
            if (ps.equals("http://vocabularies.wikipathways.org/wp#organismName")) {
                organismNames.add(st.getObject().stringValue().replace(" ", "_"));
            }
            if (!resourceCount.containsKey(subj)) {
                resourceCount.put(subj, 0);
            }
            resourceCount.put(subj, (Integer)resourceCount.get(subj) + 1);
        }
        int max = 0;
        Object topic = null;
        for (Object r : resourceCount.keySet()) {
            int c = (Integer)resourceCount.get(r);
            if (c > max) {
                topic = r;
                max = c;
                continue;
            }
            if (c != max) continue;
            topic = null;
        }
        String pathways = "";
        if (!pathwayIds.isEmpty()) {
            Collections.sort(pathwayIds);
            for (String s : pathwayIds) {
                pathways = pathways + "|" + s;
            }
        }
        String organisms = "";
        if (!organismNames.isEmpty()) {
            Collections.sort(organismNames);
            for (String s : organismNames) {
                organisms = organisms + "|" + s;
            }
        }
        return topic + ":" + pathways + ":" + organisms;
    }
}

