/*
 * Decompiled with CFR 0.152.
 */
package org.nanopub.trusty;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.trustyuri.TrustyUriException;
import net.trustyuri.TrustyUriResource;
import net.trustyuri.TrustyUriUtils;
import net.trustyuri.rdf.RdfFileContent;
import net.trustyuri.rdf.TransformRdf;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.nanopub.MalformedNanopubException;
import org.nanopub.MultiNanopubRdfHandler;
import org.nanopub.Nanopub;
import org.nanopub.NanopubImpl;
import org.nanopub.NanopubRdfHandler;
import org.nanopub.NanopubUtils;
import org.nanopub.NanopubWithNs;
import org.nanopub.trusty.CrossRefResolver;
import org.nanopub.trusty.TempUriReplacer;

public class MakeTrustyNanopub {
    @Parameter(description="input-nanopub-files", required=true)
    private List<String> inputFileNames;
    @Parameter(names={"-o"}, description="Output file")
    private File singleOutputFile;
    @Parameter(names={"-r"}, description="Resolve cross-nanopub references")
    private boolean resolveCrossRefs = false;
    @Parameter(names={"-R"}, description="Resolve cross-nanopub references based on prefixes")
    private boolean resolveCrossRefsPrefixBased = false;
    @Parameter(names={"-v"}, description="Verbose")
    private boolean verbose = false;

    public static void main(String[] args) {
        NanopubImpl.ensureLoaded();
        MakeTrustyNanopub obj = new MakeTrustyNanopub();
        JCommander jc = new JCommander(obj);
        try {
            jc.parse(args);
        }
        catch (ParameterException ex) {
            jc.usage();
            System.exit(1);
        }
        try {
            obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException, TrustyUriException {
        HashMap tempRefMap;
        HashMap tempPrefixMap;
        if (this.resolveCrossRefsPrefixBased) {
            tempPrefixMap = new HashMap();
            tempRefMap = new HashMap();
        } else if (this.resolveCrossRefs) {
            tempPrefixMap = null;
            tempRefMap = new HashMap();
        } else {
            tempPrefixMap = null;
            tempRefMap = null;
        }
        OutputStream singleOut = this.singleOutputFile != null ? (this.singleOutputFile.getName().matches(".*\\.(gz|gzip)") ? new GZIPOutputStream(new FileOutputStream(this.singleOutputFile)) : new FileOutputStream(this.singleOutputFile)) : null;
        for (String inputFileName : this.inputFileNames) {
            OutputStream out;
            File outputFile;
            File inputFile = new File(inputFileName);
            if (this.singleOutputFile == null) {
                outputFile = new File(inputFile.getParent(), "trusty." + inputFile.getName());
                out = inputFile.getName().matches(".*\\.(gz|gzip)") ? new GZIPOutputStream(new FileOutputStream(outputFile)) : new FileOutputStream(outputFile);
            } else {
                outputFile = this.singleOutputFile;
                out = singleOut;
            }
            RDFFormat inFormat = new TrustyUriResource(inputFile).getFormat(RDFFormat.TRIG);
            final RDFFormat outFormat = new TrustyUriResource(outputFile).getFormat(RDFFormat.TRIG);
            MultiNanopubRdfHandler.process(inFormat, inputFile, new MultiNanopubRdfHandler.NanopubHandler(){

                @Override
                public void handleNanopub(Nanopub np) {
                    try {
                        np = MakeTrustyNanopub.writeAsTrustyNanopub(np, outFormat, out, tempRefMap, tempPrefixMap);
                        if (MakeTrustyNanopub.this.verbose) {
                            System.out.println("Nanopub URI: " + np.getUri());
                        }
                    }
                    catch (TrustyUriException | RDFHandlerException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            if (this.singleOutputFile != null) continue;
            out.close();
        }
        if (this.singleOutputFile != null) {
            ((OutputStream)singleOut).close();
        }
    }

    public static Nanopub transform(Nanopub nanopub) throws TrustyUriException {
        return MakeTrustyNanopub.transform(nanopub, null, null);
    }

    public static Nanopub transform(Nanopub nanopub, Map<Resource, IRI> tempRefMap, Map<String, String> tempPrefixMap) throws TrustyUriException {
        Nanopub np;
        String u = nanopub.getUri().stringValue();
        if (!(nanopub.getHeadUri().stringValue().startsWith(u) && nanopub.getAssertionUri().stringValue().startsWith(u) && nanopub.getProvenanceUri().stringValue().startsWith(u) && nanopub.getPubinfoUri().stringValue().startsWith(u))) {
            throw new TrustyUriException("Graph URIs need have the nanopub URI as prefix: " + u + "...");
        }
        try {
            String npUri;
            RdfFileContent r = new RdfFileContent(RDFFormat.TRIG);
            HashMap<Resource, IRI> tempUriReplacerMap = null;
            if (TempUriReplacer.hasTempUri(nanopub)) {
                npUri = "http://purl.org/np/ARTIFACTCODE-PLACEHOLDER/";
                tempUriReplacerMap = new HashMap<Resource, IRI>();
                NanopubUtils.propagateToHandler(nanopub, new TempUriReplacer(nanopub, r, tempUriReplacerMap));
            } else {
                npUri = nanopub.getUri().toString();
                NanopubUtils.propagateToHandler(nanopub, r);
            }
            if (tempRefMap != null || tempPrefixMap != null) {
                if (tempRefMap == null) {
                    tempRefMap = new HashMap<Resource, IRI>();
                }
                MakeTrustyNanopub.mergeTransformMaps(tempRefMap, tempUriReplacerMap);
                RdfFileContent r2 = new RdfFileContent(RDFFormat.TRIG);
                r.propagate(new CrossRefResolver(tempRefMap, tempPrefixMap, r2));
                r = r2;
            }
            NanopubRdfHandler h = new NanopubRdfHandler();
            Map<Resource, IRI> transformMap = TransformRdf.transformAndGetMap(r, h, npUri);
            np = h.getNanopub();
            MakeTrustyNanopub.mergeTransformMaps(tempRefMap, transformMap);
            MakeTrustyNanopub.mergePrefixTransformMaps(tempPrefixMap, transformMap);
        }
        catch (RDFHandlerException ex) {
            throw new TrustyUriException(ex);
        }
        catch (MalformedNanopubException ex) {
            throw new TrustyUriException(ex);
        }
        if (np instanceof NanopubWithNs) {
            ((NanopubWithNs)np).removeUnusedPrefixes();
        }
        return np;
    }

    public static void transformMultiNanopub(RDFFormat format, File file, OutputStream out) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        MakeTrustyNanopub.transformMultiNanopub(format, file, out, false);
    }

    public static void transformMultiNanopub(RDFFormat format, File file, OutputStream out, boolean resolveCrossRefs) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        FileInputStream in = new FileInputStream(file);
        MakeTrustyNanopub.transformMultiNanopub(format, in, out, resolveCrossRefs);
    }

    public static void transformMultiNanopub(RDFFormat format, InputStream in, OutputStream out) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        MakeTrustyNanopub.transformMultiNanopub(format, in, out, false);
    }

    public static void transformMultiNanopub(final RDFFormat format, InputStream in, final OutputStream out, boolean resolveCrossRefs) throws IOException, RDFParseException, RDFHandlerException, MalformedNanopubException {
        final HashMap tempRefMap = resolveCrossRefs ? new HashMap() : null;
        MultiNanopubRdfHandler.process(format, in, new MultiNanopubRdfHandler.NanopubHandler(){

            @Override
            public void handleNanopub(Nanopub np) {
                try {
                    MakeTrustyNanopub.writeAsTrustyNanopub(np, format, out, tempRefMap, null);
                }
                catch (RDFHandlerException ex) {
                    throw new RuntimeException(ex);
                }
                catch (TrustyUriException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        out.close();
    }

    public static Nanopub writeAsTrustyNanopub(Nanopub np, RDFFormat format, OutputStream out, Map<Resource, IRI> tempRefMap, Map<String, String> tempPrefixMap) throws RDFHandlerException, TrustyUriException {
        np = MakeTrustyNanopub.transform(np, tempRefMap, tempPrefixMap);
        RDFWriter w = Rio.createWriter(format, new OutputStreamWriter(out, Charset.forName("UTF-8")));
        NanopubUtils.propagateToHandler(np, w);
        return np;
    }

    static void mergeTransformMaps(Map<Resource, IRI> mainMap, Map<Resource, IRI> mapToMerge) {
        if (mainMap == null || mapToMerge == null) {
            return;
        }
        for (Resource r : new HashSet<Resource>(mainMap.keySet())) {
            IRI v = mainMap.get(r);
            if (!mapToMerge.containsKey(v)) continue;
            mainMap.put(r, mapToMerge.get(v));
            mapToMerge.remove(v);
        }
        for (Resource r : mapToMerge.keySet()) {
            mainMap.put(r, mapToMerge.get(r));
        }
    }

    static void mergePrefixTransformMaps(Map<String, String> mainPrefixMap, Map<Resource, IRI> mapToMerge) {
        if (mainPrefixMap == null || mapToMerge == null) {
            return;
        }
        for (Resource r : mapToMerge.keySet()) {
            if (!(r instanceof IRI) || !TrustyUriUtils.isPotentialTrustyUri(mapToMerge.get(r).stringValue())) continue;
            mainPrefixMap.put(r.stringValue(), mapToMerge.get(r).stringValue());
        }
    }
}

