#!python
# distutils: define_macros=NPY_NO_DEPRECATED_API=NPY_1_7_API_VERSION
# cython: language_level=3
# cython: cpow=True
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
from typing import Optional
import numpy
cimport numpy
from libc.math cimport exp, fabs, log, sin, cos, tan, tanh, asin, acos, atan, isnan, isinf
from libc.math cimport NAN as nan
from libc.math cimport INFINITY as inf
import cython
from cpython.mem cimport PyMem_Malloc
from cpython.mem cimport PyMem_Realloc
from cpython.mem cimport PyMem_Free
from hydpy.cythons.autogen cimport configutils
from hydpy.cythons.autogen cimport interfaceutils
from hydpy.cythons.autogen cimport interputils
from hydpy.cythons.autogen import pointerutils
from hydpy.cythons.autogen cimport pointerutils
from hydpy.cythons.autogen cimport quadutils
from hydpy.cythons.autogen cimport rootutils
from hydpy.cythons.autogen cimport smoothutils
from hydpy.cythons.autogen cimport masterinterface
ctypedef void (*CallbackType) (Model)  noexcept nogil
cdef class CallbackWrapper:
    cdef CallbackType callback
@cython.final
cdef class Parameters:
    cdef public ControlParameters control
    cdef public DerivedParameters derived
@cython.final
cdef class ControlParameters:
    cdef public numpy.int64_t nmbhru
    cdef public double[:] hruarea
    cdef public double[:] temperatureaddend
@cython.final
cdef class DerivedParameters:
    cdef public double[:] hruareafraction
@cython.final
cdef class Sequences:
    cdef public InputSequences inputs
    cdef public FactorSequences factors
@cython.final
cdef class InputSequences:
    cdef public double temperature
    cdef public numpy.int64_t _temperature_ndim
    cdef public numpy.int64_t _temperature_length
    cdef public bint _temperature_ramflag
    cdef public double[:] _temperature_array
    cdef public bint _temperature_diskflag_reading
    cdef public bint _temperature_diskflag_writing
    cdef public double[:] _temperature_ncarray
    cdef public bint _temperature_inputflag
    cdef double *_temperature_inputpointer
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline set_pointerinput(self, str name, pointerutils.PDouble value)
@cython.final
cdef class FactorSequences:
    cdef public double[:] temperature
    cdef public numpy.int64_t _temperature_ndim
    cdef public numpy.int64_t _temperature_length
    cdef public numpy.int64_t _temperature_length_0
    cdef public bint _temperature_ramflag
    cdef public double[:,:] _temperature_array
    cdef public bint _temperature_diskflag_reading
    cdef public bint _temperature_diskflag_writing
    cdef public double[:] _temperature_ncarray
    cdef public double meantemperature
    cdef public numpy.int64_t _meantemperature_ndim
    cdef public numpy.int64_t _meantemperature_length
    cdef public bint _meantemperature_ramflag
    cdef public double[:] _meantemperature_array
    cdef public bint _meantemperature_diskflag_reading
    cdef public bint _meantemperature_diskflag_writing
    cdef public double[:] _meantemperature_ncarray
    cdef public bint _meantemperature_outputflag
    cdef double *_meantemperature_outputpointer
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value)
    cpdef inline void update_outputs(self) noexcept nogil
@cython.final
cdef class Model(masterinterface.MasterInterface):
    cdef public numpy.npy_bool threading
    cdef public Parameters parameters
    cdef public Sequences sequences
    cpdef inline void simulate(self, numpy.int64_t idx)  noexcept nogil
    cpdef void simulate_period(self, numpy.int64_t i0, numpy.int64_t i1)  noexcept nogil
    cpdef void reset_reuseflags(self) noexcept nogil
    cpdef void load_data(self, numpy.int64_t idx) noexcept nogil
    cpdef void save_data(self, numpy.int64_t idx) noexcept nogil
    cpdef inline void run(self) noexcept nogil
    cpdef void update_inlets(self) noexcept nogil
    cpdef void update_outlets(self) noexcept nogil
    cpdef void update_receivers(self, numpy.int64_t idx) noexcept nogil
    cpdef void update_senders(self, numpy.int64_t idx) noexcept nogil
    cpdef void update_outputs(self) noexcept nogil
    cpdef inline void calc_temperature_v1(self) noexcept nogil
    cpdef inline void adjust_temperature_v1(self) noexcept nogil
    cpdef inline void calc_meantemperature_v1(self) noexcept nogil
    cpdef void determine_temperature_v1(self) noexcept nogil
    cpdef double get_temperature_v1(self, numpy.int64_t s) noexcept nogil
    cpdef double get_meantemperature_v1(self) noexcept nogil
    cpdef inline void calc_temperature(self) noexcept nogil
    cpdef inline void adjust_temperature(self) noexcept nogil
    cpdef inline void calc_meantemperature(self) noexcept nogil
    cpdef void determine_temperature(self) noexcept nogil
    cpdef double get_temperature(self, numpy.int64_t s) noexcept nogil
    cpdef double get_meantemperature(self) noexcept nogil
