"""
You want to make a dictionary that is a subset of another dictinary.
"""

from pprint import pprint


def main():
    # example of extracting a subset from a dictionary
    prices = {"ACME": 45.23, "AAPL": 612.78, "IBM": 205.55, "HPQ": 37.20, "FB": 10.75}

    # Make a dictionary of all prices over 200
    p1 = {key: value for key, value in prices.items() if value > 200}

    print("All prices over 200")
    pprint(p1)

    # Make a dictionary of tech stocks
    tech_names = {"AAPL", "IBM", "HPQ", "MSFT"}
    p2 = {key: value for key, value in prices.items() if key in tech_names}

    print("All techs")
    pprint(p2)


if __name__ == "__main__":
    main()
