# -*- coding: utf-8 -*-
"""
Symbols for some (but not all) Mathics primitive names

We put all of this in one place to make it easy to find most of them.

There are other Symbols, such as those for True and False that are
needed in the Symbol class. So those are defined there, not here.

Other modules may also define Symbols which are thought to be
lesser-used, or is will probably only be use in the module where it is
defined. Over time, as we find more uses of these, they are sometimes
moved here.

"""


from mathics.core.symbols import Symbol

# Note that at the time this is evaluated Symbol("System`X")
# is the same as Symbol("X"), but it is better to make this
# explicit. A Pymathics module for example may decide to define
# its own Symbol X that also appears here after System`

# This list is sorted in alphabetic order.
SymbolAborted = Symbol("System`$Aborted")
SymbolAll = Symbol("System`All")
SymbolAlternatives = Symbol("System`Alternatives")
SymbolAnd = Symbol("System`And")
SymbolAppend = Symbol("System`Append")
SymbolApply = Symbol("System`Apply")
SymbolAssociation = Symbol("System`Association")
SymbolAssumptions = Symbol("System`$Assumptions")
SymbolAttributes = Symbol("System`Attributes")
SymbolAutomatic = Symbol("System`Automatic")
SymbolBlank = Symbol("System`Blank")
SymbolBlend = Symbol("System`Blend")
SymbolBreak = Symbol("System`Break")
SymbolByteArray = Symbol("System`ByteArray")
SymbolC = Symbol("System`C")
SymbolCatalan = Symbol("System`Cases")
SymbolCatalan = Symbol("System`Catalan")
SymbolCeiling = Symbol("System`Ceiling")
SymbolColorConvert = Symbol("System`ColorConvert")
SymbolColorData = Symbol("System`ColorData")
SymbolCompile = Symbol("System`Compile")
SymbolComplex = Symbol("System`Complex")
SymbolComplexInfinity = Symbol("System`ComplexInfinity")
SymbolCondition = Symbol("System`Condition")
SymbolConditionalExpression = Symbol("System`ConditionalExpression")
SymbolConjugate = Symbol("System`Conjugate")
SymbolContext = Symbol("System`$Context")
SymbolContextPath = Symbol("System`$ContextPath")
SymbolContinue = Symbol("System`Continue")
SymbolCos = Symbol("System`Cos")
SymbolD = Symbol("System`D")
SymbolDefinition = Symbol("System`Definition")
SymbolDerivative = Symbol("System`Derivative")
SymbolDirectedInfinity = Symbol("System`DirectedInfinity")
SymbolDispatch = Symbol("System`Dispatch")
SymbolDot = Symbol("System`Dot")
SymbolE = Symbol("System`E")
SymbolEdgeForm = Symbol("System`EdgeForm")
SymbolEqual = Symbol("System`Equal")
SymbolEulerGamma = Symbol("System`EulerGamma")
SymbolExpandAll = Symbol("System`ExpandAll")
SymbolExport = Symbol("System`Export")
SymbolExportString = Symbol("System`ExportString")
SymbolFactorial = Symbol("System`Factorial")
SymbolFailed = Symbol("System`$Failed")
SymbolFloor = Symbol("System`Floor")
SymbolFormat = Symbol("System`Format")
SymbolFullForm = Symbol("System`FullForm")
SymbolFunction = Symbol("System`Function")
SymbolGamma = Symbol("System`Gamma")
SymbolGet = Symbol("System`Get")
SymbolGoldenRatio = Symbol("System`GoldenRatio")
SymbolGraphics = Symbol("System`Graphics")
SymbolGraphics3D = Symbol("System`Graphics3D")
SymbolGreater = Symbol("System`Greater")
SymbolGreaterEqual = Symbol("System`GreaterEqual")
SymbolGrid = Symbol("System`Grid")
SymbolHold = Symbol("System`Hold")
SymbolHoldForm = Symbol("System`HoldForm")
SymbolHoldPattern = Symbol("System`HoldPattern")
SymbolIf = Symbol("System`If")
SymbolIm = Symbol("System`Im")
SymbolImplies = Symbol("System`Implies")
SymbolIn = Symbol("System`In")
SymbolIndeterminate = Symbol("System`Indeterminate")
SymbolInequality = Symbol("System`Inequality")
SymbolInfinity = Symbol("System`Infinity")
SymbolInfix = Symbol("System`Infix")
SymbolInputForm = Symbol("System`InputForm")
SymbolInteger = Symbol("System`Integer")
SymbolIntegrate = Symbol("System`Integrate")
SymbolLeft = Symbol("System`Left")
SymbolLength = Symbol("System`Length")
SymbolLess = Symbol("System`Less")
SymbolLessEqual = Symbol("System`LessEqual")
SymbolLog = Symbol("System`Log")
SymbolMachinePrecision = Symbol("System`MachinePrecision")
SymbolMakeBoxes = Symbol("System`MakeBoxes")
SymbolMap = Symbol("System`Map")
SymbolMatchQ = Symbol("System`MatchQ")
SymbolMatrixPower = Symbol("System`MatrixPower")
SymbolMax = Symbol("System`Max")
SymbolMaxPrecision = Symbol("System`$MaxPrecision")
SymbolMean = Symbol("System`Mean")
SymbolMemberQ = Symbol("System`MemberQ")
SymbolMessageName = Symbol("System`MessageName")
SymbolMinus = Symbol("System`Minus")
SymbolMinus = Symbol("System`Minus")
SymbolMissing = Symbol("System`Missing")
SymbolN = Symbol("System`N")
SymbolNIntegrate = Symbol("System`NIntegrate")
SymbolNeeds = Symbol("System`Needs")
SymbolNone = Symbol("System`None")
SymbolNorm = Symbol("System`Norm")
SymbolNot = Symbol("System`Not")
SymbolNumberQ = Symbol("System`NumberQ")
SymbolNumericQ = Symbol("System`NumericQ")
SymbolO = Symbol("System`O")
SymbolOptionValue = Symbol("System`OptionValue")
SymbolOptions = Symbol("System`Options")
SymbolOr = Symbol("System`Or")
SymbolOut = Symbol("System`Out")
SymbolOutputForm = Symbol("System`OutputForm")
SymbolOverflow = Symbol("System`Overflow")
SymbolPackages = Symbol("System`$Packages")
SymbolPattern = Symbol("System`Pattern")
SymbolPi = Symbol("System`Pi")
SymbolPiecewise = Symbol("System`Piecewise")
SymbolPoint = Symbol("System`Point")
SymbolPolygon = Symbol("System`Polygon")
SymbolPossibleZeroQ = Symbol("System`PossibleZeroQ")
SymbolPrecision = Symbol("System`Precision")
SymbolQuiet = Symbol("System`Quiet")
SymbolRGBColor = Symbol("System`RGBColor")
SymbolRational = Symbol("System`Rational")
SymbolRe = Symbol("System`Re")
SymbolReal = Symbol("System`Real")
SymbolRealDigits = Symbol("System`RealDigits")
SymbolReturn = Symbol("System`Return")
SymbolRound = Symbol("System`Round")
SymbolRow = Symbol("System`Row")
SymbolRowBox = Symbol("System`RowBox")
SymbolRule = Symbol("System`Rule")
SymbolRuleDelayed = Symbol("System`RuleDelayed")
SymbolSameQ = Symbol("System`SameQ")
SymbolSequence = Symbol("System`Sequence")
SymbolSeries = Symbol("System`Series")
SymbolSeriesData = Symbol("System`SeriesData")
SymbolSet = Symbol("System`Set")
SymbolSign = Symbol("System`Sign")
SymbolSimplify = Symbol("System`Simplify")
SymbolSin = Symbol("System`Sin")
SymbolSlot = Symbol("System`Slot")
SymbolStandardForm = Symbol("System`StandardForm")
SymbolStringForm = Symbol("System`StringForm")
SymbolStringQ = Symbol("System`StringQ")
SymbolStyle = Symbol("System`Style")
SymbolSubsetQ = Symbol("System`SubsetQ")
SymbolSubtract = Symbol("System`Subtract")
SymbolSuperscriptBox = Symbol("System`SuperscriptBox")
SymbolTable = Symbol("System`Table")
SymbolThrow = Symbol("System`Throw")
SymbolToString = Symbol("System`ToString")
SymbolTotal = Symbol("System`Total")
SymbolUndefined = Symbol("System`Undefined")
SymbolUnequal = Symbol("System`Unequal")
SymbolUnevaluated = Symbol("System`Unevaluated")
SymbolXor = Symbol("System`Xor")
