# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 apikey: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 verbose: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_credentials: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_file: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] apikey: API Key to use for API authentication. The only valid authentication mechanism for the Elasticsearch Service.
        :param pulumi.Input[_builtins.bool] insecure: Allow the provider to skip TLS validation on its outgoing HTTP calls.
        :param pulumi.Input[_builtins.str] password: Password to use for API authentication. Available only when targeting ECE Installations or Elasticsearch Service Private.
        :param pulumi.Input[_builtins.str] timeout: Timeout used for individual HTTP calls. Defaults to "1m".
        :param pulumi.Input[_builtins.str] username: Username to use for API authentication. Available only when targeting ECE Installations or Elasticsearch Service Private.
        :param pulumi.Input[_builtins.bool] verbose: When set, a "request.log" file will be written with all outgoing HTTP requests. Defaults to "false".
        :param pulumi.Input[_builtins.bool] verbose_credentials: When set with verbose, the contents of the Authorization header will not be redacted. Defaults to "false".
        :param pulumi.Input[_builtins.str] verbose_file: Timeout used for individual HTTP calls. Defaults to "1m".
        """
        if apikey is not None:
            pulumi.set(__self__, "apikey", apikey)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verbose is not None:
            pulumi.set(__self__, "verbose", verbose)
        if verbose_credentials is not None:
            pulumi.set(__self__, "verbose_credentials", verbose_credentials)
        if verbose_file is not None:
            pulumi.set(__self__, "verbose_file", verbose_file)

    @_builtins.property
    @pulumi.getter
    def apikey(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API Key to use for API authentication. The only valid authentication mechanism for the Elasticsearch Service.
        """
        return pulumi.get(self, "apikey")

    @apikey.setter
    def apikey(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "apikey", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow the provider to skip TLS validation on its outgoing HTTP calls.
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password to use for API authentication. Available only when targeting ECE Installations or Elasticsearch Service Private.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timeout used for individual HTTP calls. Defaults to "1m".
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username to use for API authentication. Available only when targeting ECE Installations or Elasticsearch Service Private.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def verbose(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set, a "request.log" file will be written with all outgoing HTTP requests. Defaults to "false".
        """
        return pulumi.get(self, "verbose")

    @verbose.setter
    def verbose(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verbose", value)

    @_builtins.property
    @pulumi.getter(name="verboseCredentials")
    def verbose_credentials(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set with verbose, the contents of the Authorization header will not be redacted. Defaults to "false".
        """
        return pulumi.get(self, "verbose_credentials")

    @verbose_credentials.setter
    def verbose_credentials(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verbose_credentials", value)

    @_builtins.property
    @pulumi.getter(name="verboseFile")
    def verbose_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timeout used for individual HTTP calls. Defaults to "1m".
        """
        return pulumi.get(self, "verbose_file")

    @verbose_file.setter
    def verbose_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verbose_file", value)


@pulumi.type_token("pulumi:providers:ec")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apikey: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 verbose: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_credentials: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_file: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the ec package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] apikey: API Key to use for API authentication. The only valid authentication mechanism for the Elasticsearch Service.
        :param pulumi.Input[_builtins.bool] insecure: Allow the provider to skip TLS validation on its outgoing HTTP calls.
        :param pulumi.Input[_builtins.str] password: Password to use for API authentication. Available only when targeting ECE Installations or Elasticsearch Service Private.
        :param pulumi.Input[_builtins.str] timeout: Timeout used for individual HTTP calls. Defaults to "1m".
        :param pulumi.Input[_builtins.str] username: Username to use for API authentication. Available only when targeting ECE Installations or Elasticsearch Service Private.
        :param pulumi.Input[_builtins.bool] verbose: When set, a "request.log" file will be written with all outgoing HTTP requests. Defaults to "false".
        :param pulumi.Input[_builtins.bool] verbose_credentials: When set with verbose, the contents of the Authorization header will not be redacted. Defaults to "false".
        :param pulumi.Input[_builtins.str] verbose_file: Timeout used for individual HTTP calls. Defaults to "1m".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the ec package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apikey: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 insecure: Optional[pulumi.Input[_builtins.bool]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 verbose: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_credentials: Optional[pulumi.Input[_builtins.bool]] = None,
                 verbose_file: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["apikey"] = None if apikey is None else pulumi.Output.secret(apikey)
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["insecure"] = pulumi.Output.from_input(insecure).apply(pulumi.runtime.to_json) if insecure is not None else None
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["username"] = username
            __props__.__dict__["verbose"] = pulumi.Output.from_input(verbose).apply(pulumi.runtime.to_json) if verbose is not None else None
            __props__.__dict__["verbose_credentials"] = pulumi.Output.from_input(verbose_credentials).apply(pulumi.runtime.to_json) if verbose_credentials is not None else None
            __props__.__dict__["verbose_file"] = verbose_file
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apikey", "password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'ec',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter
    def apikey(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API Key to use for API authentication. The only valid authentication mechanism for the Elasticsearch Service.
        """
        return pulumi.get(self, "apikey")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Password to use for API authentication. Available only when targeting ECE Installations or Elasticsearch Service Private.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Timeout used for individual HTTP calls. Defaults to "1m".
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username to use for API authentication. Available only when targeting ECE Installations or Elasticsearch Service Private.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="verboseFile")
    def verbose_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Timeout used for individual HTTP calls. Defaults to "1m".
        """
        return pulumi.get(self, "verbose_file")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:ec/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

