# generated by fastapi-codegen:
#   filename:  /home/circleci/project/guardicore/connector
#   timestamp: 2025-09-22T10:05:32+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from centra_sdk.utils.gc_serializer import GcSerializer
from pydantic import AwareDatetime, BaseModel, ConfigDict, Field, RootModel

from ..common.common import Connector


class ComponentDetails(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    component_version: Optional[str] = Field(None, alias='component-version')
    public_ip_addresses: Optional[List[str]] = Field(None, alias='public-ip-addresses')
    private_ip_addresses: Optional[List[str]] = Field(
        None, alias='private-ip-addresses'
    )
    hostname: Optional[str] = None
    dc_inventory_revision: int = Field(..., alias='dc-inventory-revision')
    policy_revision: int = Field(..., alias='policy-revision')
    config_revision: Optional[int] = Field(None, alias='config-revision')


class DerivationStatus(Enum):
    SUCCESS = 'success'
    FAILED = 'failed'


class DriftStatus(Enum):
    DRIFT_DETECTED = 'drift_detected'
    REVERT_DRIFT_INPROGRESS = 'revert_drift_inprogress'


class PolicyDriftSummary(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    drift_status: DriftStatus = Field(..., alias='drift-status')
    rules_deleted: Optional[List[str]] = Field(
        None, alias='rules-deleted', description='Rules deleted by non-GC user'
    )
    rules_modified: Optional[List[str]] = Field(
        None, alias='rules-modified', description='Rules modified by non-GC user'
    )
    rules_added: Optional[List[str]] = Field(
        None, alias='rules-added', description='Rules added by non-GC user'
    )


class DerivationFailureReason(Enum):
    UNKNOWN = 'UNKNOWN'
    DENIED = 'DENIED'
    LIMIT = 'LIMIT'


class Status(Enum):
    UP = 'up'
    INITIALIZING = 'initializing'
    CONNECTING = 'connecting'
    STOPPED = 'stopped'
    DOWN = 'down'
    PARTIALLY_UP = 'partially_up'
    ERROR = 'error'
    MISSING = 'missing'
    VERIFYING = 'verifying'
    VERIFICATION_FAILED = 'verification_failed'


class Metric(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    name: str = Field(..., description='the metric that will be added to telegraf')
    value: float
    tag_name: Optional[str] = None
    tag_value: Optional[str] = None


class FlagTypes(Enum):
    CLOUD_APP_NSG_AZURE_NETWORK_API_THROTTLING_LIMIT_REACHED = (
        'CloudAppNsgAzureNetworkApiThrottlingLimitReached'
    )
    CLOUD_APP_NSG_GC_APP_RULE_CONFIGURED_BY_NON_GC_USER = (
        'CloudAppNsgGcAppRuleConfiguredByNonGCUser'
    )
    CLOUD_APP_NSG_SECURITY_RULE_CONFLICT_ERROR = 'CloudAppNsgSecurityRuleConflictError'
    CLOUD_APP_NSG_MAX_PORTS_LIMIT_REACHED = 'CloudAppNsgMaxPortsLimitReached'
    CLOUD_APP_NSG_MAX_IPS_LIMIT_REACHED = 'CloudAppNsgMaxIpsLimitReached'
    CLOUD_APP_NSG_MAX_RULES_LIMIT_REACHED = 'CloudAppNsgMaxRulesLimitReached'
    CLOUD_APP_API_AUTHENTICATION_FAILED = 'CloudAppAPIAuthenticationFailed'
    CLOUD_APP_NON_PROTECTED_RESOURCE_DISCOVERED = (
        'CloudAppNonProtectedResourceDiscovered'
    )
    CLOUD_APP_FLOWLOG_DISABLED_NSG_DISCOVERED = 'CloudAppFlowlogDisabledNSGDiscovered'


class FlagSeverity(Enum):
    ERROR = 'ERROR'
    WARNING = 'WARNING'
    INFORMATION = 'INFORMATION'


class ComponentFlags(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    flag: FlagTypes
    raised_time: AwareDatetime
    severity: FlagSeverity
    description: str
    details: Optional[Dict[str, Any]] = None


class Flags(RootModel[List[ComponentFlags]]):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    root: List[ComponentFlags]

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item


class Severity(Enum):
    INFO = 'info'
    WARNING = 'warning'
    ERROR = 'error'


class SystemEvent(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    source: Connector
    source_id: UUID = Field(..., alias='source-id')
    timestamp: AwareDatetime
    category: Optional[str] = Field(None, examples=['deployment'])
    severity: Severity
    title: str
    message: str
    additional_info: Optional[Dict[str, str]] = Field(
        None, examples=[{'region-code': 'eastus', 'region-name': 'East US'}]
    )


class V1OperationsFlagsGetResponse(RootModel[List[ComponentFlags]]):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    root: List[ComponentFlags]

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item


class ComponentMetrics(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    component_id: UUID = Field(..., alias='component-id')
    component_type: str = Field(..., alias='component-type')
    component_metrics: List[Metric] = Field(..., alias='component-metrics')


class DerivationFailure(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    failure: DerivationFailureReason
    count: int
    description: Optional[str] = None


class V1OperationsMetricsGetResponse(RootModel[List[ComponentMetrics]]):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    root: List[ComponentMetrics] = Field(..., min_length=1)

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item


class PolicyRevisionSummary(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    policy_revision: int = Field(..., alias='policy-revision')
    inventory_revision: int = Field(..., alias='inventory-revision')
    derivation_status: DerivationStatus = Field(..., alias='derivation-status')
    number_of_affected_security_entities: Optional[int] = Field(
        None,
        alias='number-of-affected-security-entities',
        description='NSGs for Azure / SGs for AWS / ..',
    )
    total_derived_rules: int = Field(..., alias='total-derived-rules')
    rules_added: Optional[int] = Field(None, alias='rules-added')
    rules_deleted: Optional[int] = Field(None, alias='rules-deleted')
    derivation_failures: Optional[List[DerivationFailure]] = Field(
        None, alias='derivation-failures'
    )
    policy_drift_summary: Optional[PolicyDriftSummary] = Field(
        None, alias='policy-drift-summary'
    )


class ServiceStatus(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    service_status: Status = Field(..., alias='service-status')
    msg: Optional[str] = None
    additional_info: Optional[Union[PolicyRevisionSummary, Dict[str, Any]]] = Field(
        None, alias='additional-info', description='additional service information'
    )


class ApplicationStatus(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    application_status: Status = Field(..., alias='application-status')
    services_status: Optional[Dict[str, ServiceStatus]] = Field(
        None, alias='services-status'
    )


class ComponentStatus(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    overall_status: Status = Field(..., alias='overall-status')
    applications_status: Optional[Dict[str, ApplicationStatus]] = Field(
        None, alias='applications-status'
    )


class ComponentHealth(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    component_id: UUID = Field(..., alias='component-id')
    component_type: Connector = Field(..., alias='component-type')
    component_details: ComponentDetails = Field(..., alias='component-details')
    status: ComponentStatus
    statistics: Optional[Dict[str, Any]] = None


class V1OperationsHealthGetResponse(RootModel[List[ComponentHealth]]):
    model_config = ConfigDict(
        populate_by_name=True,
        from_attributes=True,
    )
    root: List[ComponentHealth] = Field(..., min_length=1)

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item
