# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-09-22T10:05:32+00:00

from __future__ import annotations

from typing import Annotated

from centra_sdk.utils.handler_registry import HandlerRegistry
from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *

router = APIRouter(tags=['Logging'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class LoggingHandler:
    def __init__(self):
        pass

    async def get_logs(self, id: Optional[UUID] = None) -> bytes:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"get_logs not implemented")

    async def start_logging(self, body: LogStart) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"start_logging not implemented")

    async def get_logging_status(self, id: Optional[UUID] = None) -> LogStatus:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_logging_status not implemented"
        )

    async def stop_logging(self, id: Optional[UUID] = None) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"stop_logging not implemented")


@router.get('/v1/operations/log/download', response_model=bytes, tags=['Logging'])
async def get_logs(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    id: Optional[UUID] = None,
) -> bytes:
    """
    Endpoint to retrieve component logs
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(get_logs.__name__, token, id)


@router.post('/v1/operations/log/start', response_model=None, tags=['Logging'])
async def start_logging(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: LogStart,
) -> None:
    """
    Endpoint for instructing component to gather logs
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(start_logging.__name__, token, body)


@router.get('/v1/operations/log/status', response_model=LogStatus, tags=['Logging'])
async def get_logging_status(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    id: Optional[UUID] = None,
) -> LogStatus:
    """
    Endpoint to query component on logs gathering status
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(get_logging_status.__name__, token, id)


@router.get('/v1/operations/log/stop', response_model=None, tags=['Logging'])
async def stop_logging(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    id: Optional[UUID] = None,
) -> None:
    """
    Endpoint to abort logs gathering
    """

    token = credentials.credentials if credentials else None
    return await registry.call_handler(stop_logging.__name__, token, id)
