# `azurerm_synapse_sql_pool_vulnerability_assessment`

Refer to the Terraform Registory for docs: [`azurerm_synapse_sql_pool_vulnerability_assessment`](https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment).

# `synapseSqlPoolVulnerabilityAssessment` Submodule <a name="`synapseSqlPoolVulnerabilityAssessment` Submodule" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### SynapseSqlPoolVulnerabilityAssessment <a name="SynapseSqlPoolVulnerabilityAssessment" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment"></a>

Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment azurerm_synapse_sql_pool_vulnerability_assessment}.

#### Initializers <a name="Initializers" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_sql_pool_vulnerability_assessment

synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment(
  scope: Construct,
  id: str,
  connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection] = None,
  count: typing.Union[typing.Union[int, float], TerraformCount] = None,
  depends_on: typing.List[ITerraformDependable] = None,
  for_each: ITerraformIterator = None,
  lifecycle: TerraformResourceLifecycle = None,
  provider: TerraformProvider = None,
  provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]] = None,
  sql_pool_security_alert_policy_id: str,
  storage_container_path: str,
  id: str = None,
  recurring_scans: SynapseSqlPoolVulnerabilityAssessmentRecurringScans = None,
  storage_account_access_key: str = None,
  storage_container_sas_key: str = None,
  timeouts: SynapseSqlPoolVulnerabilityAssessmentTimeouts = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.id">id</a></code> | <code>str</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.count">count</a></code> | <code>typing.Union[typing.Union[int, float], cdktf.TerraformCount]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.dependsOn">depends_on</a></code> | <code>typing.List[cdktf.ITerraformDependable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.sqlPoolSecurityAlertPolicyId">sql_pool_security_alert_policy_id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#sql_pool_security_alert_policy_id SynapseSqlPoolVulnerabilityAssessment#sql_pool_security_alert_policy_id}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.storageContainerPath">storage_container_path</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_path SynapseSqlPoolVulnerabilityAssessment#storage_container_path}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.id">id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#id SynapseSqlPoolVulnerabilityAssessment#id}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.recurringScans">recurring_scans</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans">SynapseSqlPoolVulnerabilityAssessmentRecurringScans</a></code> | recurring_scans block. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.storageAccountAccessKey">storage_account_access_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_account_access_key SynapseSqlPoolVulnerabilityAssessment#storage_account_access_key}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.storageContainerSasKey">storage_container_sas_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_sas_key SynapseSqlPoolVulnerabilityAssessment#storage_container_sas_key}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts">SynapseSqlPoolVulnerabilityAssessmentTimeouts</a></code> | timeouts block. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.id"></a>

- *Type:* str

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.connection"></a>

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.count"></a>

- *Type:* typing.Union[typing.Union[int, float], cdktf.TerraformCount]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.dependsOn"></a>

- *Type:* typing.List[cdktf.ITerraformDependable]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.forEach"></a>

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.lifecycle"></a>

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.provider"></a>

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.provisioners"></a>

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `sql_pool_security_alert_policy_id`<sup>Required</sup> <a name="sql_pool_security_alert_policy_id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.sqlPoolSecurityAlertPolicyId"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#sql_pool_security_alert_policy_id SynapseSqlPoolVulnerabilityAssessment#sql_pool_security_alert_policy_id}.

---

##### `storage_container_path`<sup>Required</sup> <a name="storage_container_path" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.storageContainerPath"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_path SynapseSqlPoolVulnerabilityAssessment#storage_container_path}.

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.id"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#id SynapseSqlPoolVulnerabilityAssessment#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `recurring_scans`<sup>Optional</sup> <a name="recurring_scans" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.recurringScans"></a>

- *Type:* <a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans">SynapseSqlPoolVulnerabilityAssessmentRecurringScans</a>

recurring_scans block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#recurring_scans SynapseSqlPoolVulnerabilityAssessment#recurring_scans}

---

##### `storage_account_access_key`<sup>Optional</sup> <a name="storage_account_access_key" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.storageAccountAccessKey"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_account_access_key SynapseSqlPoolVulnerabilityAssessment#storage_account_access_key}.

---

##### `storage_container_sas_key`<sup>Optional</sup> <a name="storage_container_sas_key" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.storageContainerSasKey"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_sas_key SynapseSqlPoolVulnerabilityAssessment#storage_container_sas_key}.

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.Initializer.parameter.timeouts"></a>

- *Type:* <a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts">SynapseSqlPoolVulnerabilityAssessmentTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#timeouts SynapseSqlPoolVulnerabilityAssessment#timeouts}

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.addOverride">add_override</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.overrideLogicalId">override_logical_id</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetOverrideLogicalId">reset_override_logical_id</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.toMetadata">to_metadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.toTerraform">to_terraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putRecurringScans">put_recurring_scans</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putTimeouts">put_timeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetId">reset_id</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetRecurringScans">reset_recurring_scans</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetStorageAccountAccessKey">reset_storage_account_access_key</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetStorageContainerSasKey">reset_storage_container_sas_key</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetTimeouts">reset_timeouts</a></code> | *No description.* |

---

##### `to_string` <a name="to_string" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_override` <a name="add_override" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.addOverride"></a>

```python
def add_override(
  path: str,
  value: typing.Any
) -> None
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.addOverride.parameter.path"></a>

- *Type:* str

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.addOverride.parameter.value"></a>

- *Type:* typing.Any

---

##### `override_logical_id` <a name="override_logical_id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.overrideLogicalId"></a>

```python
def override_logical_id(
  new_logical_id: str
) -> None
```

Overrides the auto-generated logical ID with a specific ID.

###### `new_logical_id`<sup>Required</sup> <a name="new_logical_id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* str

The new logical ID to use for this stack element.

---

##### `reset_override_logical_id` <a name="reset_override_logical_id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetOverrideLogicalId"></a>

```python
def reset_override_logical_id() -> None
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `to_metadata` <a name="to_metadata" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.toMetadata"></a>

```python
def to_metadata() -> typing.Any
```

##### `to_terraform` <a name="to_terraform" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.toTerraform"></a>

```python
def to_terraform() -> typing.Any
```

Adds this resource to the terraform JSON output.

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `put_recurring_scans` <a name="put_recurring_scans" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putRecurringScans"></a>

```python
def put_recurring_scans(
  emails: typing.List[str] = None,
  email_subscription_admins_enabled: typing.Union[bool, IResolvable] = None,
  enabled: typing.Union[bool, IResolvable] = None
) -> None
```

###### `emails`<sup>Optional</sup> <a name="emails" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putRecurringScans.parameter.emails"></a>

- *Type:* typing.List[str]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#emails SynapseSqlPoolVulnerabilityAssessment#emails}.

---

###### `email_subscription_admins_enabled`<sup>Optional</sup> <a name="email_subscription_admins_enabled" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putRecurringScans.parameter.emailSubscriptionAdminsEnabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#email_subscription_admins_enabled SynapseSqlPoolVulnerabilityAssessment#email_subscription_admins_enabled}.

---

###### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putRecurringScans.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#enabled SynapseSqlPoolVulnerabilityAssessment#enabled}.

---

##### `put_timeouts` <a name="put_timeouts" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putTimeouts"></a>

```python
def put_timeouts(
  create: str = None,
  delete: str = None,
  read: str = None,
  update: str = None
) -> None
```

###### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putTimeouts.parameter.create"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#create SynapseSqlPoolVulnerabilityAssessment#create}.

---

###### `delete`<sup>Optional</sup> <a name="delete" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putTimeouts.parameter.delete"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#delete SynapseSqlPoolVulnerabilityAssessment#delete}.

---

###### `read`<sup>Optional</sup> <a name="read" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putTimeouts.parameter.read"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#read SynapseSqlPoolVulnerabilityAssessment#read}.

---

###### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.putTimeouts.parameter.update"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#update SynapseSqlPoolVulnerabilityAssessment#update}.

---

##### `reset_id` <a name="reset_id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetId"></a>

```python
def reset_id() -> None
```

##### `reset_recurring_scans` <a name="reset_recurring_scans" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetRecurringScans"></a>

```python
def reset_recurring_scans() -> None
```

##### `reset_storage_account_access_key` <a name="reset_storage_account_access_key" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetStorageAccountAccessKey"></a>

```python
def reset_storage_account_access_key() -> None
```

##### `reset_storage_container_sas_key` <a name="reset_storage_container_sas_key" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetStorageContainerSasKey"></a>

```python
def reset_storage_container_sas_key() -> None
```

##### `reset_timeouts` <a name="reset_timeouts" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.resetTimeouts"></a>

```python
def reset_timeouts() -> None
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.isTerraformElement">is_terraform_element</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.isTerraformResource">is_terraform_resource</a></code> | *No description.* |

---

##### `is_construct` <a name="is_construct" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.isConstruct"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_sql_pool_vulnerability_assessment

synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

##### `is_terraform_element` <a name="is_terraform_element" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.isTerraformElement"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_sql_pool_vulnerability_assessment

synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.is_terraform_element(
  x: typing.Any
)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.isTerraformElement.parameter.x"></a>

- *Type:* typing.Any

---

##### `is_terraform_resource` <a name="is_terraform_resource" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.isTerraformResource"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_sql_pool_vulnerability_assessment

synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.is_terraform_resource(
  x: typing.Any
)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.isTerraformResource.parameter.x"></a>

- *Type:* typing.Any

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.cdktfStack">cdktf_stack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.friendlyUniqueId">friendly_unique_id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.terraformMetaArguments">terraform_meta_arguments</a></code> | <code>typing.Mapping[typing.Any]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.terraformResourceType">terraform_resource_type</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.terraformGeneratorMetadata">terraform_generator_metadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.count">count</a></code> | <code>typing.Union[typing.Union[int, float], cdktf.TerraformCount]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.dependsOn">depends_on</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.recurringScans">recurring_scans</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference">SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference">SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.idInput">id_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.recurringScansInput">recurring_scans_input</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans">SynapseSqlPoolVulnerabilityAssessmentRecurringScans</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.sqlPoolSecurityAlertPolicyIdInput">sql_pool_security_alert_policy_id_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageAccountAccessKeyInput">storage_account_access_key_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageContainerPathInput">storage_container_path_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageContainerSasKeyInput">storage_container_sas_key_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.timeoutsInput">timeouts_input</a></code> | <code>typing.Union[<a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts">SynapseSqlPoolVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.sqlPoolSecurityAlertPolicyId">sql_pool_security_alert_policy_id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageAccountAccessKey">storage_account_access_key</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageContainerPath">storage_container_path</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageContainerSasKey">storage_container_sas_key</a></code> | <code>str</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktf_stack`<sup>Required</sup> <a name="cdktf_stack" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.cdktfStack"></a>

```python
cdktf_stack: TerraformStack
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `friendly_unique_id`<sup>Required</sup> <a name="friendly_unique_id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.friendlyUniqueId"></a>

```python
friendly_unique_id: str
```

- *Type:* str

---

##### `terraform_meta_arguments`<sup>Required</sup> <a name="terraform_meta_arguments" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.terraformMetaArguments"></a>

```python
terraform_meta_arguments: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]

---

##### `terraform_resource_type`<sup>Required</sup> <a name="terraform_resource_type" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.terraformResourceType"></a>

```python
terraform_resource_type: str
```

- *Type:* str

---

##### `terraform_generator_metadata`<sup>Optional</sup> <a name="terraform_generator_metadata" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.terraformGeneratorMetadata"></a>

```python
terraform_generator_metadata: TerraformProviderGeneratorMetadata
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.connection"></a>

```python
connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection]
```

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.count"></a>

```python
count: typing.Union[typing.Union[int, float], TerraformCount]
```

- *Type:* typing.Union[typing.Union[int, float], cdktf.TerraformCount]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.dependsOn"></a>

```python
depends_on: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.forEach"></a>

```python
for_each: ITerraformIterator
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.lifecycle"></a>

```python
lifecycle: TerraformResourceLifecycle
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.provider"></a>

```python
provider: TerraformProvider
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.provisioners"></a>

```python
provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]
```

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `recurring_scans`<sup>Required</sup> <a name="recurring_scans" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.recurringScans"></a>

```python
recurring_scans: SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference">SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference</a>

---

##### `timeouts`<sup>Required</sup> <a name="timeouts" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.timeouts"></a>

```python
timeouts: SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference">SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference</a>

---

##### `id_input`<sup>Optional</sup> <a name="id_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.idInput"></a>

```python
id_input: str
```

- *Type:* str

---

##### `recurring_scans_input`<sup>Optional</sup> <a name="recurring_scans_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.recurringScansInput"></a>

```python
recurring_scans_input: SynapseSqlPoolVulnerabilityAssessmentRecurringScans
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans">SynapseSqlPoolVulnerabilityAssessmentRecurringScans</a>

---

##### `sql_pool_security_alert_policy_id_input`<sup>Optional</sup> <a name="sql_pool_security_alert_policy_id_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.sqlPoolSecurityAlertPolicyIdInput"></a>

```python
sql_pool_security_alert_policy_id_input: str
```

- *Type:* str

---

##### `storage_account_access_key_input`<sup>Optional</sup> <a name="storage_account_access_key_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageAccountAccessKeyInput"></a>

```python
storage_account_access_key_input: str
```

- *Type:* str

---

##### `storage_container_path_input`<sup>Optional</sup> <a name="storage_container_path_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageContainerPathInput"></a>

```python
storage_container_path_input: str
```

- *Type:* str

---

##### `storage_container_sas_key_input`<sup>Optional</sup> <a name="storage_container_sas_key_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageContainerSasKeyInput"></a>

```python
storage_container_sas_key_input: str
```

- *Type:* str

---

##### `timeouts_input`<sup>Optional</sup> <a name="timeouts_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.timeoutsInput"></a>

```python
timeouts_input: typing.Union[SynapseSqlPoolVulnerabilityAssessmentTimeouts, IResolvable]
```

- *Type:* typing.Union[<a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts">SynapseSqlPoolVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.id"></a>

```python
id: str
```

- *Type:* str

---

##### `sql_pool_security_alert_policy_id`<sup>Required</sup> <a name="sql_pool_security_alert_policy_id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.sqlPoolSecurityAlertPolicyId"></a>

```python
sql_pool_security_alert_policy_id: str
```

- *Type:* str

---

##### `storage_account_access_key`<sup>Required</sup> <a name="storage_account_access_key" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageAccountAccessKey"></a>

```python
storage_account_access_key: str
```

- *Type:* str

---

##### `storage_container_path`<sup>Required</sup> <a name="storage_container_path" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageContainerPath"></a>

```python
storage_container_path: str
```

- *Type:* str

---

##### `storage_container_sas_key`<sup>Required</sup> <a name="storage_container_sas_key" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.storageContainerSasKey"></a>

```python
storage_container_sas_key: str
```

- *Type:* str

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.tfResourceType">tfResourceType</a></code> | <code>str</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessment.property.tfResourceType"></a>

```python
tfResourceType: str
```

- *Type:* str

---

## Structs <a name="Structs" id="Structs"></a>

### SynapseSqlPoolVulnerabilityAssessmentConfig <a name="SynapseSqlPoolVulnerabilityAssessmentConfig" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_sql_pool_vulnerability_assessment

synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig(
  connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection] = None,
  count: typing.Union[typing.Union[int, float], TerraformCount] = None,
  depends_on: typing.List[ITerraformDependable] = None,
  for_each: ITerraformIterator = None,
  lifecycle: TerraformResourceLifecycle = None,
  provider: TerraformProvider = None,
  provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]] = None,
  sql_pool_security_alert_policy_id: str,
  storage_container_path: str,
  id: str = None,
  recurring_scans: SynapseSqlPoolVulnerabilityAssessmentRecurringScans = None,
  storage_account_access_key: str = None,
  storage_container_sas_key: str = None,
  timeouts: SynapseSqlPoolVulnerabilityAssessmentTimeouts = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.count">count</a></code> | <code>typing.Union[typing.Union[int, float], cdktf.TerraformCount]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.dependsOn">depends_on</a></code> | <code>typing.List[cdktf.ITerraformDependable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.sqlPoolSecurityAlertPolicyId">sql_pool_security_alert_policy_id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#sql_pool_security_alert_policy_id SynapseSqlPoolVulnerabilityAssessment#sql_pool_security_alert_policy_id}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.storageContainerPath">storage_container_path</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_path SynapseSqlPoolVulnerabilityAssessment#storage_container_path}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.id">id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#id SynapseSqlPoolVulnerabilityAssessment#id}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.recurringScans">recurring_scans</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans">SynapseSqlPoolVulnerabilityAssessmentRecurringScans</a></code> | recurring_scans block. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.storageAccountAccessKey">storage_account_access_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_account_access_key SynapseSqlPoolVulnerabilityAssessment#storage_account_access_key}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.storageContainerSasKey">storage_container_sas_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_sas_key SynapseSqlPoolVulnerabilityAssessment#storage_container_sas_key}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts">SynapseSqlPoolVulnerabilityAssessmentTimeouts</a></code> | timeouts block. |

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.connection"></a>

```python
connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection]
```

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.count"></a>

```python
count: typing.Union[typing.Union[int, float], TerraformCount]
```

- *Type:* typing.Union[typing.Union[int, float], cdktf.TerraformCount]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.dependsOn"></a>

```python
depends_on: typing.List[ITerraformDependable]
```

- *Type:* typing.List[cdktf.ITerraformDependable]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.forEach"></a>

```python
for_each: ITerraformIterator
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.lifecycle"></a>

```python
lifecycle: TerraformResourceLifecycle
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.provider"></a>

```python
provider: TerraformProvider
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.provisioners"></a>

```python
provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]
```

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `sql_pool_security_alert_policy_id`<sup>Required</sup> <a name="sql_pool_security_alert_policy_id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.sqlPoolSecurityAlertPolicyId"></a>

```python
sql_pool_security_alert_policy_id: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#sql_pool_security_alert_policy_id SynapseSqlPoolVulnerabilityAssessment#sql_pool_security_alert_policy_id}.

---

##### `storage_container_path`<sup>Required</sup> <a name="storage_container_path" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.storageContainerPath"></a>

```python
storage_container_path: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_path SynapseSqlPoolVulnerabilityAssessment#storage_container_path}.

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#id SynapseSqlPoolVulnerabilityAssessment#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `recurring_scans`<sup>Optional</sup> <a name="recurring_scans" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.recurringScans"></a>

```python
recurring_scans: SynapseSqlPoolVulnerabilityAssessmentRecurringScans
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans">SynapseSqlPoolVulnerabilityAssessmentRecurringScans</a>

recurring_scans block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#recurring_scans SynapseSqlPoolVulnerabilityAssessment#recurring_scans}

---

##### `storage_account_access_key`<sup>Optional</sup> <a name="storage_account_access_key" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.storageAccountAccessKey"></a>

```python
storage_account_access_key: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_account_access_key SynapseSqlPoolVulnerabilityAssessment#storage_account_access_key}.

---

##### `storage_container_sas_key`<sup>Optional</sup> <a name="storage_container_sas_key" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.storageContainerSasKey"></a>

```python
storage_container_sas_key: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#storage_container_sas_key SynapseSqlPoolVulnerabilityAssessment#storage_container_sas_key}.

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentConfig.property.timeouts"></a>

```python
timeouts: SynapseSqlPoolVulnerabilityAssessmentTimeouts
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts">SynapseSqlPoolVulnerabilityAssessmentTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#timeouts SynapseSqlPoolVulnerabilityAssessment#timeouts}

---

### SynapseSqlPoolVulnerabilityAssessmentRecurringScans <a name="SynapseSqlPoolVulnerabilityAssessmentRecurringScans" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_sql_pool_vulnerability_assessment

synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans(
  emails: typing.List[str] = None,
  email_subscription_admins_enabled: typing.Union[bool, IResolvable] = None,
  enabled: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans.property.emails">emails</a></code> | <code>typing.List[str]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#emails SynapseSqlPoolVulnerabilityAssessment#emails}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans.property.emailSubscriptionAdminsEnabled">email_subscription_admins_enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#email_subscription_admins_enabled SynapseSqlPoolVulnerabilityAssessment#email_subscription_admins_enabled}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#enabled SynapseSqlPoolVulnerabilityAssessment#enabled}. |

---

##### `emails`<sup>Optional</sup> <a name="emails" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans.property.emails"></a>

```python
emails: typing.List[str]
```

- *Type:* typing.List[str]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#emails SynapseSqlPoolVulnerabilityAssessment#emails}.

---

##### `email_subscription_admins_enabled`<sup>Optional</sup> <a name="email_subscription_admins_enabled" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans.property.emailSubscriptionAdminsEnabled"></a>

```python
email_subscription_admins_enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#email_subscription_admins_enabled SynapseSqlPoolVulnerabilityAssessment#email_subscription_admins_enabled}.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#enabled SynapseSqlPoolVulnerabilityAssessment#enabled}.

---

### SynapseSqlPoolVulnerabilityAssessmentTimeouts <a name="SynapseSqlPoolVulnerabilityAssessmentTimeouts" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_sql_pool_vulnerability_assessment

synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts(
  create: str = None,
  delete: str = None,
  read: str = None,
  update: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts.property.create">create</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#create SynapseSqlPoolVulnerabilityAssessment#create}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts.property.delete">delete</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#delete SynapseSqlPoolVulnerabilityAssessment#delete}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts.property.read">read</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#read SynapseSqlPoolVulnerabilityAssessment#read}. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts.property.update">update</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#update SynapseSqlPoolVulnerabilityAssessment#update}. |

---

##### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts.property.create"></a>

```python
create: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#create SynapseSqlPoolVulnerabilityAssessment#create}.

---

##### `delete`<sup>Optional</sup> <a name="delete" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts.property.delete"></a>

```python
delete: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#delete SynapseSqlPoolVulnerabilityAssessment#delete}.

---

##### `read`<sup>Optional</sup> <a name="read" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts.property.read"></a>

```python
read: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#read SynapseSqlPoolVulnerabilityAssessment#read}.

---

##### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts.property.update"></a>

```python
update: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_sql_pool_vulnerability_assessment#update SynapseSqlPoolVulnerabilityAssessment#update}.

---

## Classes <a name="Classes" id="Classes"></a>

### SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference <a name="SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_sql_pool_vulnerability_assessment

synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.resetEmails">reset_emails</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.resetEmailSubscriptionAdminsEnabled">reset_email_subscription_admins_enabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.resetEnabled">reset_enabled</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_emails` <a name="reset_emails" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.resetEmails"></a>

```python
def reset_emails() -> None
```

##### `reset_email_subscription_admins_enabled` <a name="reset_email_subscription_admins_enabled" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.resetEmailSubscriptionAdminsEnabled"></a>

```python
def reset_email_subscription_admins_enabled() -> None
```

##### `reset_enabled` <a name="reset_enabled" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.resetEnabled"></a>

```python
def reset_enabled() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.emailsInput">emails_input</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsEnabledInput">email_subscription_admins_enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.emails">emails</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsEnabled">email_subscription_admins_enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans">SynapseSqlPoolVulnerabilityAssessmentRecurringScans</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `emails_input`<sup>Optional</sup> <a name="emails_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.emailsInput"></a>

```python
emails_input: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `email_subscription_admins_enabled_input`<sup>Optional</sup> <a name="email_subscription_admins_enabled_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsEnabledInput"></a>

```python
email_subscription_admins_enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `emails`<sup>Required</sup> <a name="emails" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.emails"></a>

```python
emails: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `email_subscription_admins_enabled`<sup>Required</sup> <a name="email_subscription_admins_enabled" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsEnabled"></a>

```python
email_subscription_admins_enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScansOutputReference.property.internalValue"></a>

```python
internal_value: SynapseSqlPoolVulnerabilityAssessmentRecurringScans
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentRecurringScans">SynapseSqlPoolVulnerabilityAssessmentRecurringScans</a>

---


### SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference <a name="SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_sql_pool_vulnerability_assessment

synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resetCreate">reset_create</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resetDelete">reset_delete</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resetRead">reset_read</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resetUpdate">reset_update</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_create` <a name="reset_create" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resetCreate"></a>

```python
def reset_create() -> None
```

##### `reset_delete` <a name="reset_delete" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resetDelete"></a>

```python
def reset_delete() -> None
```

##### `reset_read` <a name="reset_read" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resetRead"></a>

```python
def reset_read() -> None
```

##### `reset_update` <a name="reset_update" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.resetUpdate"></a>

```python
def reset_update() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.createInput">create_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.deleteInput">delete_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.readInput">read_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.updateInput">update_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.create">create</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.delete">delete</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.read">read</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.update">update</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.internalValue">internal_value</a></code> | <code>typing.Union[<a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts">SynapseSqlPoolVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]</code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `create_input`<sup>Optional</sup> <a name="create_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.createInput"></a>

```python
create_input: str
```

- *Type:* str

---

##### `delete_input`<sup>Optional</sup> <a name="delete_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.deleteInput"></a>

```python
delete_input: str
```

- *Type:* str

---

##### `read_input`<sup>Optional</sup> <a name="read_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.readInput"></a>

```python
read_input: str
```

- *Type:* str

---

##### `update_input`<sup>Optional</sup> <a name="update_input" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.updateInput"></a>

```python
update_input: str
```

- *Type:* str

---

##### `create`<sup>Required</sup> <a name="create" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.create"></a>

```python
create: str
```

- *Type:* str

---

##### `delete`<sup>Required</sup> <a name="delete" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.delete"></a>

```python
delete: str
```

- *Type:* str

---

##### `read`<sup>Required</sup> <a name="read" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.read"></a>

```python
read: str
```

- *Type:* str

---

##### `update`<sup>Required</sup> <a name="update" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.update"></a>

```python
update: str
```

- *Type:* str

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeoutsOutputReference.property.internalValue"></a>

```python
internal_value: typing.Union[SynapseSqlPoolVulnerabilityAssessmentTimeouts, IResolvable]
```

- *Type:* typing.Union[<a href="#@cdktf/provider-azurerm.synapseSqlPoolVulnerabilityAssessment.SynapseSqlPoolVulnerabilityAssessmentTimeouts">SynapseSqlPoolVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]

---



