# `azurerm_synapse_workspace_vulnerability_assessment`

Refer to the Terraform Registory for docs: [`azurerm_synapse_workspace_vulnerability_assessment`](https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment).

# `synapseWorkspaceVulnerabilityAssessment` Submodule <a name="`synapseWorkspaceVulnerabilityAssessment` Submodule" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### SynapseWorkspaceVulnerabilityAssessment <a name="SynapseWorkspaceVulnerabilityAssessment" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment"></a>

Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment azurerm_synapse_workspace_vulnerability_assessment}.

#### Initializers <a name="Initializers" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_workspace_vulnerability_assessment

synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment(
  scope: Construct,
  id: str,
  connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection] = None,
  count: typing.Union[typing.Union[int, float], TerraformCount] = None,
  depends_on: typing.List[ITerraformDependable] = None,
  for_each: ITerraformIterator = None,
  lifecycle: TerraformResourceLifecycle = None,
  provider: TerraformProvider = None,
  provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]] = None,
  storage_container_path: str,
  workspace_security_alert_policy_id: str,
  id: str = None,
  recurring_scans: SynapseWorkspaceVulnerabilityAssessmentRecurringScans = None,
  storage_account_access_key: str = None,
  storage_container_sas_key: str = None,
  timeouts: SynapseWorkspaceVulnerabilityAssessmentTimeouts = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.id">id</a></code> | <code>str</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.count">count</a></code> | <code>typing.Union[typing.Union[int, float], cdktf.TerraformCount]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.dependsOn">depends_on</a></code> | <code>typing.List[cdktf.ITerraformDependable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.storageContainerPath">storage_container_path</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_path SynapseWorkspaceVulnerabilityAssessment#storage_container_path}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.workspaceSecurityAlertPolicyId">workspace_security_alert_policy_id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#workspace_security_alert_policy_id SynapseWorkspaceVulnerabilityAssessment#workspace_security_alert_policy_id}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.id">id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#id SynapseWorkspaceVulnerabilityAssessment#id}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.recurringScans">recurring_scans</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans">SynapseWorkspaceVulnerabilityAssessmentRecurringScans</a></code> | recurring_scans block. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.storageAccountAccessKey">storage_account_access_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_account_access_key SynapseWorkspaceVulnerabilityAssessment#storage_account_access_key}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.storageContainerSasKey">storage_container_sas_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_sas_key SynapseWorkspaceVulnerabilityAssessment#storage_container_sas_key}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts">SynapseWorkspaceVulnerabilityAssessmentTimeouts</a></code> | timeouts block. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.id"></a>

- *Type:* str

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.connection"></a>

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.count"></a>

- *Type:* typing.Union[typing.Union[int, float], cdktf.TerraformCount]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.dependsOn"></a>

- *Type:* typing.List[cdktf.ITerraformDependable]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.forEach"></a>

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.lifecycle"></a>

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.provider"></a>

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.provisioners"></a>

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `storage_container_path`<sup>Required</sup> <a name="storage_container_path" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.storageContainerPath"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_path SynapseWorkspaceVulnerabilityAssessment#storage_container_path}.

---

##### `workspace_security_alert_policy_id`<sup>Required</sup> <a name="workspace_security_alert_policy_id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.workspaceSecurityAlertPolicyId"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#workspace_security_alert_policy_id SynapseWorkspaceVulnerabilityAssessment#workspace_security_alert_policy_id}.

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.id"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#id SynapseWorkspaceVulnerabilityAssessment#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `recurring_scans`<sup>Optional</sup> <a name="recurring_scans" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.recurringScans"></a>

- *Type:* <a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans">SynapseWorkspaceVulnerabilityAssessmentRecurringScans</a>

recurring_scans block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#recurring_scans SynapseWorkspaceVulnerabilityAssessment#recurring_scans}

---

##### `storage_account_access_key`<sup>Optional</sup> <a name="storage_account_access_key" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.storageAccountAccessKey"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_account_access_key SynapseWorkspaceVulnerabilityAssessment#storage_account_access_key}.

---

##### `storage_container_sas_key`<sup>Optional</sup> <a name="storage_container_sas_key" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.storageContainerSasKey"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_sas_key SynapseWorkspaceVulnerabilityAssessment#storage_container_sas_key}.

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.Initializer.parameter.timeouts"></a>

- *Type:* <a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts">SynapseWorkspaceVulnerabilityAssessmentTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#timeouts SynapseWorkspaceVulnerabilityAssessment#timeouts}

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.addOverride">add_override</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.overrideLogicalId">override_logical_id</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetOverrideLogicalId">reset_override_logical_id</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.toMetadata">to_metadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.toTerraform">to_terraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putRecurringScans">put_recurring_scans</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putTimeouts">put_timeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetId">reset_id</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetRecurringScans">reset_recurring_scans</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetStorageAccountAccessKey">reset_storage_account_access_key</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetStorageContainerSasKey">reset_storage_container_sas_key</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetTimeouts">reset_timeouts</a></code> | *No description.* |

---

##### `to_string` <a name="to_string" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_override` <a name="add_override" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.addOverride"></a>

```python
def add_override(
  path: str,
  value: typing.Any
) -> None
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.addOverride.parameter.path"></a>

- *Type:* str

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.addOverride.parameter.value"></a>

- *Type:* typing.Any

---

##### `override_logical_id` <a name="override_logical_id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.overrideLogicalId"></a>

```python
def override_logical_id(
  new_logical_id: str
) -> None
```

Overrides the auto-generated logical ID with a specific ID.

###### `new_logical_id`<sup>Required</sup> <a name="new_logical_id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* str

The new logical ID to use for this stack element.

---

##### `reset_override_logical_id` <a name="reset_override_logical_id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetOverrideLogicalId"></a>

```python
def reset_override_logical_id() -> None
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `to_metadata` <a name="to_metadata" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.toMetadata"></a>

```python
def to_metadata() -> typing.Any
```

##### `to_terraform` <a name="to_terraform" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.toTerraform"></a>

```python
def to_terraform() -> typing.Any
```

Adds this resource to the terraform JSON output.

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `put_recurring_scans` <a name="put_recurring_scans" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putRecurringScans"></a>

```python
def put_recurring_scans(
  emails: typing.List[str] = None,
  email_subscription_admins_enabled: typing.Union[bool, IResolvable] = None,
  enabled: typing.Union[bool, IResolvable] = None
) -> None
```

###### `emails`<sup>Optional</sup> <a name="emails" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putRecurringScans.parameter.emails"></a>

- *Type:* typing.List[str]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#emails SynapseWorkspaceVulnerabilityAssessment#emails}.

---

###### `email_subscription_admins_enabled`<sup>Optional</sup> <a name="email_subscription_admins_enabled" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putRecurringScans.parameter.emailSubscriptionAdminsEnabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#email_subscription_admins_enabled SynapseWorkspaceVulnerabilityAssessment#email_subscription_admins_enabled}.

---

###### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putRecurringScans.parameter.enabled"></a>

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#enabled SynapseWorkspaceVulnerabilityAssessment#enabled}.

---

##### `put_timeouts` <a name="put_timeouts" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putTimeouts"></a>

```python
def put_timeouts(
  create: str = None,
  delete: str = None,
  read: str = None,
  update: str = None
) -> None
```

###### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putTimeouts.parameter.create"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#create SynapseWorkspaceVulnerabilityAssessment#create}.

---

###### `delete`<sup>Optional</sup> <a name="delete" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putTimeouts.parameter.delete"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#delete SynapseWorkspaceVulnerabilityAssessment#delete}.

---

###### `read`<sup>Optional</sup> <a name="read" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putTimeouts.parameter.read"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#read SynapseWorkspaceVulnerabilityAssessment#read}.

---

###### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.putTimeouts.parameter.update"></a>

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#update SynapseWorkspaceVulnerabilityAssessment#update}.

---

##### `reset_id` <a name="reset_id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetId"></a>

```python
def reset_id() -> None
```

##### `reset_recurring_scans` <a name="reset_recurring_scans" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetRecurringScans"></a>

```python
def reset_recurring_scans() -> None
```

##### `reset_storage_account_access_key` <a name="reset_storage_account_access_key" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetStorageAccountAccessKey"></a>

```python
def reset_storage_account_access_key() -> None
```

##### `reset_storage_container_sas_key` <a name="reset_storage_container_sas_key" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetStorageContainerSasKey"></a>

```python
def reset_storage_container_sas_key() -> None
```

##### `reset_timeouts` <a name="reset_timeouts" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.resetTimeouts"></a>

```python
def reset_timeouts() -> None
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.isTerraformElement">is_terraform_element</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.isTerraformResource">is_terraform_resource</a></code> | *No description.* |

---

##### `is_construct` <a name="is_construct" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.isConstruct"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_workspace_vulnerability_assessment

synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

##### `is_terraform_element` <a name="is_terraform_element" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.isTerraformElement"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_workspace_vulnerability_assessment

synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.is_terraform_element(
  x: typing.Any
)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.isTerraformElement.parameter.x"></a>

- *Type:* typing.Any

---

##### `is_terraform_resource` <a name="is_terraform_resource" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.isTerraformResource"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_workspace_vulnerability_assessment

synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.is_terraform_resource(
  x: typing.Any
)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.isTerraformResource.parameter.x"></a>

- *Type:* typing.Any

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.cdktfStack">cdktf_stack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.friendlyUniqueId">friendly_unique_id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.terraformMetaArguments">terraform_meta_arguments</a></code> | <code>typing.Mapping[typing.Any]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.terraformResourceType">terraform_resource_type</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.terraformGeneratorMetadata">terraform_generator_metadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.count">count</a></code> | <code>typing.Union[typing.Union[int, float], cdktf.TerraformCount]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.dependsOn">depends_on</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.recurringScans">recurring_scans</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference">SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference">SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.idInput">id_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.recurringScansInput">recurring_scans_input</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans">SynapseWorkspaceVulnerabilityAssessmentRecurringScans</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageAccountAccessKeyInput">storage_account_access_key_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageContainerPathInput">storage_container_path_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageContainerSasKeyInput">storage_container_sas_key_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.timeoutsInput">timeouts_input</a></code> | <code>typing.Union[<a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts">SynapseWorkspaceVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.workspaceSecurityAlertPolicyIdInput">workspace_security_alert_policy_id_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageAccountAccessKey">storage_account_access_key</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageContainerPath">storage_container_path</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageContainerSasKey">storage_container_sas_key</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.workspaceSecurityAlertPolicyId">workspace_security_alert_policy_id</a></code> | <code>str</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktf_stack`<sup>Required</sup> <a name="cdktf_stack" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.cdktfStack"></a>

```python
cdktf_stack: TerraformStack
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `friendly_unique_id`<sup>Required</sup> <a name="friendly_unique_id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.friendlyUniqueId"></a>

```python
friendly_unique_id: str
```

- *Type:* str

---

##### `terraform_meta_arguments`<sup>Required</sup> <a name="terraform_meta_arguments" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.terraformMetaArguments"></a>

```python
terraform_meta_arguments: typing.Mapping[typing.Any]
```

- *Type:* typing.Mapping[typing.Any]

---

##### `terraform_resource_type`<sup>Required</sup> <a name="terraform_resource_type" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.terraformResourceType"></a>

```python
terraform_resource_type: str
```

- *Type:* str

---

##### `terraform_generator_metadata`<sup>Optional</sup> <a name="terraform_generator_metadata" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.terraformGeneratorMetadata"></a>

```python
terraform_generator_metadata: TerraformProviderGeneratorMetadata
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.connection"></a>

```python
connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection]
```

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.count"></a>

```python
count: typing.Union[typing.Union[int, float], TerraformCount]
```

- *Type:* typing.Union[typing.Union[int, float], cdktf.TerraformCount]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.dependsOn"></a>

```python
depends_on: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.forEach"></a>

```python
for_each: ITerraformIterator
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.lifecycle"></a>

```python
lifecycle: TerraformResourceLifecycle
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.provider"></a>

```python
provider: TerraformProvider
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.provisioners"></a>

```python
provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]
```

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `recurring_scans`<sup>Required</sup> <a name="recurring_scans" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.recurringScans"></a>

```python
recurring_scans: SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference">SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference</a>

---

##### `timeouts`<sup>Required</sup> <a name="timeouts" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.timeouts"></a>

```python
timeouts: SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference">SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference</a>

---

##### `id_input`<sup>Optional</sup> <a name="id_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.idInput"></a>

```python
id_input: str
```

- *Type:* str

---

##### `recurring_scans_input`<sup>Optional</sup> <a name="recurring_scans_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.recurringScansInput"></a>

```python
recurring_scans_input: SynapseWorkspaceVulnerabilityAssessmentRecurringScans
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans">SynapseWorkspaceVulnerabilityAssessmentRecurringScans</a>

---

##### `storage_account_access_key_input`<sup>Optional</sup> <a name="storage_account_access_key_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageAccountAccessKeyInput"></a>

```python
storage_account_access_key_input: str
```

- *Type:* str

---

##### `storage_container_path_input`<sup>Optional</sup> <a name="storage_container_path_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageContainerPathInput"></a>

```python
storage_container_path_input: str
```

- *Type:* str

---

##### `storage_container_sas_key_input`<sup>Optional</sup> <a name="storage_container_sas_key_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageContainerSasKeyInput"></a>

```python
storage_container_sas_key_input: str
```

- *Type:* str

---

##### `timeouts_input`<sup>Optional</sup> <a name="timeouts_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.timeoutsInput"></a>

```python
timeouts_input: typing.Union[SynapseWorkspaceVulnerabilityAssessmentTimeouts, IResolvable]
```

- *Type:* typing.Union[<a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts">SynapseWorkspaceVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]

---

##### `workspace_security_alert_policy_id_input`<sup>Optional</sup> <a name="workspace_security_alert_policy_id_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.workspaceSecurityAlertPolicyIdInput"></a>

```python
workspace_security_alert_policy_id_input: str
```

- *Type:* str

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.id"></a>

```python
id: str
```

- *Type:* str

---

##### `storage_account_access_key`<sup>Required</sup> <a name="storage_account_access_key" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageAccountAccessKey"></a>

```python
storage_account_access_key: str
```

- *Type:* str

---

##### `storage_container_path`<sup>Required</sup> <a name="storage_container_path" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageContainerPath"></a>

```python
storage_container_path: str
```

- *Type:* str

---

##### `storage_container_sas_key`<sup>Required</sup> <a name="storage_container_sas_key" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.storageContainerSasKey"></a>

```python
storage_container_sas_key: str
```

- *Type:* str

---

##### `workspace_security_alert_policy_id`<sup>Required</sup> <a name="workspace_security_alert_policy_id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.workspaceSecurityAlertPolicyId"></a>

```python
workspace_security_alert_policy_id: str
```

- *Type:* str

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.tfResourceType">tfResourceType</a></code> | <code>str</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessment.property.tfResourceType"></a>

```python
tfResourceType: str
```

- *Type:* str

---

## Structs <a name="Structs" id="Structs"></a>

### SynapseWorkspaceVulnerabilityAssessmentConfig <a name="SynapseWorkspaceVulnerabilityAssessmentConfig" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_workspace_vulnerability_assessment

synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig(
  connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection] = None,
  count: typing.Union[typing.Union[int, float], TerraformCount] = None,
  depends_on: typing.List[ITerraformDependable] = None,
  for_each: ITerraformIterator = None,
  lifecycle: TerraformResourceLifecycle = None,
  provider: TerraformProvider = None,
  provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]] = None,
  storage_container_path: str,
  workspace_security_alert_policy_id: str,
  id: str = None,
  recurring_scans: SynapseWorkspaceVulnerabilityAssessmentRecurringScans = None,
  storage_account_access_key: str = None,
  storage_container_sas_key: str = None,
  timeouts: SynapseWorkspaceVulnerabilityAssessmentTimeouts = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.connection">connection</a></code> | <code>typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.count">count</a></code> | <code>typing.Union[typing.Union[int, float], cdktf.TerraformCount]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.dependsOn">depends_on</a></code> | <code>typing.List[cdktf.ITerraformDependable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.forEach">for_each</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.provisioners">provisioners</a></code> | <code>typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.storageContainerPath">storage_container_path</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_path SynapseWorkspaceVulnerabilityAssessment#storage_container_path}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.workspaceSecurityAlertPolicyId">workspace_security_alert_policy_id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#workspace_security_alert_policy_id SynapseWorkspaceVulnerabilityAssessment#workspace_security_alert_policy_id}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.id">id</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#id SynapseWorkspaceVulnerabilityAssessment#id}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.recurringScans">recurring_scans</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans">SynapseWorkspaceVulnerabilityAssessmentRecurringScans</a></code> | recurring_scans block. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.storageAccountAccessKey">storage_account_access_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_account_access_key SynapseWorkspaceVulnerabilityAssessment#storage_account_access_key}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.storageContainerSasKey">storage_container_sas_key</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_sas_key SynapseWorkspaceVulnerabilityAssessment#storage_container_sas_key}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts">SynapseWorkspaceVulnerabilityAssessmentTimeouts</a></code> | timeouts block. |

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.connection"></a>

```python
connection: typing.Union[SSHProvisionerConnection, WinrmProvisionerConnection]
```

- *Type:* typing.Union[cdktf.SSHProvisionerConnection, cdktf.WinrmProvisionerConnection]

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.count"></a>

```python
count: typing.Union[typing.Union[int, float], TerraformCount]
```

- *Type:* typing.Union[typing.Union[int, float], cdktf.TerraformCount]

---

##### `depends_on`<sup>Optional</sup> <a name="depends_on" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.dependsOn"></a>

```python
depends_on: typing.List[ITerraformDependable]
```

- *Type:* typing.List[cdktf.ITerraformDependable]

---

##### `for_each`<sup>Optional</sup> <a name="for_each" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.forEach"></a>

```python
for_each: ITerraformIterator
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.lifecycle"></a>

```python
lifecycle: TerraformResourceLifecycle
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.provider"></a>

```python
provider: TerraformProvider
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.provisioners"></a>

```python
provisioners: typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]
```

- *Type:* typing.List[typing.Union[cdktf.FileProvisioner, cdktf.LocalExecProvisioner, cdktf.RemoteExecProvisioner]]

---

##### `storage_container_path`<sup>Required</sup> <a name="storage_container_path" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.storageContainerPath"></a>

```python
storage_container_path: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_path SynapseWorkspaceVulnerabilityAssessment#storage_container_path}.

---

##### `workspace_security_alert_policy_id`<sup>Required</sup> <a name="workspace_security_alert_policy_id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.workspaceSecurityAlertPolicyId"></a>

```python
workspace_security_alert_policy_id: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#workspace_security_alert_policy_id SynapseWorkspaceVulnerabilityAssessment#workspace_security_alert_policy_id}.

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#id SynapseWorkspaceVulnerabilityAssessment#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `recurring_scans`<sup>Optional</sup> <a name="recurring_scans" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.recurringScans"></a>

```python
recurring_scans: SynapseWorkspaceVulnerabilityAssessmentRecurringScans
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans">SynapseWorkspaceVulnerabilityAssessmentRecurringScans</a>

recurring_scans block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#recurring_scans SynapseWorkspaceVulnerabilityAssessment#recurring_scans}

---

##### `storage_account_access_key`<sup>Optional</sup> <a name="storage_account_access_key" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.storageAccountAccessKey"></a>

```python
storage_account_access_key: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_account_access_key SynapseWorkspaceVulnerabilityAssessment#storage_account_access_key}.

---

##### `storage_container_sas_key`<sup>Optional</sup> <a name="storage_container_sas_key" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.storageContainerSasKey"></a>

```python
storage_container_sas_key: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#storage_container_sas_key SynapseWorkspaceVulnerabilityAssessment#storage_container_sas_key}.

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentConfig.property.timeouts"></a>

```python
timeouts: SynapseWorkspaceVulnerabilityAssessmentTimeouts
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts">SynapseWorkspaceVulnerabilityAssessmentTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#timeouts SynapseWorkspaceVulnerabilityAssessment#timeouts}

---

### SynapseWorkspaceVulnerabilityAssessmentRecurringScans <a name="SynapseWorkspaceVulnerabilityAssessmentRecurringScans" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_workspace_vulnerability_assessment

synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans(
  emails: typing.List[str] = None,
  email_subscription_admins_enabled: typing.Union[bool, IResolvable] = None,
  enabled: typing.Union[bool, IResolvable] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans.property.emails">emails</a></code> | <code>typing.List[str]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#emails SynapseWorkspaceVulnerabilityAssessment#emails}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans.property.emailSubscriptionAdminsEnabled">email_subscription_admins_enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#email_subscription_admins_enabled SynapseWorkspaceVulnerabilityAssessment#email_subscription_admins_enabled}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#enabled SynapseWorkspaceVulnerabilityAssessment#enabled}. |

---

##### `emails`<sup>Optional</sup> <a name="emails" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans.property.emails"></a>

```python
emails: typing.List[str]
```

- *Type:* typing.List[str]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#emails SynapseWorkspaceVulnerabilityAssessment#emails}.

---

##### `email_subscription_admins_enabled`<sup>Optional</sup> <a name="email_subscription_admins_enabled" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans.property.emailSubscriptionAdminsEnabled"></a>

```python
email_subscription_admins_enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#email_subscription_admins_enabled SynapseWorkspaceVulnerabilityAssessment#email_subscription_admins_enabled}.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#enabled SynapseWorkspaceVulnerabilityAssessment#enabled}.

---

### SynapseWorkspaceVulnerabilityAssessmentTimeouts <a name="SynapseWorkspaceVulnerabilityAssessmentTimeouts" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_workspace_vulnerability_assessment

synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts(
  create: str = None,
  delete: str = None,
  read: str = None,
  update: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts.property.create">create</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#create SynapseWorkspaceVulnerabilityAssessment#create}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts.property.delete">delete</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#delete SynapseWorkspaceVulnerabilityAssessment#delete}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts.property.read">read</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#read SynapseWorkspaceVulnerabilityAssessment#read}. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts.property.update">update</a></code> | <code>str</code> | Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#update SynapseWorkspaceVulnerabilityAssessment#update}. |

---

##### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts.property.create"></a>

```python
create: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#create SynapseWorkspaceVulnerabilityAssessment#create}.

---

##### `delete`<sup>Optional</sup> <a name="delete" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts.property.delete"></a>

```python
delete: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#delete SynapseWorkspaceVulnerabilityAssessment#delete}.

---

##### `read`<sup>Optional</sup> <a name="read" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts.property.read"></a>

```python
read: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#read SynapseWorkspaceVulnerabilityAssessment#read}.

---

##### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts.property.update"></a>

```python
update: str
```

- *Type:* str

Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/synapse_workspace_vulnerability_assessment#update SynapseWorkspaceVulnerabilityAssessment#update}.

---

## Classes <a name="Classes" id="Classes"></a>

### SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference <a name="SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_workspace_vulnerability_assessment

synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.resetEmails">reset_emails</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.resetEmailSubscriptionAdminsEnabled">reset_email_subscription_admins_enabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.resetEnabled">reset_enabled</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_emails` <a name="reset_emails" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.resetEmails"></a>

```python
def reset_emails() -> None
```

##### `reset_email_subscription_admins_enabled` <a name="reset_email_subscription_admins_enabled" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.resetEmailSubscriptionAdminsEnabled"></a>

```python
def reset_email_subscription_admins_enabled() -> None
```

##### `reset_enabled` <a name="reset_enabled" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.resetEnabled"></a>

```python
def reset_enabled() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.emailsInput">emails_input</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsEnabledInput">email_subscription_admins_enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.enabledInput">enabled_input</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.emails">emails</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsEnabled">email_subscription_admins_enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.enabled">enabled</a></code> | <code>typing.Union[bool, cdktf.IResolvable]</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.internalValue">internal_value</a></code> | <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans">SynapseWorkspaceVulnerabilityAssessmentRecurringScans</a></code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `emails_input`<sup>Optional</sup> <a name="emails_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.emailsInput"></a>

```python
emails_input: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `email_subscription_admins_enabled_input`<sup>Optional</sup> <a name="email_subscription_admins_enabled_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsEnabledInput"></a>

```python
email_subscription_admins_enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled_input`<sup>Optional</sup> <a name="enabled_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.enabledInput"></a>

```python
enabled_input: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `emails`<sup>Required</sup> <a name="emails" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.emails"></a>

```python
emails: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `email_subscription_admins_enabled`<sup>Required</sup> <a name="email_subscription_admins_enabled" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.emailSubscriptionAdminsEnabled"></a>

```python
email_subscription_admins_enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.enabled"></a>

```python
enabled: typing.Union[bool, IResolvable]
```

- *Type:* typing.Union[bool, cdktf.IResolvable]

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScansOutputReference.property.internalValue"></a>

```python
internal_value: SynapseWorkspaceVulnerabilityAssessmentRecurringScans
```

- *Type:* <a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentRecurringScans">SynapseWorkspaceVulnerabilityAssessmentRecurringScans</a>

---


### SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference <a name="SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.Initializer"></a>

```python
from cdktf_cdktf_provider_azurerm import synapse_workspace_vulnerability_assessment

synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference(
  terraform_resource: IInterpolatingParent,
  terraform_attribute: str
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformResource">terraform_resource</a></code> | <code>cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformAttribute">terraform_attribute</a></code> | <code>str</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraform_resource`<sup>Required</sup> <a name="terraform_resource" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* cdktf.IInterpolatingParent

The parent resource.

---

##### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* str

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.computeFqn">compute_fqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getAnyMapAttribute">get_any_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getBooleanAttribute">get_boolean_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getBooleanMapAttribute">get_boolean_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getListAttribute">get_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getNumberAttribute">get_number_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getNumberListAttribute">get_number_list_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getNumberMapAttribute">get_number_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getStringAttribute">get_string_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getStringMapAttribute">get_string_map_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.interpolationForAttribute">interpolation_for_attribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.toString">to_string</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resetCreate">reset_create</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resetDelete">reset_delete</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resetRead">reset_read</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resetUpdate">reset_update</a></code> | *No description.* |

---

##### `compute_fqn` <a name="compute_fqn" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.computeFqn"></a>

```python
def compute_fqn() -> str
```

##### `get_any_map_attribute` <a name="get_any_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getAnyMapAttribute"></a>

```python
def get_any_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Any]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_attribute` <a name="get_boolean_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getBooleanAttribute"></a>

```python
def get_boolean_attribute(
  terraform_attribute: str
) -> IResolvable
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_boolean_map_attribute` <a name="get_boolean_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getBooleanMapAttribute"></a>

```python
def get_boolean_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[bool]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_list_attribute` <a name="get_list_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getListAttribute"></a>

```python
def get_list_attribute(
  terraform_attribute: str
) -> typing.List[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_attribute` <a name="get_number_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getNumberAttribute"></a>

```python
def get_number_attribute(
  terraform_attribute: str
) -> typing.Union[int, float]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_list_attribute` <a name="get_number_list_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getNumberListAttribute"></a>

```python
def get_number_list_attribute(
  terraform_attribute: str
) -> typing.List[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_number_map_attribute` <a name="get_number_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getNumberMapAttribute"></a>

```python
def get_number_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[typing.Union[int, float]]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_attribute` <a name="get_string_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getStringAttribute"></a>

```python
def get_string_attribute(
  terraform_attribute: str
) -> str
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `get_string_map_attribute` <a name="get_string_map_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getStringMapAttribute"></a>

```python
def get_string_map_attribute(
  terraform_attribute: str
) -> typing.Mapping[str]
```

###### `terraform_attribute`<sup>Required</sup> <a name="terraform_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* str

---

##### `interpolation_for_attribute` <a name="interpolation_for_attribute" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.interpolationForAttribute"></a>

```python
def interpolation_for_attribute(
  property: str
) -> IResolvable
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* str

---

##### `resolve` <a name="resolve" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resolve"></a>

```python
def resolve(
  _context: IResolveContext
) -> typing.Any
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resolve.parameter._context"></a>

- *Type:* cdktf.IResolveContext

---

##### `to_string` <a name="to_string" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.toString"></a>

```python
def to_string() -> str
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `reset_create` <a name="reset_create" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resetCreate"></a>

```python
def reset_create() -> None
```

##### `reset_delete` <a name="reset_delete" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resetDelete"></a>

```python
def reset_delete() -> None
```

##### `reset_read` <a name="reset_read" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resetRead"></a>

```python
def reset_read() -> None
```

##### `reset_update` <a name="reset_update" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.resetUpdate"></a>

```python
def reset_update() -> None
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.creationStack">creation_stack</a></code> | <code>typing.List[str]</code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.fqn">fqn</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.createInput">create_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.deleteInput">delete_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.readInput">read_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.updateInput">update_input</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.create">create</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.delete">delete</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.read">read</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.update">update</a></code> | <code>str</code> | *No description.* |
| <code><a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.internalValue">internal_value</a></code> | <code>typing.Union[<a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts">SynapseWorkspaceVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]</code> | *No description.* |

---

##### `creation_stack`<sup>Required</sup> <a name="creation_stack" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.creationStack"></a>

```python
creation_stack: typing.List[str]
```

- *Type:* typing.List[str]

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.fqn"></a>

```python
fqn: str
```

- *Type:* str

---

##### `create_input`<sup>Optional</sup> <a name="create_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.createInput"></a>

```python
create_input: str
```

- *Type:* str

---

##### `delete_input`<sup>Optional</sup> <a name="delete_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.deleteInput"></a>

```python
delete_input: str
```

- *Type:* str

---

##### `read_input`<sup>Optional</sup> <a name="read_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.readInput"></a>

```python
read_input: str
```

- *Type:* str

---

##### `update_input`<sup>Optional</sup> <a name="update_input" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.updateInput"></a>

```python
update_input: str
```

- *Type:* str

---

##### `create`<sup>Required</sup> <a name="create" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.create"></a>

```python
create: str
```

- *Type:* str

---

##### `delete`<sup>Required</sup> <a name="delete" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.delete"></a>

```python
delete: str
```

- *Type:* str

---

##### `read`<sup>Required</sup> <a name="read" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.read"></a>

```python
read: str
```

- *Type:* str

---

##### `update`<sup>Required</sup> <a name="update" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.update"></a>

```python
update: str
```

- *Type:* str

---

##### `internal_value`<sup>Optional</sup> <a name="internal_value" id="@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeoutsOutputReference.property.internalValue"></a>

```python
internal_value: typing.Union[SynapseWorkspaceVulnerabilityAssessmentTimeouts, IResolvable]
```

- *Type:* typing.Union[<a href="#@cdktf/provider-azurerm.synapseWorkspaceVulnerabilityAssessment.SynapseWorkspaceVulnerabilityAssessmentTimeouts">SynapseWorkspaceVulnerabilityAssessmentTimeouts</a>, cdktf.IResolvable]

---



