import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementApiTagDescriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#api_tag_id ApiManagementApiTagDescription#api_tag_id}
    */
    readonly apiTagId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#description ApiManagementApiTagDescription#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#external_documentation_description ApiManagementApiTagDescription#external_documentation_description}
    */
    readonly externalDocumentationDescription?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#external_documentation_url ApiManagementApiTagDescription#external_documentation_url}
    */
    readonly externalDocumentationUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#id ApiManagementApiTagDescription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#timeouts ApiManagementApiTagDescription#timeouts}
    */
    readonly timeouts?: ApiManagementApiTagDescriptionTimeouts;
}
export interface ApiManagementApiTagDescriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#create ApiManagementApiTagDescription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#delete ApiManagementApiTagDescription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#read ApiManagementApiTagDescription#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description#update ApiManagementApiTagDescription#update}
    */
    readonly update?: string;
}
export declare function apiManagementApiTagDescriptionTimeoutsToTerraform(struct?: ApiManagementApiTagDescriptionTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementApiTagDescriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementApiTagDescriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementApiTagDescriptionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description azurerm_api_management_api_tag_description}
*/
export declare class ApiManagementApiTagDescription extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_api_tag_description";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/api_management_api_tag_description azurerm_api_management_api_tag_description} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementApiTagDescriptionConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementApiTagDescriptionConfig);
    private _apiTagId?;
    get apiTagId(): string;
    set apiTagId(value: string);
    get apiTagIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalDocumentationDescription?;
    get externalDocumentationDescription(): string;
    set externalDocumentationDescription(value: string);
    resetExternalDocumentationDescription(): void;
    get externalDocumentationDescriptionInput(): string | undefined;
    private _externalDocumentationUrl?;
    get externalDocumentationUrl(): string;
    set externalDocumentationUrl(value: string);
    resetExternalDocumentationUrl(): void;
    get externalDocumentationUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementApiTagDescriptionTimeoutsOutputReference;
    putTimeouts(value: ApiManagementApiTagDescriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementApiTagDescriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
