import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationWatcherConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#automation_account_id AutomationWatcher#automation_account_id}
    */
    readonly automationAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#description AutomationWatcher#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#etag AutomationWatcher#etag}
    */
    readonly etag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#execution_frequency_in_seconds AutomationWatcher#execution_frequency_in_seconds}
    */
    readonly executionFrequencyInSeconds: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#id AutomationWatcher#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#location AutomationWatcher#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#name AutomationWatcher#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#script_name AutomationWatcher#script_name}
    */
    readonly scriptName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#script_parameters AutomationWatcher#script_parameters}
    */
    readonly scriptParameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#script_run_on AutomationWatcher#script_run_on}
    */
    readonly scriptRunOn: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#tags AutomationWatcher#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#timeouts AutomationWatcher#timeouts}
    */
    readonly timeouts?: AutomationWatcherTimeouts;
}
export interface AutomationWatcherTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#create AutomationWatcher#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#delete AutomationWatcher#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#read AutomationWatcher#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher#update AutomationWatcher#update}
    */
    readonly update?: string;
}
export declare function automationWatcherTimeoutsToTerraform(struct?: AutomationWatcherTimeouts | cdktf.IResolvable): any;
export declare class AutomationWatcherTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationWatcherTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationWatcherTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher azurerm_automation_watcher}
*/
export declare class AutomationWatcher extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_watcher";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/automation_watcher azurerm_automation_watcher} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationWatcherConfig
    */
    constructor(scope: Construct, id: string, config: AutomationWatcherConfig);
    private _automationAccountId?;
    get automationAccountId(): string;
    set automationAccountId(value: string);
    get automationAccountIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    private _executionFrequencyInSeconds?;
    get executionFrequencyInSeconds(): number;
    set executionFrequencyInSeconds(value: number);
    get executionFrequencyInSecondsInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scriptName?;
    get scriptName(): string;
    set scriptName(value: string);
    get scriptNameInput(): string | undefined;
    private _scriptParameters?;
    get scriptParameters(): {
        [key: string]: string;
    };
    set scriptParameters(value: {
        [key: string]: string;
    });
    resetScriptParameters(): void;
    get scriptParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _scriptRunOn?;
    get scriptRunOn(): string;
    set scriptRunOn(value: string);
    get scriptRunOnInput(): string | undefined;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): AutomationWatcherTimeoutsOutputReference;
    putTimeouts(value: AutomationWatcherTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationWatcherTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
