import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BatchAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#allowed_authentication_modes BatchAccount#allowed_authentication_modes}
    */
    readonly allowedAuthenticationModes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#encryption BatchAccount#encryption}
    */
    readonly encryption?: BatchAccountEncryption[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#id BatchAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#location BatchAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#name BatchAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#pool_allocation_mode BatchAccount#pool_allocation_mode}
    */
    readonly poolAllocationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#public_network_access_enabled BatchAccount#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#resource_group_name BatchAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#storage_account_authentication_mode BatchAccount#storage_account_authentication_mode}
    */
    readonly storageAccountAuthenticationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#storage_account_id BatchAccount#storage_account_id}
    */
    readonly storageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#storage_account_node_identity BatchAccount#storage_account_node_identity}
    */
    readonly storageAccountNodeIdentity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#tags BatchAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#identity BatchAccount#identity}
    */
    readonly identity?: BatchAccountIdentity;
    /**
    * key_vault_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#key_vault_reference BatchAccount#key_vault_reference}
    */
    readonly keyVaultReference?: BatchAccountKeyVaultReference;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#timeouts BatchAccount#timeouts}
    */
    readonly timeouts?: BatchAccountTimeouts;
}
export interface BatchAccountEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#key_vault_key_id BatchAccount#key_vault_key_id}
    */
    readonly keyVaultKeyId?: string;
}
export declare function batchAccountEncryptionToTerraform(struct?: BatchAccountEncryption | cdktf.IResolvable): any;
export declare class BatchAccountEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BatchAccountEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: BatchAccountEncryption | cdktf.IResolvable | undefined);
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    resetKeyVaultKeyId(): void;
    get keyVaultKeyIdInput(): string | undefined;
}
export declare class BatchAccountEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BatchAccountEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BatchAccountEncryptionOutputReference;
}
export interface BatchAccountIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#identity_ids BatchAccount#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#type BatchAccount#type}
    */
    readonly type: string;
}
export declare function batchAccountIdentityToTerraform(struct?: BatchAccountIdentityOutputReference | BatchAccountIdentity): any;
export declare class BatchAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchAccountIdentity | undefined;
    set internalValue(value: BatchAccountIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface BatchAccountKeyVaultReference {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#id BatchAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#url BatchAccount#url}
    */
    readonly url: string;
}
export declare function batchAccountKeyVaultReferenceToTerraform(struct?: BatchAccountKeyVaultReferenceOutputReference | BatchAccountKeyVaultReference): any;
export declare class BatchAccountKeyVaultReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchAccountKeyVaultReference | undefined;
    set internalValue(value: BatchAccountKeyVaultReference | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface BatchAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#create BatchAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#delete BatchAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#read BatchAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account#update BatchAccount#update}
    */
    readonly update?: string;
}
export declare function batchAccountTimeoutsToTerraform(struct?: BatchAccountTimeouts | cdktf.IResolvable): any;
export declare class BatchAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BatchAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BatchAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account azurerm_batch_account}
*/
export declare class BatchAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_batch_account";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/batch_account azurerm_batch_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BatchAccountConfig
    */
    constructor(scope: Construct, id: string, config: BatchAccountConfig);
    get accountEndpoint(): string;
    private _allowedAuthenticationModes?;
    get allowedAuthenticationModes(): string[];
    set allowedAuthenticationModes(value: string[]);
    resetAllowedAuthenticationModes(): void;
    get allowedAuthenticationModesInput(): string[] | undefined;
    private _encryption;
    get encryption(): BatchAccountEncryptionList;
    putEncryption(value: BatchAccountEncryption[] | cdktf.IResolvable): void;
    resetEncryption(): void;
    get encryptionInput(): cdktf.IResolvable | BatchAccountEncryption[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _poolAllocationMode?;
    get poolAllocationMode(): string;
    set poolAllocationMode(value: string);
    resetPoolAllocationMode(): void;
    get poolAllocationModeInput(): string | undefined;
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    private _storageAccountAuthenticationMode?;
    get storageAccountAuthenticationMode(): string;
    set storageAccountAuthenticationMode(value: string);
    resetStorageAccountAuthenticationMode(): void;
    get storageAccountAuthenticationModeInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    private _storageAccountNodeIdentity?;
    get storageAccountNodeIdentity(): string;
    set storageAccountNodeIdentity(value: string);
    resetStorageAccountNodeIdentity(): void;
    get storageAccountNodeIdentityInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): BatchAccountIdentityOutputReference;
    putIdentity(value: BatchAccountIdentity): void;
    resetIdentity(): void;
    get identityInput(): BatchAccountIdentity | undefined;
    private _keyVaultReference;
    get keyVaultReference(): BatchAccountKeyVaultReferenceOutputReference;
    putKeyVaultReference(value: BatchAccountKeyVaultReference): void;
    resetKeyVaultReference(): void;
    get keyVaultReferenceInput(): BatchAccountKeyVaultReference | undefined;
    private _timeouts;
    get timeouts(): BatchAccountTimeoutsOutputReference;
    putTimeouts(value: BatchAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BatchAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
