import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BotChannelDirectlineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#bot_name BotChannelDirectline#bot_name}
    */
    readonly botName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#id BotChannelDirectline#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#location BotChannelDirectline#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#resource_group_name BotChannelDirectline#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * site block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#site BotChannelDirectline#site}
    */
    readonly site: BotChannelDirectlineSite[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#timeouts BotChannelDirectline#timeouts}
    */
    readonly timeouts?: BotChannelDirectlineTimeouts;
}
export interface BotChannelDirectlineSite {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#enabled BotChannelDirectline#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#enhanced_authentication_enabled BotChannelDirectline#enhanced_authentication_enabled}
    */
    readonly enhancedAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#name BotChannelDirectline#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#trusted_origins BotChannelDirectline#trusted_origins}
    */
    readonly trustedOrigins?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#v1_allowed BotChannelDirectline#v1_allowed}
    */
    readonly v1Allowed?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#v3_allowed BotChannelDirectline#v3_allowed}
    */
    readonly v3Allowed?: boolean | cdktf.IResolvable;
}
export declare function botChannelDirectlineSiteToTerraform(struct?: BotChannelDirectlineSite | cdktf.IResolvable): any;
export declare class BotChannelDirectlineSiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): BotChannelDirectlineSite | cdktf.IResolvable | undefined;
    set internalValue(value: BotChannelDirectlineSite | cdktf.IResolvable | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enhancedAuthenticationEnabled?;
    get enhancedAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set enhancedAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetEnhancedAuthenticationEnabled(): void;
    get enhancedAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get key(): string;
    get key2(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _trustedOrigins?;
    get trustedOrigins(): string[];
    set trustedOrigins(value: string[]);
    resetTrustedOrigins(): void;
    get trustedOriginsInput(): string[] | undefined;
    private _v1Allowed?;
    get v1Allowed(): boolean | cdktf.IResolvable;
    set v1Allowed(value: boolean | cdktf.IResolvable);
    resetV1Allowed(): void;
    get v1AllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _v3Allowed?;
    get v3Allowed(): boolean | cdktf.IResolvable;
    set v3Allowed(value: boolean | cdktf.IResolvable);
    resetV3Allowed(): void;
    get v3AllowedInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class BotChannelDirectlineSiteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: BotChannelDirectlineSite[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): BotChannelDirectlineSiteOutputReference;
}
export interface BotChannelDirectlineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#create BotChannelDirectline#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#delete BotChannelDirectline#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#read BotChannelDirectline#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline#update BotChannelDirectline#update}
    */
    readonly update?: string;
}
export declare function botChannelDirectlineTimeoutsToTerraform(struct?: BotChannelDirectlineTimeouts | cdktf.IResolvable): any;
export declare class BotChannelDirectlineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BotChannelDirectlineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BotChannelDirectlineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline azurerm_bot_channel_directline}
*/
export declare class BotChannelDirectline extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_bot_channel_directline";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.53.0/docs/resources/bot_channel_directline azurerm_bot_channel_directline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BotChannelDirectlineConfig
    */
    constructor(scope: Construct, id: string, config: BotChannelDirectlineConfig);
    private _botName?;
    get botName(): string;
    set botName(value: string);
    get botNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _site;
    get site(): BotChannelDirectlineSiteList;
    putSite(value: BotChannelDirectlineSite[] | cdktf.IResolvable): void;
    get siteInput(): cdktf.IResolvable | BotChannelDirectlineSite[] | undefined;
    private _timeouts;
    get timeouts(): BotChannelDirectlineTimeoutsOutputReference;
    putTimeouts(value: BotChannelDirectlineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BotChannelDirectlineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
